/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
// O[vrWvWbNENX
// 
//
//	ύX
//	2004.01.08 VK쐬		A.Shimoma
//
package jp.co.ntt.lms.xms.logsumup;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang.StringEscapeUtils;

import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.GroupAndPeople.GroupAndPeopleClient;
import jp.co.ntt.lms.xms.framework.XmsException;
import jp.co.ntt.lms.xms.framework.XmsInnerException;
import jp.co.ntt.lms.xms.framework.XmsSystemException;
import jp.co.ntt.lms.xms.framework.base.Logic;
import jp.co.ntt.lms.xms.framework.base.LogicResult;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.util.DebugLog;

/**
 * OWvO[vrWvWbNENXB<br>
 * 
 * @author shimoma
 */
public class LoLogGroupCompareLogic implements Logic {

	/**
	 * NGXgꂽO[vID̃Xg
	 */
	private List groupList = new ArrayList();

	/**
	 * NGXgꂽLoID
	 */
	private String LoID;

	/**
	 * NGXgꂽO[vID
	 */
	private String baseGroupId;

	/**
	 * NGXgꂽALoID
	 */
	private String realLoID;

	/**
	 * Wvʊi[NX
	 */
	LoLogGroupCompareResult result = new LoLogGroupCompareResult();

	/**
	 * RXgN^B<br>
	 */
	public LoLogGroupCompareLogic() {
	}

	/**
	 * RXgN^B<br>
	 * 
	 * @param groupList ʂőIO[vID̃Xg
	 * @param LoID LOID
	 * @param baseGroupId NGXgꂽO[vID
	 */
	public LoLogGroupCompareLogic(
		List groupList,
		String LoID,
		String baseGroupId,
		String realLoID)
		throws XmsException {

		// p[^`FbN
		if (groupList == null
			|| LoID == null
			|| baseGroupId == null
			|| realLoID == null) {
			throw new XmsInnerException("parameter is null.");
		}

		this.groupList = groupList;
		this.LoID = LoID;
		this.baseGroupId = baseGroupId;
		this.realLoID = realLoID;
	}

	/**
	 * WvWbNE\bhB<br>
	 * ʂIꂽO[v񕪁A<br>A
	 * z̃Of[^擾Wv܂B<br>
	 * 
	 * @param dataAccess DataAccessIuWFNg
	 * @return result Of[^
	 * @exception XmsException
	 * @see LoLogGroupCompareResult
	 */
	public LogicResult doLogic(DataAccess dataAccess) throws XmsException {

		// p[^`FbN
		if (dataAccess == null) {
			throw new XmsInnerException("parameter is null.");
		}

		List groupIdList;

		try {
			GroupAndPeopleClient GapClient = new GroupAndPeopleClient();
			// OʗpCommonNX̐
			LoLogCommon_inc cominc = new LoLogCommon_inc();

			// O[vIDL[AԂlƂnbV}bv̐
			HashMap hmGroupId = new HashMap();

			// ʉʂIꂽO[v̐[v܂B
			// IꂽO[vz̃O[vID擾A
			// ̔z̊wKOWvA
			// ResultNXɏWvʂێ܂B

			for (int i = 0; i < groupList.size(); i++) {

				groupIdList = new ArrayList();

				// IꂽO[vID擾
				String strGroupId = (String) groupList.get(i);

				// O[vƃO[vOID擾
				String[] strGroups = cominc.getGroupDetails(strGroupId);

				// O[vIDL[AlƂnbVɐݒ肷
				hmGroupId.put(strGroupId,Integer.toString(i));

				// GroupIdz̃[U擾
				int intUserCount = GapClient.getUserCount(strGroupId, 0);
				
				// GroupIdz̃O[vID擾
				groupIdList = GapClient.getGroupIdList(strGroupId, groupIdList);

				// OWvʂi[B
				Object[] logList = null;

				// rpks񐔂擾
				int logSqlCount = cominc.getSqlCount(groupIdList);

				// O[v1000ȏ̏ꍇ͕񃋁[v
				// ŒPx̓[vB
				for (int j = 0; j < logSqlCount; j++) {
					// O[vz̃OWv
					logList =
						logSum(realLoID, groupIdList, dataAccess, logList, j);
				}

				// w肵O[vz̃pX擾(O[vł̃pX)
				String strGroupNamePath = cominc.getGroupNamePath(strGroupId);

				// O[vzPʂ̏WvʂresultNXɐݒ肷B
				result.addLog(
					logList,
					intUserCount,
					strGroupId,
					strGroups,
					strGroupNamePath);
			}

			// O[vOIDɕёւׂɁAO[vIDL[AlďB
			setSortGroupForeignId(hmGroupId);

		} catch (XmsException e) {
			throw e;
		} catch (Exception e) {
			throw new XmsSystemException(e);
		}

		return result;
	}

	private void setSortGroupForeignId(HashMap hmGroupForeign) {

		// O[vOIDL[AlƂnbVresultɐݒ肷
		result.setHmGroupForeignId(hmGroupForeign);
		
		// O[vOIDXg擾
		List sortGroupForeignIdList = new ArrayList();
		sortGroupForeignIdList = result.getGroupForeignIdList();
		// f[^NXɐݒ肵ĂO[vID̊OID\[g
		Collections.sort(sortGroupForeignIdList, new GroupIDComparator());
		// \[gO[vOIDXgresultɐݒ肷
		result.setSortGroupForeignIdList(sortGroupForeignIdList);

	}

	/**
	 * 
	 * O[vOhc̃\[g()NX
	 * 
	 * @param  rΏۂ̍ŏ̃IuWFNg
	 *          rΏۂ 2 Ԗڂ̃IuWFNg
	 *
	 * @return ŏ̈ 2 Ԗڂ̈菬ꍇ͕̐B<br>
	 * @@@@@ꍇ 0<br>
	 *          ŏ̈ 2 Ԗڂ̈傫ꍇ͐̐B
	 * 
	 * 
	 */
	class GroupIDComparator implements Comparator {

		public int compare(Object arg0, Object arg1) {

			return compare((List)arg0, (List)arg1);
		}


		public int compare(List groupList0, List groupList1) {

			String groupForeignID0 = null;
			String groupForeignID1 = null;
		
			groupForeignID0 = (String)groupList0.get(1);
			groupForeignID1 = (String)groupList1.get(1);

			return groupForeignID0.compareTo(groupForeignID1);
		}
	}

	/**
	 * O[vzOf[^擾\bh<br>
	 * O[vz̃Of[^f[^x[X擾܂B<br>
	 * 
	 * @param  strLOID        LOID
	 * @param  lstGroupIdList O[vID̃Xg
	 * @param  dataAccess     XMO DAOIuWFNg
	 * @param  logList        Of[^
	 * @return logList        Of[^
	 * @exception XmsException
	 */

	private Object[] logSum(
		String strLOID,
		List lstGroupIdList,
		DataAccess dataAccess,
		Object[] logList,
		int sqlCounter)
		throws XmsException {

		ResultSet rs = null;
		boolean exceptionFlag = false;

		try {

			// [vJnJEg
			int intStart = sqlCounter * 1000;
			// [vIJEg
			int intEnd = intStart + 1000;
			// [vIJEgO[vXgTCY̕ꍇ
			if (lstGroupIdList.size() < intEnd) {
				intEnd = lstGroupIdList.size() - intStart;
			}

			StringBuffer sbSQL = new StringBuffer();

			sbSQL.append("	SELECT ");
			sbSQL.append("	    MIN(LOLog.study_start_date) AS start_date, ");
			// wKJn
			sbSQL.append("	    MAX(LOLog.last_access) AS last_access, ");
			// ŏIANZX
			sbSQL.append("	    SUM(LOLog.Access_cnt) AS access_cnt, ");

			//XMS.init@C[hNX̃CX^X
			Environment objEnv=new Environment();
			//PostgreSQL̏ꍇ
			if(objEnv.getDBType().equals( objEnv.DB_POSTGRE )){
				sbSQL.append("	    ROUND(TO_NUMBER(SUM(LOLog.residanceTime)/60000,'99999999999999D99999999999999'),1) AS sum_residance, ");
			//SQLServeȑꍇ OR Oraclȅꍇ
			}else if(objEnv.getDBType().equals( objEnv.DB_SQLSERVER ) || objEnv.getDBType().equals( objEnv.DB_ORACLE )){
				sbSQL.append("	    ROUND(SUM(LOLog.residanceTime)/60000,1) AS sum_residance, ");
			}

			// ݐϑ؍ݎ
			sbSQL.append("	    COUNT(LOLog.study_end_date) AS end_count, ");
			// CҐ
			sbSQL.append("	    COUNT(LOLog.passday) AS pass_count ");
			// iҐ
			sbSQL.append("	FROM ");
			sbSQL.append("	    LOLog INNER JOIN ");
			sbSQL.append("          GroupAndPeople ON LOLog.UserID = GroupAndPeople.childID ");
			sbSQL.append("	WHERE ");
			sbSQL.append("	    (LOLog.LOID = '" + StringEscapeUtils.escapeSql(strLOID) + "') AND ");
			sbSQL.append("     GroupAndPeople.parentID IN ");

			// groupId , ؂̕ɂ
			for (int i = intStart; i < intEnd; i++) {
				String tempGroupId = (String) lstGroupIdList.get(i);
				if (i == 0) {
					sbSQL.append("('" + StringEscapeUtils.escapeSql(tempGroupId) + "'");
				} else {
					sbSQL.append(",'" + StringEscapeUtils.escapeSql(tempGroupId) + "'");
				}
			}
			sbSQL.append(")");

			DebugLog.write( this.getClass(),sbSQL.toString(), DebugLog.ROW );
			// NG[̎s
			rs = dataAccess.executeQuery(sbSQL.toString());

			// PR[ĥݎ擾
			if (rs.next()) {
				// SQL̃[vPڂ̏ꍇ		
				if (logList == null) {
					logList = new Object[6];
					// wKJn擾
					logList[0] = rs.getTimestamp("start_date");
					// ŏIANZX擾
					logList[1] = rs.getTimestamp("last_access");
					// ANZX񐔂擾
					logList[2] = rs.getString("access_cnt");
					// ݐϑ؍ݎԂ擾
					logList[3] = rs.getString("sum_residance");
					// Ґ擾
					logList[4] = Integer.toString(rs.getInt("end_count"));
					// iҐ擾
					logList[5] = Integer.toString(rs.getInt("pass_count"));

					// SQL̃[vQڈȍ~̏ꍇ
				} else {
					// wKJñO܂Ȃꍇ
					if (logList[0] == null) {
						logList[0] = rs.getTimestamp("start_date");
					// OADB擾f[^̕Âꍇ
					// DB̃f[^ݒ肷
					} else if (
						((Date) logList[0]).after(
							rs.getTimestamp("start_date"))) {
						logList[0] = rs.getTimestamp("start_date");
					}

					// ŏIANZX̃O܂Ȃꍇ
					if (logList[1] == null) {
						logList[1] = rs.getTimestamp("last_access");
					// OADB擾f[^̕Vꍇ
					// DB̃f[^ݒ肷	
					} else if (
						((Date) logList[1]).before(
							rs.getTimestamp("last_access"))) {
						logList[1] = rs.getTimestamp("last_access");

					}
					// ANZX񐔂v(ʂnull̏ꍇ͉Ȃ)
					// nullłȂꍇ
					if (rs.getString("access_cnt") != null) {
						// ܂ł̃ANZX񐔃f[^null̏ꍇ
						if (logList[2] == null) {
							logList[2] = rs.getString("access_cnt");
						// ANZX񐔃f[^ꍇ
						} else {
							logList[2] =
								Integer.toString(
									Integer.parseInt(logList[2].toString())
										+ Integer.parseInt(
											rs.getString("access_cnt")));
						}
					}

					// ݐϑ؍ݎԂv(ʂnull̏ꍇ͉Ȃ)
					if (rs.getString("sum_residance") != null) {
						// ܂ł̗ݐϑ؍ݎԃf[^null̏ꍇ
						if (logList[3] == null) {
							logList[3] = rs.getString("sum_residance");
						// ݐϑ؍ݎԃf[^ꍇ
						} else {
							logList[3] =
								Double.toString(
									Double.parseDouble(logList[3].toString())
										+ Double.parseDouble(rs.getString("sum_residance")));
						}
					}

					// Ґv
					logList[4] =
						Integer.toString(
							Integer.parseInt(logList[4].toString())
								+ rs.getInt("end_count"));
					// iҐv
					logList[5] =
						Integer.toString(
							Integer.parseInt(logList[5].toString())
								+ rs.getInt("pass_count"));
				}
			}
			exceptionFlag = true;

		} catch (Exception e) {
			throw new XmsSystemException(e);
		} finally {
			if (rs != null) {
				try {
					rs.close();
				} catch (Exception e) {
					if (exceptionFlag == true) {
						throw new XmsSystemException(e);
					}
				}
				rs = null;
			}
		}

		return logList;
	}

}
