/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ScormLoLogControl
//	ύX
//		2004.02.01	VK쐬
//      2006.12.01@ύX T.Kiyokawa
//                  IMOXMLeLXg`ɕύXA
//

package jp.co.ntt.lms.lo.scorm;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import jp.co.ntt.lms.Common.status.PropagateControl;
import jp.co.ntt.lms.Common.status.StatusPropagation;
import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.lo.LoLogDataAccess;
import jp.co.ntt.lms.lo.LoLogRecord;
import jp.co.ntt.lms.lo.LoLogSessionDataAccess;
import jp.co.ntt.lms.lo.LoLogSessionRecord;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.Lo.LoClient;
import jp.co.ntt.lms.xmo.util.DebugLog;

// CommentOut Start 2006.11.24 T.Kiyokawa wKOCSV̂
//import org.apache.xpath.XPathAPI;
//import org.w3c.dom.Document;
//import org.w3c.dom.Node;
//import org.w3c.dom.NodeList;
// CommentOut End

/**
 * SCORM wKOo^NXB
 *
 * @author T.Nishiki
 */
public class ScormLoLogControl {

	/**
	 * &lt;scoactivitylog&gt;vf̃pXB
	 */
	public static final String PATH_SCOACTIVITY_LOG =
		"/aicc/scoactivitylog";

	/**
	 * &lt;scoactivitylog&gt;vf&lt;attemptcount&gt;܂ł̑΃pXB
	 */
	public static final String PATH_ATTEMPT_COUNT_FROM_ACTIVITY =
		"./attemptcount";

	/**
	 * &lt;attemptcount&gt;vf&lt;count&gt;̑΃pXB
	 */
	public static final String PATH_ATTEMPT_COUNT_COUNT_ATTRIBUTE =
		"./@count";

	/**
	 * &lt;attemptcount&gt;vf&lt;learnsession&gt;܂ł̑΃pXB
	 */
	public static final String PATH_LEARN_SESSION_FROM_ATTEMPT_COUNT =
		"./learnsession";

	/**
	 * &lt;learnsession&gt;vf&lt;attempt&gt;܂ł̑΃pXB
	 */
	public static final String PATH_ATTEMPT_FROM_LEARN_SESSION
		= "./attempt";

	/**
	 * &lt;learnsession&gt;vf&lt;interaction&gt;܂ł̑΃pXB
	 */
	public static final String PATH_INTERACTION_FROM_LEARN_SESSION =
		"./interactions/interaction";

	/**
	 * &lt;learnsession&gt;vf&lt;learnercomment&gt;܂ł̑΃pXB
	 */
	public static final String PATH_LEARNER_COMMENT_FROM_LEARN_SESSION =
		"./learnercomments/learnercomment";

	/**
	 * &lt;learnsession&gt;vf&lt;lmscomment&gt;܂ł̑΃pXB
	 */
	public static final String PATH_LMS_COMMENT_FROM_LEARN_SESSION =
		"./lmscomments/lmscomment";

	/**
	 * &lt;learnsession&gt;vf&lt;objective&gt;܂ł̑΃pXB
	 */
	public static final String PATH_OBJECTIVE_FROM_LEARN_SESSION =
		"./objectives/objective";

	/**
	 * &lt;scoactivitylog&gt;vfid擾邽߂̃pXB
	 */
	public static final String PATH_ACTIVITY_ID =
		"./@id";

	/**
	 * &lt;learnsession&gt;vfdate擾邽߂̃pXB
	 */
	public static final String PATH_LEARN_SESSION_DATE =
		"./@date";

//	ADD start 2006.11.22 T.Kiyokawa
	/** 
	CSVEԍFSCOANeBreBO
	 */
	public static final int CSVCOL_SCO_ACTIVITY_LOG = 0 ;


	/** 
	CSVEԍFs 
	 */
	public static final int CSVCOL_ATTEMPT_COUNT = 1 ;


	/** 
	CSVEԍFLearnSession
	 */
	public static final int CSVCOL_LEARN_SESSION = 2 ;


	/** 
	CSVEԍFo^e[u
	 */
	public static final int CSVCOL_TABLE_KIND = 3 ;

	/**
	 * e[u:"attempt"
	 */
	private static final String TABLE_KIND_ATTEMPT = "attempt";
	
	/**
	 * e[u:"interaction"
	 */
	private static final String TABLE_KIND_INTERACTION = "interaction";
	
	/**
	 * e[u:"learnerComment"
	 */
	private static final String TABLE_KIND_LEARNER_COMMENT = "learnerComment";
	
	/**
	 * e[u:"lmsComment"
	 */
	private static final String TABLE_KIND_LMS_COMMENT = "lmsComment";

	/**
	 * e[u:"objectives"
	 */
	private static final String TABLE_KIND_OBJECTIVES = "objectives";
//	ADD end

	/**
	 * RXgN^łB<br>
	 */
	public ScormLoLogControl() {
	}

	/**
	 * nꂽI񂩂狤ʃOȂьʃOւ݂̏s܂B<br>
	 *
	 * @param dataAccess f[^ANZXNXB
	 * @param endLearnData wKIB
	 *
	 * @throws LOException f[^x[Xւ̏ɎsꍇB
	 */
	public void insertLog(
		DataAccess dataAccess,
		ScormLoEndLearnData endLearnData)
		throws LOException {

		DebugLog.write(getClass(), "HEAD insertLog()", DebugLog.ROW);
		try {
			// Mod Start 2006.11.24 T.Kiyokawa(aiccLogxmlcsv`ɕύX)
			
//			////////////////////////////////////////////////////////////////////
//			// OXML̎擾ADOM Document
//			String studyLog = endLearnData.getStudyLog();
//			Document studyLogDocument =
//				ScormLoUtil.transformXmlStringToDocument(studyLog);
			////////////////////////////////////////////////////////////////////
			// ʃO̊i[
			insertAiccLog(dataAccess, endLearnData);
//			insertAiccLog(dataAccess, endLearnData, studyLogDocument);
			
			// Mod End 
			////////////////////////////////////////////////////////////////////
			// ʃOe[uXV
			insertRestOfAiccLog(dataAccess, endLearnData);
		}
		catch (LOException e) {
			throw e;
		}
		catch (Exception e) {
			throw new LOException(e.getMessage());
		}
		DebugLog.write(getClass(), "TAIL insertLog()", DebugLog.ROW);
	}

	/**
	 * nꂽI񂩂AICCOɂȂOo^܂B
	 * ʃOȂScormSessionւ݂̏s܂B<br>
	 *
	 * @param dataAccess f[^ANZXNXB
	 * @param endLearnData wKIB
	 *
	 * @throws LOException f[^x[Xւ̏ɎsꍇB
	 */
	public void insertRestOfAiccLog(
		DataAccess dataAccess,
		ScormLoEndLearnData endLearnData)
		throws LOException {

		DebugLog.write(getClass(), "HEAD insertRestOfAiccLog()", DebugLog.ROW);
		try {
			////////////////////////////////////////////////////////////////////
			// ScormSessionf[^x[Xɓo^
			ScormSessionDataAccess.insert(dataAccess, endLearnData);
			////////////////////////////////////////////////////////////////////
			// ʃOLoLogSessione[uXV
			insertLoLogSession(dataAccess, endLearnData);
			////////////////////////////////////////////////////////////////////
			// ʃOLoLoge[uXV
			insertLoLog(dataAccess, endLearnData);
			////////////////////////////////////////////////////////////////////
			// Xe[^X`d
			propagateStatus(endLearnData);
		}
		catch (LOException e) {
			throw e;
		}
		catch (Exception e) {
			throw new LOException(e.getMessage());
		}
		DebugLog.write(getClass(), "TAIL insertRestOfAiccLog()", DebugLog.ROW);
	}
	
	// Add Start T.Kiyokawa 2006.11.24
	/**
	 * nꂽwKOAICCȌ݂s܂B<br>
	 * ScormʃOe[ûAScormSessione[uȊOΏۂƂ܂B
	 *
	 * @param dataAccess f[^ANZXNXB
	 * @param endLearnData wKIB
	 * @param studyLogDocument wKOXML\DOM DocumentB
	 *
	 * @throws LOException f[^x[Xւ̏ɎsꍇB
	 */
	private void insertAiccLog(
		DataAccess dataAccess,
		ScormLoEndLearnData endLearnData)
		throws LOException {

		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			getClass(),
			"HEAD insertAiccLog(dataAccess,endLearnData)",
			DebugLog.ROW);

		try {
			////////////////////////////////////////////////////////////////////
			// őLearnZbV񐔂擾
			Map learnSessionCountMap =
				makeLearnSessionCountMap(dataAccess, endLearnData);
			////////////////////////////////////////////////////////////////////
			// CSVf[^̃GR[h擾
			ScormLoEnv env = new ScormLoEnv() ;
			String csvEncode = env.getCharsetUrlEncode() ;
			////////////////////////////////////////////////////////////////////
			// Os̃f[^ۑϐ
			ScormLoCsvData lastCsv = null ;			 // Osf[^
			int lastPreviousLearnSessionCount= -1 ;	 // O̍őLearnZbV
			int currentLearnSessionCount = 0 ;		 // LearnZbV
			int sameKeyRecordCount = 0 ;			 // L[s̃JE^
			////////////////////////////////////////////////////////////////////
			// CSVf[^sƂɕ
			String[] csvDataRows = new String[0];
			String studyLog = endLearnData.getStudyLog() ;
			if(studyLog!=null)
			{
				csvDataRows = studyLog.split("\r\n") ;
			}
			for (int i = 0; i < csvDataRows.length ; i++) {
				// =============================================================
				// 1sCSVf[^̎擾
				ScormLoCsvData currentCSV = 
					new ScormLoCsvData(csvDataRows[i].split(",", -1),csvEncode);
				// =============================================================
				// ANeBreBID擾܂B
				String activityID = 
					currentCSV.getData(CSVCOL_SCO_ACTIVITY_LOG) ;
				// =============================================================
				// s񐔂擾܂B
				String attemptCountString =
					currentCSV.getData(CSVCOL_ATTEMPT_COUNT) ;
				int attemptCount = Integer.parseInt(attemptCountString);
				//@=============================================================
				// wK擾܂B
				String learnSessionDate = 
					currentCSV.getData(CSVCOL_LEARN_SESSION) ;
				//@=============================================================
				// o^擾܂B
				String tableKind = 
					currentCSV.getData(CSVCOL_TABLE_KIND) ;
				// =============================================================
				// őLearnZbV񐔁iO܂łɓo^񐔁jݒ肵܂B
				int previousLearnSessionCount ;
				if ( isEqualsActidAttcnt(currentCSV, lastCsv) )
				{
					// OsƓANeBreBIDEꎎs񐔂̏ꍇAOs̒lp܂B
					previousLearnSessionCount = lastPreviousLearnSessionCount ;
				}
				else
				{
					// OsƃANeBreBIDEs񐔂قȂꍇAČvZ܂B
					previousLearnSessionCount = getLearnSessionCount(
						learnSessionCountMap, activityID, attemptCount);
				}
				// =============================================================
				// LearnZbV񐔂ݒ肵܂B
				if (!isEqualsActidAttcnt(currentCSV, lastCsv) )
				{
					// ActivityID,s񐔂ȂꍇAZbg
					currentLearnSessionCount = 0 ;
				}
				else if(!currentCSV.equals(lastCsv, CSVCOL_LEARN_SESSION))
				{
					// ActivityID,s񐔂A
					// LearnSessionDateOsƈقȂꍇACNg
					currentLearnSessionCount ++ ;
				}
				// =============================================================
				// L[̍ssAēe[u֑}ꂽJEg܂B
				if ( isEqualsActidAttcntLsndtInstbl(currentCSV, lastCsv) )
				{
					// ꍇ̓CNg܂B
					sameKeyRecordCount ++ ;
				}
				else
				{
					// قȂꍇ̓Zbg܂B
					sameKeyRecordCount = 0 ;
				}
				// =============================================================
				// ZbVJEg擾܂B
				int learnSessionCount = 
					previousLearnSessionCount + currentLearnSessionCount + 1;
				//@=============================================================
				// attemptւ̃f[^o^ 
				if (tableKind.equals(TABLE_KIND_ATTEMPT)) 
				{
					ScormAttemptDataAccess.insert(
						dataAccess, endLearnData,
						currentCSV, activityID,
						attemptCount, learnSessionCount, learnSessionDate);
				}
				// =============================================================
				// interactionւ̃f[^o^ 
				if (tableKind.equals(TABLE_KIND_INTERACTION))
				{
					ScormInteractionDataAccess.insert(
							dataAccess, endLearnData,
							currentCSV, activityID,
							attemptCount, learnSessionCount, 
							sameKeyRecordCount + 1);
				}
				// =============================================================
				// learnerCommentւ̃f[^o^ 
				if (tableKind.equals(TABLE_KIND_LEARNER_COMMENT))
				{
					ScormLearnerCommentDataAccess.insert(
							dataAccess,	endLearnData,
							currentCSV, activityID,
							attemptCount, learnSessionCount, 
							sameKeyRecordCount + 1);
				}
				// =============================================================
				// lmsCommentւ̃f[^o^ 
				if (tableKind.equals(TABLE_KIND_LMS_COMMENT))
				{
					ScormLMSCommentDataAccess.insert(
							dataAccess, endLearnData,
							currentCSV, activityID,
							attemptCount, learnSessionCount, 
							sameKeyRecordCount + 1);
				}
				// =============================================================
				// objectivesւ̃f[^o^ 
				if (tableKind.equals(TABLE_KIND_OBJECTIVES))
				{
					ScormObjectiveDataAccess.insert(
							dataAccess, endLearnData,
							currentCSV, activityID,
							attemptCount, learnSessionCount, 
							sameKeyRecordCount + 1);
				}
				
				// Jgs̃f[^ۑ
				lastCsv = currentCSV ;
				lastPreviousLearnSessionCount = previousLearnSessionCount ;
			}
		}
		catch (LOException e) {
			throw e;
		}
		catch (Exception e) {
			DebugLog.write(getClass(), e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}

		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			getClass(),
			"TAIL insertAiccLog("
				+ "dataAccess,endLearnData)",
			DebugLog.ROW);
	}
	
	/**
	 * ActivityID,s񐔂OsƓr܂B
	 * @param current Jgs
	 * @param last Os
	 * @return Ȃtrue
	 * @throws LOException 
	 */
	private boolean isEqualsActidAttcnt(
			ScormLoCsvData current,
			ScormLoCsvData last) throws LOException
	{
		boolean ret ;
		
		ret = 
			current.equals(last, CSVCOL_SCO_ACTIVITY_LOG) &&
			current.equals(last, CSVCOL_ATTEMPT_COUNT) ;
		
		return ret ;
	}

	/**
	 * CSṼL[ƂȂ񂪒OsƓr܂B<br>
	 * L[ƂȂƂ́AActivityID,s,LearnZbVt,o^Ώۃe[ułB
	 * @param current Jgs
	 * @param last Os
	 * @return Ȃtrue
	 * @throws LOException 
	 */
	private boolean isEqualsActidAttcntLsndtInstbl(
			ScormLoCsvData current,
			ScormLoCsvData last) throws LOException
	{
		boolean ret ;
		
		ret = 
			current.equals(last, CSVCOL_SCO_ACTIVITY_LOG) &&
			current.equals(last, CSVCOL_ATTEMPT_COUNT) && 
			current.equals(last, CSVCOL_LEARN_SESSION) &&
			current.equals(last, CSVCOL_TABLE_KIND) ;
		
		return ret ;
	}
	// Add End 
	
	// Comment Start 2006.11.24 T.Kiyokawa(wKOXMLCSV֕ύX)
//	/**
//	 * nꂽwKOAICCȌ݂s܂B<br>
//	 * ScormʃOe[ûAScormSessione[uȊOΏۂƂ܂B
//	 *
//	 * @param dataAccess f[^ANZXNXB
//	 * @param endLearnData wKIB
//	 * @param studyLogDocument wKOXML\DOM DocumentB
//	 *
//	 * @throws LOException f[^x[Xւ̏ɎsꍇB
//	 */
//	private void insertAiccLog(
//		DataAccess dataAccess,
//		ScormLoEndLearnData endLearnData,
//		Document studyLogDocument)
//		throws LOException {
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhJnO
//		DebugLog.write(
//			getClass(),
//			"HEAD insertAiccLog("
//				+ "dataAccess,endLearnData," + studyLogDocument + ")",
//			DebugLog.ROW);
//
//		try {
//			////////////////////////////////////////////////////////////////////
//			// őLearnZbV񐔂擾
//			Map learnSessionCountMap =
//				makeLearnSessionCountMap(dataAccess, endLearnData);
//			////////////////////////////////////////////////////////////////////
//			// Activitỹ̕O擾Af[^x[Xɓo^
//			NodeList activityLogNodeList =
//				XPathAPI.selectNodeList(studyLogDocument, PATH_SCOACTIVITY_LOG);
//			// ActivityƂɃOo^
//			for (int i = 0; i < activityLogNodeList.getLength(); i++) {
//				Node activityLogNode = activityLogNodeList.item(i);
//				insertActivityLog(dataAccess,
//					endLearnData, activityLogNode, learnSessionCountMap);
//			}
//		}
//		catch (LOException e) {
//			throw e;
//		}
//		catch (Exception e) {
//			DebugLog.write(getClass(), e, DebugLog.HIGHT);
//			throw new LOException(e.getMessage());
//		}
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhIO
//		DebugLog.write(
//			getClass(),
//			"TAIL insertAiccLog("
//				+ "dataAccess,endLearnData," + studyLogDocument + ")",
//			DebugLog.ROW);
//	}
//
//	/**
//	 * wKÔAPANeBreB̃O݂s܂B<br>
//	 * &lt;scoactivitylog&gt;vfƂɌĂяoA
//	 * z̗vfɏ]Aee[uɃR[hǉ܂B<br>
//	 *
//	 * @param dataAccess f[^ANZXNXB
//	 * @param endLearnData wKIB
//	 * @param activityNode &lt;scoactivitylog&gt;vf\m[hB
//	 * @param learnSessionCountMap LearnZbV񐔂̍ől}bvB
//	 * }bv̍\Ao^f[^ɂẮA
//	 * {@link #makeLearnSessionCountMap(DataAccess, ScormLoEndLearnData)}QƁB
//	 *
//	 * @throws LOException f[^x[Xւ̏ɎsꍇB
//	 * @see #makeLearnSessionCountMap(DataAccess, ScormLoEndLearnData)
//	 */
//	private void insertActivityLog(
//		DataAccess dataAccess,
//		ScormLoEndLearnData endLearnData,
//		Node activityNode, Map learnSessionCountMap)
//		throws LOException {
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhJnO
//		DebugLog.write(
//			getClass(),
//			"HEAD insertActivityLog("
//				+ "dataAccess,endLearnData," + activityNode
//				+ ",learnSessionCountMap)",
//			DebugLog.ROW);
//
//		try {
//			// ANeBreBID
//			String activityID = ScormLoUtil.getNodeValue(
//					activityNode, PATH_ACTIVITY_ID);
//			////////////////////////////////////////////////////////////////////
//			// s񐔁iAttemptCountj̃̕O擾Af[^x[Xɓo^
//			NodeList attemptCountNodeList =
//				XPathAPI.selectNodeList(
//					activityNode,
//					PATH_ATTEMPT_COUNT_FROM_ACTIVITY);
//			// s񐔂ƂɃOo^
//			for (int i = 0; i < attemptCountNodeList.getLength(); i++) {
//				Node attemptCountNode = attemptCountNodeList.item(i);
//				insertAttemptCountLog(
//					dataAccess, endLearnData, attemptCountNode,
//					activityID, learnSessionCountMap);
//			}
//		}
//		catch (LOException e) {
//			throw e;
//		}
//		catch (Exception e) {
//			DebugLog.write(getClass(), e, DebugLog.HIGHT);
//			throw new LOException(e.getMessage());
//		}
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhIO
//		DebugLog.write(
//			getClass(),
//			"TAIL insertActivityLog("
//				+ "dataAccess,endLearnData," + activityNode
//				+ ",learnSessionCountMap)",
//			DebugLog.ROW);
//	}
//
//	/**
//	 * wKÔAPsȉ̃O݂s܂B<br>
//	 * &lt;attemptCount&gt;vfƂɌĂяoA
//	 * z̗vfɏ]Aee[uɃR[hǉ܂B<br>
//	 *
//	 * @param dataAccess f[^ANZXNXB
//	 * @param endLearnData wKIB
//	 * @param attemptCountNode &lt;attemptCount&gt;vf\m[hB
//	 * @param activityID f[^ޑΏۂĂANeBreBIDB
//	 * @param learnSessionCountMap LearnZbV񐔂̍ől}bvB
//	 * }bv̍\Ao^f[^ɂẮA
//	 * {@link #makeLearnSessionCountMap(DataAccess, ScormLoEndLearnData)}QƁB
//	 *
//	 * @throws LOException f[^x[Xւ̏ɎsꍇB
//	 * @see #makeLearnSessionCountMap(DataAccess, ScormLoEndLearnData)
//	 */
//	private void insertAttemptCountLog(
//		DataAccess dataAccess,
//		ScormLoEndLearnData endLearnData,
//		Node attemptCountNode,
//		String activityID,
//		Map learnSessionCountMap)
//		throws LOException {
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhJnO
//		DebugLog.write(
//			getClass(),
//			"HEAD insertAttemptCountLog("
//				+ "dataAccess,endLearnData"
//				+ "," + attemptCountNode + "," + activityID
//				+ ",learnSessionCountMap)",
//			DebugLog.ROW);
//
//		try {
//			////////////////////////////////////////////////////////////////////
//			// AttempCountz̃m[hɂēo^܂B
//			// =================================================================
//			// s񐔂擾܂B
//			String attemptCountAttrValue = ScormLoUtil.getNodeValue(
//				attemptCountNode, PATH_ATTEMPT_COUNT_COUNT_ATTRIBUTE);
//			int attemptCount = Integer.parseInt(attemptCountAttrValue);
//			// =================================================================
//			// ANeBreBIDAꎎs񐔂ł
//			// őLearnZbV񐔁iO܂łɓo^񐔁j擾܂B
//			int previousLearnSessionCount = getLearnSessionCount(
//						learnSessionCountMap, activityID, attemptCount);
//			// =================================================================
//			// LearnSessioñ̕O擾Af[^x[Xɓo^
//			NodeList learnSessionNodeList =
//				XPathAPI.selectNodeList(
//					attemptCountNode,
//					PATH_LEARN_SESSION_FROM_ATTEMPT_COUNT);
//			// =================================================================
//			// LearnSessionƂɃOo^
//			for (int i = 0; i < learnSessionNodeList.getLength(); i++) {
//				Node learnSessionNode = learnSessionNodeList.item(i);
//				int learnSessionCount = previousLearnSessionCount + i + 1;
//				insertLearnSessionLog( dataAccess,
//					endLearnData, learnSessionNode,
//					activityID, attemptCount, learnSessionCount);
//			}
//		}
//		catch (LOException e) {
//			throw e;
//		}
//		catch (Exception e) {
//			DebugLog.write(getClass(), e, DebugLog.HIGHT);
//			throw new LOException(e.getMessage());
//		}
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhIO
//		DebugLog.write(
//			getClass(),
//			"TAIL insertAttemptCountLog("
//				+ "dataAccess,endLearnData"
//				+ "," + attemptCountNode + "," + activityID
//				+ ",learnSessionCountMap)",
//			DebugLog.ROW);
//	}
//
//	/**
//	 * wKÔALearn Sessionȉ̃O݂s܂B<br>
//	 * &lt;learnsession&gt;vfƂɌĂяoA
//	 * z̗vfɏ]Aee[uɃR[hǉ܂B<br>
//	 *
//	 * @param dataAccess f[^ANZXNXB
//	 * @param endLearnData wKIB
//	 * @param learnSessionNode &lt;learnsession&gt;vf\m[hB
//	 * @param activityID f[^ޑΏۂĂANeBreBIDB
//	 * @param attemptCount s񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;attemptcount&gt;vf̈ʒuiPȏ̐jB
//	 * @param learnSessionCount LearnZbV񐔁B
//	 *         wKOŁAf[^ޑΏۂł
//	 *         &lt;learnsession&gt;vf̈ʒuiPȏ̐jB
//	 *
//	 * @throws LOException f[^x[Xւ̏ɎsꍇB
//	 */
//	private void insertLearnSessionLog(
//		DataAccess dataAccess,
//		ScormLoEndLearnData endLearnData,
//		Node learnSessionNode,
//		String activityID,
//		int attemptCount,
//		int learnSessionCount)
//		throws LOException {
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhJnO
//		DebugLog.write(
//			getClass(),
//			"HEAD insertLearnSessionLog("
//				+ "dataAccess ,endLearnData"
//				+ "," + learnSessionNode + "," + activityID
//				+ "," + attemptCount + "," + learnSessionCount + ")",
//			DebugLog.ROW);
//
//		try {
//			// wK
//			String learnSessionDate = ScormLoUtil.getNodeValue(
//					learnSessionNode, PATH_LEARN_SESSION_DATE);
//			////////////////////////////////////////////////////////////////////
//			// ScormAttempt̃̕O擾Af[^x[Xɓo^
//			// 擾łȂꍇ́A
//			Node attemptNode =
//				XPathAPI.selectSingleNode(
//					learnSessionNode,
//					PATH_ATTEMPT_FROM_LEARN_SESSION);
//			if (attemptNode != null) {
//				ScormAttemptDataAccess.insert(
//					dataAccess, endLearnData,
//					attemptNode, activityID,
//					attemptCount, learnSessionCount, learnSessionDate);
//			}
//			////////////////////////////////////////////////////////////////////
//			// ScormInteractioñ̕O擾Af[^x[Xɓo^
//			NodeList interactionNodeList =
//				XPathAPI.selectNodeList(
//					learnSessionNode,
//					PATH_INTERACTION_FROM_LEARN_SESSION);
//			// InteractionƂɃOo^
//			for (int i = 0; i < interactionNodeList.getLength(); i++) {
//				Node interactionNode = interactionNodeList.item(i);
//				ScormInteractionDataAccess.insert(
//					dataAccess, endLearnData,
//					interactionNode, activityID,
//					attemptCount, learnSessionCount, i + 1);
//			}
//			////////////////////////////////////////////////////////////////////
//			// ScormLearnerComment̃̕O擾Af[^x[Xɓo^
//			NodeList learnerCommentNodeList =
//				XPathAPI.selectNodeList(
//					learnSessionNode,
//					PATH_LEARNER_COMMENT_FROM_LEARN_SESSION);
//			// LearnerCommentƂɃOo^
//			for (int i = 0; i < learnerCommentNodeList.getLength(); i++) {
//				Node learnerCommentNode = learnerCommentNodeList.item(i);
//				ScormLearnerCommentDataAccess.insert(
//					dataAccess,	endLearnData,
//					learnerCommentNode, activityID,
//					attemptCount, learnSessionCount, i + 1);
//			}
//			////////////////////////////////////////////////////////////////////
//			// ScormLMSComment̃̕O擾Af[^x[Xɓo^
//			NodeList lmsCommentNodeList =
//				XPathAPI.selectNodeList(
//					learnSessionNode,
//					PATH_LMS_COMMENT_FROM_LEARN_SESSION);
//			// LMSCommentƂɃOo^
//			for (int i = 0; i < lmsCommentNodeList.getLength(); i++) {
//				Node lmsCommentNode = lmsCommentNodeList.item(i);
//				ScormLMSCommentDataAccess.insert(
//					dataAccess, endLearnData,
//					lmsCommentNode, activityID,
//					attemptCount, learnSessionCount, i + 1);
//			}
//			////////////////////////////////////////////////////////////////////
//			// ScormObjectivẽ̕O擾Af[^x[Xɓo^
//			NodeList objectiveNodeList =
//				XPathAPI.selectNodeList(
//					learnSessionNode,
//					PATH_OBJECTIVE_FROM_LEARN_SESSION);
//			// ObjectiveƂɃOo^
//			for (int i = 0; i < objectiveNodeList.getLength(); i++) {
//				Node objectiveNode = objectiveNodeList.item(i);
//				ScormObjectiveDataAccess.insert(
//					dataAccess, endLearnData,
//					objectiveNode, activityID,
//					attemptCount, learnSessionCount, i + 1);
//			}
//		}
//		catch (LOException e) {
//			throw e;
//		}
//		catch (Exception e) {
//			DebugLog.write(getClass(), e, DebugLog.HIGHT);
//			throw new LOException(e.getMessage());
//		}
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhIO
//		DebugLog.write(
//			getClass(),
//			"TAIL insertAttemptCountLog("
//				+ "dataAccess,endLearnData"
//				+ "," + learnSessionNode + "," + activityID
//				+ "," + attemptCount + "," + learnSessionCount + ")",
//			DebugLog.ROW);
//	}
	// Comment End

	/**
	 * w肵ANeBreBIDAs񐔂ɑΉLearnZbV񐔂擾B
	 * @param learnSessionCountMap LearnZbV񐔂̍ől}bvB
	 * }bv̍\Ao^f[^ɂẮA
	 * {@link #makeLearnSessionCountMap(DataAccess, ScormLoEndLearnData)}QƁB
	 * @param activityID ANeBreBIDB
	 * @param attemptCount s񐔁B
	 * @return learnSessionCountMapAactivityIDAs񐔂ɑΉ
	 *          LearnZbV񐔂擾A̒l߂B
	 *          擾łȂꍇ͂O߂B
	 */
	private static int getLearnSessionCount(
			Map learnSessionCountMap, String activityID, int attemptCount) {
		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(ScormLoLogControl.class,
			"HEAD getLearnSessionCount(learnSessionCountMap"
				+ "," + activityID + "," + attemptCount + ")",
			DebugLog.ROW);
		// ̃\bh̖߂l
		int maxLearnSessionCount = 0;
		try {
			// ANeBreBL[ɂāA
			// us񐔂L[ALearnZbV񐔂lƂ}bvv
			// 擾B
			Map attemptLearnSessionMap =
				(Map)learnSessionCountMap.get(activityID);
			// 擾łꍇAs񐔂L[ɂāA
			// ΉLearnZbV񐔂擾B
			if (attemptLearnSessionMap != null) {
				Integer attemptCountInteger = new Integer(attemptCount);
				Integer maxLearnSessionCountInteger =
					(Integer)attemptLearnSessionMap.get(attemptCountInteger);
				// LearnZbV񐔂擾łꍇA̒l߂lƂB
				if (maxLearnSessionCountInteger != null) {
					maxLearnSessionCount =
						maxLearnSessionCountInteger.intValue();
				}
			}
		}
		catch (Exception e) {
			maxLearnSessionCount = 0;
		}
		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(ScormLoLogControl.class,
			"TAIL getLearnSessionCount(learnSessionCountMap"
				+ "," + activityID + "," + attemptCount + ")"
				+ " return " + maxLearnSessionCount,
			DebugLog.ROW);
		return maxLearnSessionCount;
	}

	/**
	 * LearnZbV񐔏WA}bv𐶐܂B<br>
	 * ߂MaṕAANeBreBL[A
	 * us񐔂L[ALearnZbV񐔂lƂ}bvvlƂ
	 * }bvłB<br>
	 * @param dataAccess f[^ANZXEIuWFNgB
	 * @param endLearnData wKIB
	 * @return ANeBreBL[Aus񐔂L[A
	 * 			LearnZbV񐔂lƂ}bvvlƂ}bvB
	 * @throws LOException f[^x[XANZXɎsȂǂ̏
	 *          G[ꍇB
	 */
	private static Map makeLearnSessionCountMap(
			DataAccess dataAccess, ScormLoEndLearnData endLearnData)
			throws LOException {
		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(ScormLoLogControl.class,
			"HEAD makeLearnSessionCountMap(dataAccess, endLearnData)",
			DebugLog.ROW);

		Map learnSessionCountMap = null;

		try {
			learnSessionCountMap = new HashMap();
			String userID = endLearnData.getUserID();
			String loID = endLearnData.getLoID();
			int studySession = endLearnData.getStudySession();
			String[][] matrix = null;
			// ScormAttempte[u
			matrix = ScormAttemptDataAccess.getMaxLearnSessionCount(
					dataAccess, userID, loID, studySession);
			convertLearnSessionCountMap(learnSessionCountMap, matrix);
			// Scorm_Interactione[u
			matrix = ScormInteractionDataAccess.getMaxLearnSessionCount(
					dataAccess, userID, loID, studySession);
			convertLearnSessionCountMap(learnSessionCountMap, matrix);
			// ScormLearnerCommente[u
			matrix = ScormLearnerCommentDataAccess.getMaxLearnSessionCount(
					dataAccess, userID, loID, studySession);
			convertLearnSessionCountMap(learnSessionCountMap, matrix);
			// ScormLMSCommente[u
			matrix = ScormLMSCommentDataAccess.getMaxLearnSessionCount(
					dataAccess, userID, loID, studySession);
			convertLearnSessionCountMap(learnSessionCountMap, matrix);
			// ScormObjectivee[u
			matrix = ScormObjectiveDataAccess.getMaxLearnSessionCount(
					dataAccess, userID, loID, studySession);
			convertLearnSessionCountMap(learnSessionCountMap, matrix);
		}
		catch (LOException e) {
			throw e;
		}
		catch (Exception e) {
			DebugLog.write(ScormLoLogControl.class, e, DebugLog.HIGHT);
			throw new LOException( e.getMessage() );
		}
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(ScormLoLogControl.class,
			"TAIL makeLearnSessionCountMap(dataAccess, endLearnData)"
			 + " return " + learnSessionCountMap,
			DebugLog.ROW);
		return learnSessionCountMap;
	}

	/**
	 * LearnZbV񐔏z̓eA}bvɓo^܂B<br>
	 * matrixAAANeBreBIDAs񐔁ALearnZbV񐔂
	 * 擾AANeBreBIDAs񐔂̑gݍ킹
	 * }bvLearnZbV񐔂̓o^Ȃ΁A
	 * LearnZbV񐔂}bvɓo^܂B
	 * o^΁Amatrix擾LearnZbV񐔂A
	 * }bvɓo^ĂLearnZbV񐔂傫ꍇ̂݁Ao^܂B
	 * <br>
	 * @param learnSessionCountMap LearnZbV񐔂̍ől}bvB
	 * }bv̍\Ao^f[^ɂẮA
	 * {@link #makeLearnSessionCountMap(DataAccess, ScormLoEndLearnData)}QƁB
	 * @param matrix LearnZbV񐔏zB
	 * ȉ̂PzvfƂzB
	 * <table border="1">
	 * 	<tr>
	 * 		<th>CfbNX</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td align="right">0</td>
	 * 		<td>ANeBreBID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td align="right">1</td>
	 * 		<td>ANeBreB̒ōő̎s</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td align="right">2</td>
	 * 		<td>
	 * 			ANeBreB̒ōő̎s񐔂̒
	 * 			őLearnZbV
	 * 		</td>
	 * 	</tr>
	 * </table>
	 * <br>
	 */
	private static void convertLearnSessionCountMap(
		Map learnSessionCountMap, String[][] matrix) {

		for (int i = 0; i < matrix.length; i++ ) {
			String activityID = matrix[i][0];
			Integer attemptCount = new Integer(matrix[i][1]);
			Integer learnSessionCount = new Integer(matrix[i][2]);
			// ANeBreBL[ɂāA
			// us񐔂L[ALearnZbV񐔂lƂ}bvv
			// 擾B擾łȂꍇ́AEo^
			Map attemptLearnSessionMap =
				(Map)learnSessionCountMap.get(activityID);
			if (attemptLearnSessionMap == null) {
				attemptLearnSessionMap = new HashMap();
				learnSessionCountMap.put(activityID, attemptLearnSessionMap);
			}
			// s񐔂L[ɂāALearnZbV񐔂擾܂B
			// 擾łȂꍇ͔z̒lo^܂B
			// 擾łꍇ́AlrāA傫o^܂B
			Integer currentLearnSessionCount =
				(Integer)attemptLearnSessionMap.get(attemptCount);
			if (currentLearnSessionCount == null) {
				attemptLearnSessionMap.put(attemptCount, learnSessionCount);
			}
			else if (learnSessionCount.compareTo(
						currentLearnSessionCount) > 0) {
				attemptLearnSessionMap.put(attemptCount, learnSessionCount);
			}
		}
	}

	/**
	 * ʃOLoLogSessione[uɃR[hǉs܂B
	 * @param dataAccess f[^ANZXEIuWFNgB
	 * @param endLearnData wKIB
	 * @throws LOException f[^x[XANZXɗOꍇB
	 */
	private void insertLoLogSession(
			DataAccess dataAccess,
			ScormLoEndLearnData endLearnData) throws LOException {
		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(getClass(),
			"HEAD insertLoLogSession(dataAccess,endLearnData)",
			DebugLog.ROW);
		try {
			// ݓ
			Date thisTime = new Date();
			String thisTimeString = ScormLoUtil.convertDateToDbFormat(thisTime);

			////////////////////////////////////////////////////////////////////
			// }郌R[h𐶐
			LoLogSessionRecord loLogSessionRecord = null;
			loLogSessionRecord = new LoLogSessionRecord();
			// [UID
			String userID = endLearnData.getUserID();
			loLogSessionRecord.setUserID(userID);
			// LOID
			String loID = endLearnData.getLoID();
			loLogSessionRecord.setLoID(loID);
			// ZbVID
			String sessionID =
				Integer.toString(endLearnData.getLoginSession());
			loLogSessionRecord.setSessionID(sessionID);
			// wKJn
			Date studyStartDate = endLearnData.getStartDate();
			String studyStartDateString =
				ScormLoUtil.convertDateToDbFormat(studyStartDate);
			loLogSessionRecord.setStudyStartDate(studyStartDateString);
			// wK
			String residanceTime = Long.toString(
					thisTime.getTime() - studyStartDate.getTime());
			loLogSessionRecord.setResidanceTime(residanceTime);
			// i
			if (endLearnData.isSatisfiedStatus() == true) {
				loLogSessionRecord.setPassday(thisTimeString);
			}
			// 
			if (endLearnData.isCompletionStatus() == true) {
				loLogSessionRecord.setStudyEndDate(thisTimeString);
			}
			// N
			String lauchtimes =
				Integer.toString(endLearnData.getLoginSession());
			loLogSessionRecord.setLunchTimes(lauchtimes);

			// ScormAttemte[uLoLogSessionp̃f[^擾
			double[] scores = ScormAttemptDataAccess.getTotalMaxMinScores(
					dataAccess, userID, loID, sessionID);
			// ō_
			String highScore = Double.toString(
					scores[ScormAttemptDataAccess.INDEX_MAX_SOCRE]);
			loLogSessionRecord.setHighScore(highScore);
			// Œᓾ_
			String lowScore = Double.toString(
					scores[ScormAttemptDataAccess.INDEX_MIN_SOCRE]);
			loLogSessionRecord.setLowScore(lowScore);
			// ŐV_
			double latestScore =
				ScormAttemptDataAccess.getTotalLatestScore(
					dataAccess, userID, loID, sessionID);
			String execisePoint = Double.toString(latestScore);
			loLogSessionRecord.setExecisePoint(execisePoint);
			// _
			double fullScore =
				ScormAttemptDataAccess.getTotalFullScore(
					dataAccess, userID, loID, sessionID);
			String strFullScore = Double.toString(fullScore);
			loLogSessionRecord.setFullScore(strFullScore);
			////////////////////////////////////////////////////////////////////
			// R[hǉ
			LoLogSessionDataAccess logSessionDataAccess
				= new LoLogSessionDataAccess();
			logSessionDataAccess.insert(loLogSessionRecord, dataAccess);
		}
		catch (LOException e) {
			throw e;
		}
		catch (Exception e) {
			DebugLog.write(getClass(), e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		// \bhIO
		DebugLog.write(getClass(),
			"TAIL insertLoLogSession(dataAccess,endLearnData)",
			DebugLog.ROW);
	}

	/**
	 * ʃOLoLoge[uɃR[hǉ^XVs܂B
	 * @param dataAccess f[^ANZXEIuWFNgB
	 * @param endLearnData wKIB
	 * @throws LOException f[^x[XANZXɗOꍇB
	 */
	private void insertLoLog(
		DataAccess dataAccess, ScormLoEndLearnData endLearnData)
		throws LOException {

		// \bhJnO
		DebugLog.write(getClass(),
			"HEAD insertLoLog(dataAccess,endLearnData)",
			DebugLog.ROW);
		try {

			LoLogDataAccess loLogAccess = new LoLogDataAccess();
			////////////////////////////////////////////////////////////////////
			// }郌R[h𐶐
			LoLogRecord loLogRecord = null;
			loLogRecord = new LoLogRecord();
			// [UID
			String userID = endLearnData.getUserID();
			loLogRecord.setUserID(userID);
			// LOID
			String loID = endLearnData.getLoID();
			loLogRecord.setLoID(loID);
			// ANZX
			String accessCount =
				Integer.toString(endLearnData.getLoginSession());
			loLogRecord.setAccessCnt(accessCount);
			// ŏIANZX
			Date studyStartDate = endLearnData.getStartDate();
			String studyStartDateString =
				ScormLoUtil.convertDateToDbFormat(studyStartDate);
			loLogRecord.setLastAccess(studyStartDateString);
			////////////////////////////////////////////////////////////////////
			// LoLogSession̎擾f[^
			LoLogSessionDataAccess loLogSessionAccess = null;
			loLogSessionAccess = new LoLogSessionDataAccess();
			// wKJn
			LoLogRecord oldRecord = loLogAccess.getLoLog(userID,loID,dataAccess);
			if(oldRecord==null){
				loLogRecord.setStudyStartDate(studyStartDateString);
			}else{
				loLogRecord.setStudyStartDate(oldRecord.getStudyStartDate());
			}
			// i
			String passday =
				loLogSessionAccess.getFirstPassDay(
					userID, loID, dataAccess);
			loLogRecord.setPassday(passday);
			// 
			String studyEndDate =
				loLogSessionAccess.getFirstStudyEndDate(
					userID, loID, dataAccess);
			loLogRecord.setStudyEndDate(studyEndDate);
			// wK
			long residanceTime =
				LoLogSessionDataAccess.getResidanceTime(
					userID, loID, dataAccess);
			loLogRecord.setResidanceTime(Long.toString(residanceTime));
			// ō_
			String highScore =
				loLogSessionAccess.getMaxHighScore(
					userID, loID, dataAccess);
			loLogRecord.setHighScore(highScore);
			// Œᓾ_
			String lowScore =
				loLogSessionAccess.getMinLowScore(
					userID, loID, dataAccess);
			loLogRecord.setLowScore(lowScore);
			// _
			String fullScore =
				loLogSessionAccess.getMaxFullScore(
					userID, loID, dataAccess);
			loLogRecord.setFullScore(fullScore);
			// ŐV_
			String execisePoint =
				loLogSessionAccess.getNewestExcisePoint(
					userID, loID, dataAccess);
			loLogRecord.setExecisePoint(execisePoint);
			////////////////////////////////////////////////////////////////////
			// R[hǉ
			loLogAccess.insertUpdate(loLogRecord, userID, loID, dataAccess);
		}
		catch (LOException e) {
			throw e;
		}
		catch (Exception e) {
			DebugLog.write(getClass(), e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		// \bhIO
		DebugLog.write(getClass(),
			"TAIL insertLoLog(dataAccess,endLearnData)",
			DebugLog.ROW);
	}

	/**
	 * Xe[^X`ds܂B<br>
	 * @param endLearnData wKIB
	 * @throws LOException ɗOꍇB
	 */
	private void propagateStatus(ScormLoEndLearnData endLearnData)
			throws LOException {
		// \bhJnO
		DebugLog.write(getClass(),
			"HEAD propagateStatus(endLearnData)",
			DebugLog.ROW);
		String userID = endLearnData.getUserID();
		String loID = endLearnData.getLoID();

		try {
			// QLOIDXg擾܂
			LoClient loClient = new LoClient();
			if (!loClient.getListFromRealLOID(loID)) {
				new LOException("QLOIDXg̎擾s܂B");
			}
			String[] refers = loClient.getRefListResult();

			// QƃXgXe[^X`d
			for (int i = 0; i < refers.length; i++) {
				// Xe[^X`
				StatusPropagation statusPropagation =
					new StatusPropagation(userID, refers[i]);
				PropagateControl.getInstance().addPropagate(statusPropagation);
			}
		}
		catch (Exception e) {
			DebugLog.write(this.getClass(), e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		// \bhIO
		DebugLog.write(getClass(),
			"TAIL propagateStatus(endLearnData)",
			DebugLog.ROW);
	}
}
