/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//LoInfo IuWFNgXgNX
//
//ύX
//2005.01.27  VK쐬  X@qu
//
//@\
//
//@XPath pāAm[hs߂̃NXłB
//
/////////////////////////////////////////////////////////////////
package jp.co.ntt.lms.lo.lom.learnableinfo;

import java.io.File;
import java.io.IOException;
import java.io.UTFDataFormatException;

import javax.xml.parsers.*;
import javax.xml.transform.TransformerException;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.*;
import org.xml.sax.SAXException;

/**
 * XPath pāAm[hs߂̃NXłB
 * @author s-mori
 * @version 1.0
 */
public class NodeController {

	Document document = null;
	
    /**
     * XMLt@Cp[XDocumentIuWFNg쐬܂B
     * @param xmlFile p[XΏۂXMLt@C
     * @throws Exception
     */
    public Node parse(File xmlFile) throws Exception{
        DocumentBuilderFactory dbf = null;
        DocumentBuilder parser = null;
        Document document = null;
        
        dbf = DocumentBuilderFactory.newInstance();

        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(true);
        //dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage","http://www.w3.org/2001/XMLSchema");


        // DocumentBuilder 쐬
        try {
            parser = dbf.newDocumentBuilder();
        }catch (ParserConfigurationException ex) {
            throw ex;
        }

        //p[XsA擾IuWFNg doc tB[h
        try{
            document = parser.parse(xmlFile);
        }catch (UTFDataFormatException ex){
            throw ex;
        }catch (IOException ex) {
            throw ex;
        }catch (SAXException ex) {
            throw ex;
        }
        
        this.document = document;
        return document;

    }
	
	
	
    /**
     * XPathɑm[h̃Xg擾܂B
     * @param document m[hIuWFNg
     * @param xPathStr XPath
     * @param namespaceNode Oԃm[h
     * @return XPathɊYm[hNodeList
     * @throws Exception
     * */
	public NodeList getNodeList(Node document, String xPathStr, Node namespaceNode) throws Exception{
		if(document == null){
            throw new NullPointerException("The document is null.");
        }
		if(xPathStr == null || xPathStr.equals("")){
            throw new NullPointerException("The parameter (XPath string) is null.");
		}

		NodeList nodeList = null;
		
        try {
        	if(namespaceNode == null){
        		nodeList = XPathAPI.selectNodeList(document, xPathStr);
        	}else{
        		nodeList = XPathAPI.selectNodeList(document, xPathStr, namespaceNode);
        	}
        }
        catch (TransformerException ex) {
            throw ex;
        }

		return nodeList;
	}
	
    /**
     * XPathɑm[h̃Xg擾܂B
     * @param document m[hIuWFNg
     * @param xPathStr XPath
     * @return XPathɊYm[hNodeList
     * @throws Exception
     * */
	public NodeList getNodeList(Node document, String xPathStr) throws Exception{
		return this.getNodeList(document, xPathStr, null);
	}

    /**
     * XPathɑm[h擾܂BYꍇ́AŏɊYm[hԂ܂B
     * @param document m[hIuWFNg
     * @param xPathStr XPath
     * @param namespaceNode Oԃm[h
     * @return XPathɊYm[h
     * @throws Exception
     * */
	public Node getNode(Node document, String xPathStr, Node namespaceNode) throws Exception{

		NodeList nodeList = this.getNodeList(document, xPathStr, namespaceNode);
		if(nodeList.getLength() == 0){
			return null;
		}else{
			return nodeList.item(0);
		}
		
	}

    /**
     * XPathɑm[h擾܂BYꍇ́AŏɊYm[hԂ܂B
     * @param document m[hIuWFNg
     * @param xPathStr XPath
     * @return XPathɊYm[h
     * @throws Exception
     */
	public Node getNode(Node document, String xPathStr) throws Exception{
		return this.getNode(document, xPathStr, null);
	}

	
	/**
	 * XPath̓ꕶGXP[v܂B
	 * @param str 
	 * @return GXP[v
	 */
	public static String escapeString(String str){
		if(str == null){
			return null;
		}
		
		String buf = str;
		buf = buf.replaceAll("&", "&amp;");
		buf = buf.replaceAll("'", "&apos;");
		buf = buf.replaceAll("\"", "&quot;");
		buf = buf.replaceAll("<", "&lt;");
		buf = buf.replaceAll(">", "&gt;");
		
		return buf;
		
	}

}
