/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
// WBTʃOލ\XgANX
// ύX
// 2004.01.08 VK쐬       c
//   @\
//   RDFNodeʃO\Ɏgp閼̂Ȃǃm[h̃Xg𐶐
//   -------------------------------------------
//   | Type  | UID     |  AU or ZNV |
//   -------------------------------------------
//   | SE    | sc00001 | TOP > SEC1 > SEC1-1   |
//   | AU    | el00001 | AU                  |
//   | AU    | el00002 | AU                  |
//   | SE    | sc00002 | TOP > SEC1 > SEC1-2   |
//   | AU    | el00003 | AU                  |
//   -------------------------------------------
package jp.co.ntt.lms.lo.WBT.IndividualLog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.HashMap;
import java.util.Map;

import jp.co.ntt.lms.Common.RDF.RDFNode;
import jp.co.ntt.lms.Common.RDF.RDFNodeList;

/**
 * WBTʃOލ\XgNXB<BR>
 * ʃOj[c[\NbNꂽȉ̃ZNV/AU
 * WBTʃOɕ\鏇ŁA^CvAUIDAm[ĥXgƂĕێB<BR>
 * @author  asada
 * @version 0.0.0.1 2004/01/08
 */
public class IndividualLogRDFNode implements IndividualLogPropertyDef {

	/**
	 * m[hʁFZNVB
	 */
	public static final String STATUS_S = "SE";

	/**
	 * m[hʁF`tB
	 */
	public static final String STATUS_A = "AU";

	/**
	 * nodeInfoList̗vfƂȂm[h}bṽL[FthcB
	 * @see #nodeInfoList
	 */
	private static final String KEY_NODE_UID = "NODE_UID";

	/**
	 * nodeInfoList̗vfƂȂm[h}bṽL[Fm[hʁB
	 * @see #nodeInfoList
	 */
	private static final String KEY_NODE_TYPE = "NODE_TYPE";

	/**
	 * nodeInfoList̗vfƂȂm[h}bṽL[Fm[h^CgB
	 * @see #nodeInfoList
	 */
	private static final String KEY_NODE_TITLE = "NODE_TITLE";

	/**
	 * m[h񃊃XgB<br>
	 * ލ\`̏̏]ăm[hꎟXgێB<br>
	 * evf͂P̃m[h̏\AMapƂĕ\B
	 * evfłMaṕAȉ̓e܂ށB<br>
	 * <table border="1">
	 *   <tr>
	 *     <td>L[</td>
	 *     <td>l̃NX</td>
	 *     <td>e</td>
	 *   </tr>
	 *   <tr>
	 *     <td>KEY_NODE_UID</td>
	 *     <td>String</td>
	 *     <td>m[hUID</td>
	 *   </tr>
	 *   <tr>
	 *     <td>KEY_NODE_TYPE</td>
	 *     <td>String</td>
	 *     <td>
	 *         m[h̎ʁB<br>
	 *         STATUS_SSTATUS_AB
	 *     </td>
	 *   </tr>
	 *   <tr>
	 *     <td>KEY_NODE_TITLE</td>
	 *     <td>String</td>
	 *     <td>
	 *         m[h̃^CgB
	 *         ZNV̏ꍇA[gm[h̃^Cg&quot;&gt;&quot;ŘAB
	 *     </td>
	 *   </tr>
	 * </table>
	 * <br>
	 * @see #STATUS_A
	 * @see #STATUS_S
	 * @see #KEY_NODE_TITLE
	 * @see #KEY_NODE_TYPE
	 * @see #KEY_NODE_UID
	 */
	private List nodeInfoList;

	/**
	 * RXgN^B<br>
	 * CX^X𐶐_Ńm[hXg𐶐ɕێB
	 * @param rootNode Xg𐶐ۂɃ[gƂȂm[hB
	 */
	public IndividualLogRDFNode(RDFNode rootNode) {
		// ލ\m[hXg𐶐ێB
		nodeInfoList = getNodeList(rootNode);

	}

	/**
	 * ލ\m[hXg𐶐߂B<br>
	 * w肵m[h`t̏ꍇAem[hƎg̃m[h񂾂̏߂B<br>
	 * w肵m[hZNV̏ꍇAgƔz̃m[hXgĖ߂B<br>
	 * ߂Xg̗vfMapłA̍\nodeInfoListƓlłB<br>
	 * @param rootNode Xg𐶐ۂɃ[gƂȂm[hB
	 * @see #nodeInfoList
	 */
	private List getNodeList(RDFNode rootNode) {
		// ̃\bh̖߂lBvfMapB
		List nodeList = null;
		// nodeList̗vfƂȂm[h\MapB
		Map nodeInfoMap = null;
		// g̎qm[h̃XgB
		List childNodeList = null;
		// cm[h̃^CgXg
		List ancestorTitles = null;
		// g܂߂m[h^CgXg
		List currentAncestorTitles = null;

		// ߂lƂȂ郊XgB
		nodeList = new ArrayList();

		// [gm[h̐em[h܂ł̃^CgXg擾B
		ancestorTitles = getAncestorTitles(rootNode);
		////////////////////////////////////////////////////////////////////////
		// [gm[h`t̏ꍇA
		// eZNVEm[hƎg̏񂾂ێ
		if (rootNode.getNodeType() == RDFNode.AU_NODE) {
			//eZNṼm[hێ
			nodeInfoMap = makeNodeInfoMap("", STATUS_S, getJoinedTitle(ancestorTitles));
			nodeList.add(nodeInfoMap);
			//g̃m[hێ
			nodeInfoMap = makeNodeInfoMap(rootNode.getID(), STATUS_A, rootNode.getTitle());
			nodeList.add(nodeInfoMap);
		}
		////////////////////////////////////////////////////////////////////////
		// [gm[hZNV̏ꍇA
		// g̏Ɣz̏擾ێ
		else {
			// g܂߂^Cg擾
			currentAncestorTitles = new ArrayList(ancestorTitles);
			currentAncestorTitles.add(rootNode.getTitle());
			//g̃m[hێ
			nodeInfoMap = makeNodeInfoMap("", STATUS_S, getJoinedTitle(currentAncestorTitles));
			nodeList.add(nodeInfoMap);
			// g̔z̃m[hXg擾A킹ĕێ
			childNodeList = getChildNodeList(rootNode, currentAncestorTitles);
			nodeList.addAll(childNodeList);
		}
		// ŜƂẴm[hXgԋpB
		return nodeList;
	}

	/**
	 * w肵m[h̐em[h܂ł̃^CgXg擾B<br>
	 * w肵m[h̐em[hɒHAm[h̃^CgXgƂĎ擾A߂B
	 * ߂XgȂ̏́Aʃm[hƂȂB
	 * āAw肵m[h̐em[h̃^Cg͍ŌvfƂȂB
	 * 
	 * @param node ^CgXg擾̊_ƂȂm[hB
	 * @return w肵m[h̐em[h܂ł̊em[h̃^CgvfiStringjƂ郊XgB
	 */
	private List getAncestorTitles(RDFNode node) {
		// ̃\bh̖߂lB
		List ancestorTitles = null;
		// em[h擾p
		RDFNode parentNode = null;

		ancestorTitles = new ArrayList();
		
		parentNode = node;
		while (true) {
			// ̐em[hH
			parentNode = parentNode.getParentNode();
			// HȂȂIB
			if (parentNode == null) {
				break;
			}
			//em[hZNViubNj̏ꍇA^Cgǉo^
			if (parentNode.getNodeType() == RDFNode.BLOCK_NODE) {
				ancestorTitles.add(parentNode.getTitle());
			}
		}
		
		// ʂɂȂ悤ɗvftɂĂ߂B
		Collections.reverse(ancestorTitles);
		return ancestorTitles;
	}

	/**
	 * w肵m[hz̃m[h񃊃Xg擾B<br>
	 * w肵m[h́íjqm[h擾Aqm[hXg̗vfƂĒǉB
	 * Aqm[hZNV̏ꍇȀǉɁA
	 * ̎qm[h̔z̃m[hXg擾A擾m[hXgĖ߂B
	 * Ȃ킿AċAIɃm[h擾邱ƂƂȂÃ\bh͍ċAďoƂȂB<br>
	 * ߂Xg̗vfMapłA̍\nodeInfoListƓlłB<br>
	 * 
	 * @param parentNode 擾m[hXg̊_ƂȂem[hB
	 * @param ancestorTitles parentNode܂ł̃m[hE^Cgvf(String)Ƃ郊XgB
	 * @see #nodeInfoList
	 */
	private List getChildNodeList(RDFNode parentNode, List ancestorTitles) {
		// ̃\bh̖߂lB
		List nodeList = null;
		// qm[hZNV̏ꍇA̔z̃m[hXg擾邽߂̃XgB
		List childNodeList = null;
		// qm[hZNV̏ꍇA̎qm[h^Cg܂񂾃^CgXgB
		List currentAncestorTitles = null;
		// nodeList̗vfƂȂMap
		Map nodeInfoMap = null;
		// parentNode̎qm[h̃Xg
		RDFNodeList objNodeList = null;
		// parentNode̎qm[h
		int intLength = 0;

		nodeList = new ArrayList();
		////////////////////////////////////////////////////////////////////////
		//qm[h擾B
		objNodeList = parentNode.getChildNodes();
		intLength = objNodeList.getLength();
		////////////////////////////////////////////////////////////////////////
		// qm[hPP
		for (int i = 0; i < intLength; i++) {
			RDFNode objChildNode = objNodeList.getNode(i);
			////////////////////////////////////////////////////////////////////
			// 擾m[h`t̏ꍇA
			// ꎩgXgɒǉāÃm[h
			if (objChildNode.getNodeType() == RDFNode.AU_NODE) {
				nodeInfoMap =
					makeNodeInfoMap(objChildNode.getID(), STATUS_A, objChildNode.getTitle());
				nodeList.add(nodeInfoMap);
				continue;
			}
			////////////////////////////////////////////////////////////////////
			// ȉAm[hZNV̏ꍇɂ
			// 1.m[hނłȂ΂ꎩgXgɒǉB
			// 2.g̎qm[hɂď擾B
			currentAncestorTitles = new ArrayList(ancestorTitles);
			currentAncestorTitles.add(objChildNode.getTitle());
			if (parentNode.getNodeType() != RDFNode.COURSE_NODE) {
				nodeInfoMap =
					makeNodeInfoMap(
						objChildNode.getID(),
						STATUS_S,
						getJoinedTitle(currentAncestorTitles));
				nodeList.add(nodeInfoMap);
			}
			// qm[ĥߍċAĂяoāAXgɂׂĒǉ
			childNodeList = getChildNodeList(objChildNode, currentAncestorTitles);
			nodeList.addAll(childNodeList);
		}
		return nodeList;
	}

	/**
	 * w肵m[h񂩂m[hMap𐶐߂B<br>
	 * ߂Map̍\nodeInfoList̗vfƓlłB<br>
	 * 
	 * @param uid m[hUIDB
	 * @param type m[h̎ʁB
	 * @param title m[h̃^CgB
	 * @return nodeInfoList̗vfƓ`̃m[hMapB
	 */
	private Map makeNodeInfoMap(String uid, String type, String title) {
		Map nodeInfoMap = null;
		nodeInfoMap = new HashMap();

		nodeInfoMap.put(KEY_NODE_UID, uid);
		nodeInfoMap.put(KEY_NODE_TYPE, type);
		nodeInfoMap.put(KEY_NODE_TITLE, title);

		return nodeInfoMap;
	}

	/**
	 * ^Cg̘AsB<br>
	 * nꂽ^CgEXg̗vfA߂B
	 * vfƗvf̊ԂɂTITLE_TOKENށB
	 * 
	 * @param ancestorTitles ^Cg(String)vfł郊XgB
	 * @return A^CgB
	 * @see IndividualLogPropertyDef#TITLE_TOKEN
	 */
	private String getJoinedTitle(List ancestorTitles) {

		StringBuffer joinedTitle = new StringBuffer();
		// ؂蕶A^Cg̏ŗvfAB
		for (int i = 0; i < ancestorTitles.size(); i++) {
			joinedTitle.append(TITLE_TOKEN);
			joinedTitle.append((String)ancestorTitles.get(i));
		}
		// 擪̋؂蕶OԂŖ߂
		return joinedTitle.substring(TITLE_TOKEN.length());
	}

	/**
	 * ێĂm[hXgw肵m[h̎ʂ߂B
	 * @param index m[hXg擾m[h̃CfbNXB
	 * @return 擾m[h̎ʁBSTATUS_S܂STATUS_AB
	 * @see #STATUS_A
	 * @see #STATUS_S
	 */
	public String getType(int index) {
		String title = null;
		Map nodeInfoMap = null;

		nodeInfoMap = (Map) nodeInfoList.get(index);
		title = (String) nodeInfoMap.get(KEY_NODE_TYPE);
		return title;
	}

	/**
	 * ێĂm[hXgw肵m[hUID߂B
	 * @param index m[hXg擾m[h̃CfbNXB
	 * @return 擾m[hUIDB
	 */
	public String getAUID(int index) {
		String uid = null;
		Map nodeInfoMap = null;

		nodeInfoMap = (Map) nodeInfoList.get(index);
		uid = (String) nodeInfoMap.get(KEY_NODE_UID);
		return uid;
	}

	/**
	 * ێĂm[hXgw肵m[h̃^Cg߂B
	 * @param index m[hXg擾m[h̃CfbNXB
	 * @return 擾m[h̃^CgB
	 */
	public String getTitle(int index) {
		String title = null;
		Map nodeInfoMap = null;

		nodeInfoMap = (Map) nodeInfoList.get(index);
		title = (String) nodeInfoMap.get(KEY_NODE_TITLE);
		return title;
	}

	/**
	 * ێĂm[hXg̗vf߂B
	 * @return ێĂm[hXg̗vfB
	 */
	public int getMaxRow() {
		return nodeInfoList.size();
	}

}