/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	Xe[^X`NX
//			ύX
//				2004.01.08	VK쐬	񞊒q
//
package jp.co.ntt.lms.Common.status;

// Java API
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;

import jp.co.ntt.lms.Common.status.conclusion.Conclusion;
import jp.co.ntt.lms.Common.status.conclusion.ConclusionException;
import jp.co.ntt.lms.Common.status.conclusion.ConclusionParseException;
import jp.co.ntt.lms.lo.LoLogDataAccess;
import jp.co.ntt.lms.lo.LoLogRecord;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.Lo.LoClient;
import jp.co.ntt.lms.xmo.LoRelation.LoRelationClient;

import org.apache.commons.lang.StringEscapeUtils;

/**
 * Xe[^X`NXłB<BR>
 * w肳ꂽLOID̃Xe[^XXVсA_A؍ݎԂ̏Wvs܂B
 * @author 񞊒q
 * @version 0.0.0.1
 */
public class StatusPropagation {

	/** [UIDێ܂ */
	private String mstrUserID;

	/** LOIDێ܂ */
	private String mstrLoID;

	/** RealLOIDێ܂B */
	private String mstrRealLOID;

	/** LO^Cvێ܂ */
	private String mstrLoType;

	/** eIDێ܂ */
	private String mstrParentID;

	/** Xe[^X`Ɋ֌W郆[UIDXgێ܂ */
	private String[] mstrUserList;

	/** f[^ANZXNXێ܂ */
	private DataAccess mobjDataAccess;

	/** UserIDXg擾tOێ܂ */
	private String mstrListFlg;



	/**
	 * RXgN^łBLOID݂̂w肵ăXe[^X`s܂B<BR>
	 * [U͎w肳ꂽLOID̃Xe[^XɊ֌W郆[Û݂ɑ΂ăXe[^X`s܂B
	 * @param strLoID LOID
	 * @exception PropagateException
	 */
	public StatusPropagation( String strLoID )
	{
		mstrLoID = strLoID;
		mstrListFlg = "0";
	}

	/**
	 * RXgN^łB[UIDLOIDw肵ăXe[^X`s܂B
	 * @param strUserID [UID
	 * @param strLoID LOID
	 */
	public StatusPropagation(	String strUserID,
								String strLoID)
	{

		mstrUserID = strUserID;
		mstrLoID = strLoID;
		mstrListFlg = "1";
	}


	/**
	 * Xe[^X`\bhłB
	 * RXgN^Ŏw肳ꂽLOIDƃ[UIDɃXe[^X
	 * `s܂B
	 * @exception PropagateException Xe[^X`ɗOꍇ
	 * @exception SQLException f[^x[XG[
	 */
	public void propagate( DataAccess objDataAccess )
		throws PropagateException, SQLException
	{

		// LOIDroot̏ꍇ͉sȂ
		if( mstrLoID.equals( "LO0" ) ) {
			return;
		}

		mobjDataAccess = objDataAccess;

		if(mstrListFlg.equals("0")){
			LoLogDataAccess objLoLog = new LoLogDataAccess();
			mstrUserList = objLoLog.getUserList( mstrLoID, mobjDataAccess );
		}

		// RXgN^Ń[UIDw肳ꂸUserIDXg擾ꍇ
		// UserIDXg[văXe[^X`s܂
		if( mstrUserList != null ) {
			for( int i = 0; i < mstrUserList.length; i++ ) {
				// [UXgXe[^X`JԂ
				StatusPropagation objPropagation = new StatusPropagation(
										mstrUserList[i], mstrLoID );
				objPropagation.propagate( mobjDataAccess );
			}
			return;
		}


		// LOIDeLOID擾܂
		mstrParentID = getParentID(mstrLoID);
		// LOIDLO^Cv擾܂
		mstrLoType = getLoType(mstrLoID);

		// LOIDRealLOID擾܂B
		mstrRealLOID = getRealLOID( mstrLoID );
		if( mstrRealLOID == null ) {
			throw new PropagateException( "RealLOID is null. " + mstrLoID );
		}



		// w肳LOReȉꍇ̂݃Xe[^XXVȂ܂B
		if( mstrLoType.equals( LoClient.CONTAINER_TYPE ) ) {
			// Xe[^XXV
			updateStatus();
		}

		if( mstrParentID != null && !mstrParentID.equals( "LO0" ) ) {
			// eLOփXe[^X`ċA
			StatusPropagation objPropagation = new StatusPropagation(
										mstrUserID, mstrParentID );
			// `ċA
			objPropagation.propagate( mobjDataAccess );
		}
	}

	/**
	 * LOIDeLOID擾郁\bhłB
	 * @exception SQLException Ɏsꍇ
	 * @exception PropagateException ʂꌏȂꍇ
	 */
	private String getParentID(String strLoID)
		throws PropagateException, SQLException
	{
		String strParentID = null;

		// SQLgݗ
		StringBuffer strSQL = new StringBuffer();

		strSQL.append( "SELECT " );
		strSQL.append( LoRelationClient.PARENT_ID );
		strSQL.append( " FROM " );
		strSQL.append( LoRelationClient.TABLE_NAME );
		strSQL.append( " WHERE " );
		strSQL.append( LoRelationClient.CHILD_ID );
		strSQL.append( "='" );
		strSQL.append( StringEscapeUtils.escapeSql(strLoID) );
		strSQL.append( "'" );

		ResultSet rs = mobjDataAccess.executeQuery( new String(strSQL) );

		if( rs.next() ) {
			strParentID = rs.getString( LoRelationClient.PARENT_ID ).trim();
		}
		else {
			new PropagateException( "LO is not Exist! :: " + strLoID );
		}

		return strParentID;
	}

	/**
	 * w肳ꂽLOID̎𔲂qIDXg擾܂B
	 * @param strParentID eID
	 * @return Vector qIDXg
	 * @exception SQLException DBO
	 */
	private Vector getChildList(String strParentID)
		throws SQLException
	{
		Vector vecChildList = new Vector();

		// SQLgݗ
		StringBuffer strSQL = new StringBuffer();

		strSQL.append( "SELECT " );
		strSQL.append( LoClient.TABLE_NAME + "." + LoClient.REAL_LOID );
		strSQL.append( " AS " + LoClient.REAL_LOID );
		strSQL.append( " FROM " );
		strSQL.append( LoRelationClient.TABLE_NAME );
		strSQL.append( " INNER JOIN " );
		strSQL.append( LoClient.TABLE_NAME );
		strSQL.append( " ON " );
		strSQL.append( LoRelationClient.TABLE_NAME + "." + LoRelationClient.CHILD_ID );
		strSQL.append( " = " );
		strSQL.append( LoClient.TABLE_NAME + "." + LoClient.LO_ID );
		strSQL.append( " WHERE " );
		strSQL.append( LoRelationClient.PARENT_ID );
		strSQL.append( "='" );
		strSQL.append( StringEscapeUtils.escapeSql(strParentID) );
		strSQL.append( "'" );



		ResultSet rs = mobjDataAccess.executeQuery( new String(strSQL) );

		while( rs.next() ) {
			vecChildList.add(rs.getString( LoClient.REAL_LOID ).trim());
		}

		return vecChildList;
	}

	/**
	 * w肳ꂽLOID̊v𒲂ׁAĂ邩ǂׂ܂
	 * @return boolean true: @false: 
	 * @exception PropagateException `O
	 */
	private boolean isCompleted()
		throws SQLException, PropagateException
	{
		// v擾
		String strConclusion = getConclusion(mstrLoID);

		if( strConclusion == null || strConclusion.equals( "" ) ) {
			// vݒ肳ĂȂꍇ
			// qIDXg擾
			String strTempID = "";
			Vector vecChildList = getChildList( mstrLoID );
			for( int i = 0; i < vecChildList.size(); i++ ) {
				strTempID = (String)vecChildList.get(i);
				if( !isCompleted( strTempID ) ) {
					// ЂƂłfailedꍇXe[^Xfaile
					return false;
				}
			}

			// ЂƂfailȂꍇcompleted
			return true;
		}
		else {
			// vNXCX^X
			Conclusion objConclusion = new Conclusion(	strConclusion,
														mstrUserID,
														mstrLoID,
														mobjDataAccess );

			boolean blIsConcluded = false;
			try {
				// vp[X
				objConclusion.parse();
				blIsConcluded = objConclusion.isConcluded();
			}
			catch( ConclusionParseException cp ) {
				throw new PropagateException( cp.getMessage() );
			}
			catch( ConclusionException ce ) {
				throw new PropagateException( ce.getMessage() );
			}

			if( blIsConcluded ) {
				// v𖞂Ăꍇcomplete
				return true;
			}
		}

		return false;
	}

	/**
	 * w肵LOID̃Xe[^XCȏォǂ𒲂ׂ܂B
	 * @return boolean true: Xe[^XCȏ false: Xe[^Xfailed
	 * @exception SQLException DBG[
	 */
	private boolean isCompleted(String strLoID )
		throws SQLException
	{
		LoLogDataAccess objLoLog = new LoLogDataAccess();

		return objLoLog.isCompleted(mstrUserID, strLoID, mobjDataAccess );
	}

	/**
	 * w肳ꂽLOID̊v𒲂ׁAiĂ邩ǂׂ܂
	 * @return boolean true: @false: 
	 * @exception PropagateException `O
	 */
	private boolean isPassed()
		throws SQLException, PropagateException
	{
		// qIDXg擾
		String strTempID = "";
		Vector vecChildList = getChildList( mstrLoID );
		for( int i = 0; i < vecChildList.size(); i++ ) {
			strTempID = (String)vecChildList.get(i);
			if( !isPassed( strTempID ) ) {
				// ЂƂłfailedꍇXe[^Xfaile
				return false;
			}
		}

		// ЂƂfailȂꍇPassed
		return true;
	}

	/**
	 * w肵LOID̃Xe[^XCȏォǂ𒲂ׂ܂B
	 * @return boolean true: Xe[^XCȏ false: Xe[^Xfailed
	 * @exception SQLException DBG[
	 */
	private boolean isPassed(String strLoID )
		throws SQLException
	{
		LoLogDataAccess objLoLog = new LoLogDataAccess();

		return objLoLog.isPassed(mstrUserID, strLoID, mobjDataAccess );
	}

	/**
	 * w肵LOID̊v擾܂
	 * @param strLoID LOID
	 * @return String v
	 */
	private String getConclusion(String strLoID)
		throws PropagateException, SQLException
	{

		String strConclusion = null;

		// SQLgݗ
		StringBuffer strSQL = new StringBuffer();

		strSQL.append( "SELECT " );
		strSQL.append( LoClient.CONCLUSION );
		strSQL.append( " FROM " );
		strSQL.append( LoClient.TABLE_NAME );
		strSQL.append( " WHERE " );
		strSQL.append( LoClient.LO_ID );
		strSQL.append( "='" );
		strSQL.append( StringEscapeUtils.escapeSql(strLoID) );
		strSQL.append( "'" );

		ResultSet rs = mobjDataAccess.executeQuery( new String(strSQL) );

		if( rs.next() ) {
			strConclusion = rs.getString( LoClient.CONCLUSION );
			if( strConclusion != null ) {
				strConclusion = strConclusion.trim();
			}
		}
		else {
			new PropagateException( "LO is not Exist! :: " + strLoID );
		}

		return strConclusion;
	}

	/**
	 * w肳ꂽLOIDLO^Cv擾܂
	 * @param strLoID
	 * @exception PropagateException
	 * @exception SQLException
	 */
	private String getLoType( String strLoID )
		throws PropagateException, SQLException
	{
		String strLoType = null;

		// SQLgݗ
		StringBuffer strSQL = new StringBuffer();

		strSQL.append( "SELECT " );
		strSQL.append( LoClient.LO_TYPE );
		strSQL.append( " FROM " );
		strSQL.append( LoClient.TABLE_NAME );
		strSQL.append( " WHERE " );
		strSQL.append( LoClient.LO_ID );
		strSQL.append( "='" );
		strSQL.append( StringEscapeUtils.escapeSql(strLoID) );
		strSQL.append( "'" );

		ResultSet rs = mobjDataAccess.executeQuery( new String(strSQL) );

		if( rs.next() ) {
			strLoType = rs.getString( LoClient.LO_TYPE ).trim();
		}
		else {
			new PropagateException( "LO is not Exist! :: " + strLoID );
		}

		return strLoType;
	}

	/**
	 * w肳ꂽLOIDRealLOID擾܂B
	 * @param strLOID
	 * @return String RealLOID
	 * @exception PropagateException
	 * @exception SQLException
	 */
	private String getRealLOID( String strLoID )
		throws PropagateException, SQLException
	{
		String strRealLOID = null;

		// SQLgݗ
		StringBuffer strSQL = new StringBuffer();

		strSQL.append( "SELECT " );
		strSQL.append( LoClient.REAL_LOID );
		strSQL.append( " FROM " );
		strSQL.append( LoClient.TABLE_NAME );
		strSQL.append( " WHERE " );
		strSQL.append( LoClient.LO_ID );
		strSQL.append( "='" );
		strSQL.append( StringEscapeUtils.escapeSql(strLoID) );
		strSQL.append( "'" );

		ResultSet rs = mobjDataAccess.executeQuery( new String(strSQL) );

		if( rs.next() ) {
			strRealLOID = rs.getString( LoClient.REAL_LOID );
			if( strRealLOID != null ) {
				strRealLOID = strRealLOID.trim();
			}
		}
		else {
			new PropagateException( "LO is not Exist! :: " + strLoID );
		}

		return strRealLOID;
	}


	/**
	 * Xe[^XXV
	 * @param strLoID XVΏLOID
	 */
	private void updateStatus()
		throws PropagateException, SQLException
	{

		LoLogDataAccess objLoLog = new LoLogDataAccess();

		// wKJnAݐϊwKԁA_Aō_AŒᓾ_
		// v擾܂B
		LoLogRecord objTotal = objLoLog.getTotal(	mstrUserID,
													mstrLoID,
													mobjDataAccess);
		// [UIDLOIDݒ肷
		objTotal.setUserID( mstrUserID );
		objTotal.setLoID( mstrRealLOID );


		// ̃R[h擾݂̃Xe[^X𔻒f܂
		LoLogRecord objRecord = objLoLog.getLoLog(	mstrUserID,
													mstrRealLOID,
													mobjDataAccess );

		// iXe[^X
		boolean blPassed = false;

		// Xe[^X
		boolean blCompleted = false;

		// ݂̃Xe[^X𔻒f܂
		if( objRecord != null ) {

			// iXe[^X̔f
			if( objRecord.getPassday() != null &&
				!objRecord.getPassday().equals( "" ) )
			{
				// itɓtĂꍇ͍iXe[^Xtrue
				blPassed = true;
			}

			// Xe[^X̔f
			if( objRecord.getStudyEndDate() != null &&
				!objRecord.getStudyEndDate().equals( "" ) )
			{
				// tɓtĂꍇ͊Xe[^Xtrue;
				blCompleted = true;
			}

		}

		// ݓt̐ݒ
		Date objNowDate = new Date();

		// ݂̍iXe[^XfalsȅꍇA
		// LO̍iXe[^X𒲂ׁAiĂA
		// itɌݓtݒ肵܂B
		if( !blPassed ) {
			if( isPassed() ) {

// 2005.03.10 LOXe[^X[AbvύX NTT]ig(Y.URATA) MOD start
				/*
				// itݒ
				objTotal.setPassday( XMODate.parseTime( objNowDate ) );
				*/							
			}else{
				// LO̍iXe[^X𒲂ׁAiĂȂA
				objTotal.setPassday( null );	
			}
		}else{
			// łɍitݒ肳Ăꍇ
			objTotal.setPassday( null );
		}
		
		// ݂̊Xe[^Xfalsȅꍇ
		// v犮Xe[^X𒲂ׁAĂA
		// tɌݓtݒ肵܂B
		if( !blCompleted ) {
			if( isCompleted() ) {
				/*
				// Ctݒ
				objTotal.setStudyEndDate( XMODate.parseTime( objNowDate ) );
				*/
			}else{
				// v犮Xe[^X𒲂ׁAĂȂA
				objTotal.setStudyEndDate( null );
			}
		}else{
				// łɏItݒ肳Ăꍇ
				objTotal.setStudyEndDate( null );
		}		
// 2005.03.10 MOD end


		// wKJnt̓ւ
		if( objRecord != null ) {
			// łɊwKJntݒ肳Ăꍇ
			// wKJnt͍XVΏۂƂȂ
			if( objRecord.getStudyStartDate() != null &&
				!objRecord.getStudyStartDate().equals("") )
			{
				objTotal.setStudyStartDate( null );
			}
		}
		// XV
		objLoLog.insertUpdate( objTotal, mstrUserID, mstrRealLOID, mobjDataAccess );

	}
}


