/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.sqlserver.tds;

import com.microsoft.jdbc.base.BaseColumn;
import com.microsoft.jdbc.base.BaseColumns;
import com.microsoft.jdbc.base.BaseWarnings;
import com.microsoft.jdbc.sqlserver.SQLServerColumn;
import com.microsoft.jdbc.sqlserver.SQLServerImplConnection;
import com.microsoft.jdbc.sqlserver.tds.TDSConnection;
import com.microsoft.jdbc.sqlserver.tds.TDSDateTime;
import com.microsoft.util.UtilByteArray;
import com.microsoft.util.UtilByteOrderedDataReader;
import com.microsoft.util.UtilByteOrderedDataWriter;
import com.microsoft.util.UtilDataConversions;
import com.microsoft.util.UtilDebug;
import com.microsoft.util.UtilException;
import com.microsoft.util.UtilTransliterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Vector;

public class TDSRequest {
    private static String footprint = "$Revision:   1.97.1.3  $";
    protected TDSConnection conn;
    protected int messageType;
    protected int resultType;
    protected int numRowsFetchedFromResultSet;
    protected int numRowsAffected;
    public long returnValue;
    int[] returnValueType = new int[1];
    protected BaseColumns columnDescriptions;
    protected Vector nativeColumns;
    private int longColumnsCount;
    private int lastColumnProcessedForCurrentRow;
    protected SQLException exception;
    public UtilByteOrderedDataReader reader;
    public UtilByteOrderedDataWriter writer;
    private boolean lastRowReturned;
    protected Vector tableNames;
    private byte lookaheadTokenType;

    public TDSRequest(TDSConnection tDSConnection, UtilByteOrderedDataReader utilByteOrderedDataReader, UtilByteOrderedDataWriter utilByteOrderedDataWriter, int n) {
        this.conn = tDSConnection;
        this.reader = utilByteOrderedDataReader;
        this.writer = utilByteOrderedDataWriter;
        this.messageType = n;
        this.resultType = 0;
        this.numRowsAffected = -1;
        this.numRowsFetchedFromResultSet = 0;
        this.columnDescriptions = null;
        this.nativeColumns = null;
        this.tableNames = null;
        this.longColumnsCount = -1;
        this.exception = null;
        this.lastColumnProcessedForCurrentRow = 0;
        this.lastRowReturned = false;
        this.lookaheadTokenType = 0;
    }

    public void completeRowProcessing(BaseWarnings baseWarnings) throws SQLException {
        if (this.resultType == 2 && !this.lastRowReturned) {
            boolean bl = true;
            while (bl) {
                try {
                    bl = this.getRow(baseWarnings);
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            this.lastRowReturned = false;
        }
    }

    public void discardReplyBytes() {
        try {
            this.reader.empty();
        }
        catch (UtilException utilException) {}
    }

    public SQLServerColumn getColumn(int n) {
        return (SQLServerColumn)this.nativeColumns.elementAt(n - 1);
    }

    public void getColumnDataForRow(int n, int n2) throws SQLException {
        if (n > 0 && n <= this.lastColumnProcessedForCurrentRow) {
            return;
        }
        int n3 = this.nativeColumns.size();
        int n4 = n == 0 ? n3 : n;
        int n5 = this.lastColumnProcessedForCurrentRow + 1;
        while (n5 <= n4) {
            SQLServerColumn sQLServerColumn = (SQLServerColumn)this.nativeColumns.elementAt(n5 - 1);
            BaseColumn baseColumn = this.columnDescriptions.get(n5);
            this.returnValueType[0] = -1;
            Object object = this.getReturnedValue(this.returnValueType, sQLServerColumn.TDSType, sQLServerColumn.nonUnicodeCharTransliterator, n2, baseColumn.precision, baseColumn.scale);
            ++this.lastColumnProcessedForCurrentRow;
            sQLServerColumn.setData(object);
            sQLServerColumn.baseDataType = this.returnValueType[0];
            if (object != null && sQLServerColumn.isLongColumn() && (this.lastColumnProcessedForCurrentRow != n4 || n == 0)) {
                try {
                    if (object instanceof Reader) {
                        ((Reader)object).close();
                    } else {
                        ((InputStream)object).close();
                    }
                }
                catch (IOException iOException) {}
            }
            ++n5;
        }
    }

    public BaseColumns getColumnDescriptions() {
        return this.columnDescriptions;
    }

    private void getExtendedMetaData() throws UtilException, SQLException {
        byte by = 0;
        while (true) {
            if ((by = this.getTokenType()) == -87) {
                this.processOrderToken();
                continue;
            }
            if (by == -92) {
                this.processTabName();
                continue;
            }
            if (by != -91) break;
            this.processColInfo();
        }
        this.ungetTokenType(by);
    }

    public String getNameForTokenType(byte by) {
        switch (by) {
            case -120: {
                return new String("ALTMETADATA");
            }
            case -45: {
                return new String("ALTROW");
            }
            case -91: {
                return new String("COLINFO");
            }
            case -127: {
                return new String("COLMETADATA");
            }
            case -3: {
                return new String("DONE");
            }
            case -2: {
                return new String("DONEPROC");
            }
            case -1: {
                return new String("DONEINPROC");
            }
            case -29: {
                return new String("ENVCHANGE");
            }
            case -86: {
                return new String("ERROR");
            }
            case -83: {
                return new String("LOGINACK");
            }
            case -85: {
                return new String("INFO");
            }
            case 120: {
                return new String("OFFSET");
            }
            case -87: {
                return new String("ORDER");
            }
            case 121: {
                return new String("RETURNSTATUS");
            }
            case -47: {
                return new String("ROW");
            }
            case -92: {
                return new String("TABNAME");
            }
        }
        return new String("Unknown token: 0x" + UtilDataConversions.byteToHex((byte)by));
    }

    public String getNameOfUnhandledDataType(byte by) {
        switch (by) {
            case 45: {
                return new String("BINARY");
            }
            case 47: {
                return new String("CHAR");
            }
            case 60: {
                return new String("MONEY");
            }
            case 58: {
                return new String("SMALLDATETIME");
            }
            case 59: {
                return new String("SMALLFLOAT");
            }
            case 122: {
                return new String("SMALLMONEY");
            }
            case 98: {
                return new String("SQLVARIANT");
            }
            case 37: {
                return new String("VARBINARY");
            }
            case 39: {
                return new String("VARCHAR");
            }
            case 31: {
                return new String("VOID");
            }
        }
        return new String("Unknown: 0x" + UtilDataConversions.byteToHex((byte)by));
    }

    public int getNumRowsAffected() {
        return this.numRowsAffected;
    }

    public int getResultType() {
        return this.resultType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object getReturnedValue(int[] nArray, byte by, UtilTransliterator utilTransliterator, int n, int n2, int n3) throws SQLException {
        try {
            Object object = null;
            block1 : switch (by) {
                case -89: 
                case -81: {
                    int n4 = this.reader.readUnsignedInt16();
                    if ((short)n4 == -1) break;
                    this.reader.setTransliterator(utilTransliterator);
                    object = this.reader.readString(n4);
                    nArray[0] = 1010;
                    this.reader.setTransliterator((UtilTransliterator)this.conn.unicodeTransliterator);
                    if (by != -81) break;
                    int n5 = n2 - n4;
                    StringBuffer stringBuffer = new StringBuffer(n5);
                    while (n5 > 0) {
                        stringBuffer.append(' ');
                        --n5;
                    }
                    object = ((String)object).concat(stringBuffer.toString());
                    break;
                }
                case -25: 
                case -17: {
                    int n6 = this.reader.readUnsignedInt16();
                    if ((short)n6 == -1) break;
                    object = this.reader.readString(n6);
                    nArray[0] = 1010;
                    break;
                }
                case 38: {
                    short s = this.reader.readUnsignedInt8();
                    switch (s) {
                        case 1: {
                            object = new Integer(this.reader.readUnsignedInt8());
                            nArray[0] = 1004;
                            break block1;
                        }
                        case 2: {
                            object = new Integer(this.reader.readInt16());
                            nArray[0] = 1004;
                            break block1;
                        }
                        case 4: {
                            object = new Integer(this.reader.readInt32());
                            nArray[0] = 1004;
                            break block1;
                        }
                        case 8: {
                            object = new Long(this.reader.readInt64());
                            nArray[0] = 1005;
                            break block1;
                        }
                        default: {
                            if (object != null) return object;
                        }
                    }
                }
                case 48: {
                    object = new Integer(this.reader.readUnsignedInt8());
                    nArray[0] = 1004;
                    break;
                }
                case 52: {
                    object = new Integer(this.reader.readInt16());
                    nArray[0] = 1004;
                    break;
                }
                case 56: {
                    object = new Integer(this.reader.readInt32());
                    nArray[0] = 1004;
                    break;
                }
                case 127: {
                    object = new Long(this.reader.readInt64());
                    nArray[0] = 1005;
                    break;
                }
                case 106: 
                case 108: {
                    int n7 = this.reader.readUnsignedInt8();
                    if (n7 == 0) break;
                    short s = this.reader.readUnsignedInt8();
                    byte[] byArray = new byte[--n7];
                    this.reader.readBytes(byArray, 0, n7);
                    byte[] byArray2 = new byte[byArray.length];
                    int n8 = 0;
                    while (n8 < byArray.length) {
                        byArray2[n8] = byArray[byArray.length - n8 - 1];
                        ++n8;
                    }
                    BigInteger bigInteger = s == 0 ? new BigInteger(-1, byArray2) : new BigInteger(1, byArray2);
                    object = new BigDecimal(bigInteger, n3);
                    nArray[0] = 1008;
                    break;
                }
                case 110: {
                    BigInteger bigInteger;
                    short s = this.reader.readUnsignedInt8();
                    if (s == 0) break;
                    if (s == 8) {
                        byte[] byArray = new byte[4];
                        byte[] byArray3 = new byte[4];
                        this.reader.readBytes(byArray, 0, 4);
                        UtilByteArray.reverse((byte[])byArray);
                        this.reader.readBytes(byArray3, 0, 4);
                        UtilByteArray.reverse((byte[])byArray3);
                        bigInteger = new BigInteger(UtilByteArray.concatenate((byte[])byArray, (byte[])byArray3));
                    } else {
                        byte[] byArray = new byte[4];
                        this.reader.readBytes(byArray, 0, 4);
                        UtilByteArray.reverse((byte[])byArray);
                        bigInteger = new BigInteger(byArray);
                    }
                    object = new BigDecimal(bigInteger, n3);
                    nArray[0] = 1008;
                    break;
                }
                case 60: {
                    byte[] byArray = new byte[4];
                    byte[] byArray4 = new byte[4];
                    this.reader.readBytes(byArray, 0, 4);
                    UtilByteArray.reverse((byte[])byArray);
                    this.reader.readBytes(byArray4, 0, 4);
                    UtilByteArray.reverse((byte[])byArray4);
                    BigInteger bigInteger = new BigInteger(UtilByteArray.concatenate((byte[])byArray, (byte[])byArray4));
                    object = new BigDecimal(bigInteger, n3);
                    nArray[0] = 1008;
                    break;
                }
                case 122: {
                    byte[] byArray = new byte[4];
                    this.reader.readBytes(byArray, 0, 4);
                    UtilByteArray.reverse((byte[])byArray);
                    BigInteger bigInteger = new BigInteger(byArray);
                    object = new BigDecimal(bigInteger, n3);
                    nArray[0] = 1008;
                    break;
                }
                case 109: {
                    short s = this.reader.readUnsignedInt8();
                    if (s == 0) break;
                    if (s == 4) {
                        float f = this.reader.readIEEE32BitFloat();
                        object = new Float(f);
                        nArray[0] = 1006;
                        break;
                    }
                    double d = this.reader.readIEEE64BitDouble();
                    object = new Double(d);
                    nArray[0] = 1007;
                    break;
                }
                case 62: {
                    object = new Double(this.reader.readIEEE64BitDouble());
                    nArray[0] = 1007;
                    break;
                }
                case 59: {
                    object = new Float(this.reader.readIEEE32BitFloat());
                    nArray[0] = 1006;
                    break;
                }
                case 50: {
                    object = new Byte(this.reader.readInt8());
                    nArray[0] = 1001;
                    break;
                }
                case 104: {
                    byte by2 = this.reader.readInt8();
                    if (by2 == 0) break;
                    object = new Byte(this.reader.readInt8());
                    nArray[0] = 1001;
                    break;
                }
                case -91: 
                case -83: {
                    byte[] byArray;
                    int n9 = this.reader.readUnsignedInt16();
                    if ((short)n9 == -1) break;
                    if (by == -83) {
                        byArray = new byte[n2];
                        this.reader.readBytes(byArray, 0, n9);
                        long l = byArray.length - n9;
                        while (l > 0L) {
                            byArray[(int)((long)n9 + l) - 1] = 0;
                            --l;
                        }
                    } else {
                        byArray = new byte[n9];
                        this.reader.readBytes(byArray, 0, n9);
                    }
                    object = byArray;
                    nArray[0] = 1002;
                    break;
                }
                case 111: {
                    int n10;
                    short s = this.reader.readUnsignedInt8();
                    if (s == 0) break;
                    int n11 = 0;
                    if (s == 4) {
                        n11 = this.reader.readUnsignedInt16();
                        int n12 = this.reader.readUnsignedInt16();
                        n10 = n12 * 18000;
                    } else {
                        n11 = this.reader.readInt32();
                        n10 = this.reader.readInt32();
                    }
                    TDSDateTime tDSDateTime = new TDSDateTime(n11, n10);
                    object = tDSDateTime.timestamp;
                    nArray[0] = 1013;
                    break;
                }
                case 61: {
                    int n13 = this.reader.readInt32();
                    int n14 = this.reader.readInt32();
                    TDSDateTime tDSDateTime = new TDSDateTime(n13, n14);
                    object = tDSDateTime.timestamp;
                    nArray[0] = 1013;
                    break;
                }
                case 58: {
                    int n15 = this.reader.readUnsignedInt16();
                    int n16 = this.reader.readUnsignedInt16() * 18000;
                    TDSDateTime tDSDateTime = new TDSDateTime(n15, n16);
                    object = tDSDateTime.timestamp;
                    nArray[0] = 1013;
                    break;
                }
                case 36: {
                    short s = this.reader.readUnsignedInt8();
                    if (s == 0) break;
                    byte[] byArray = new byte[s];
                    this.reader.readBytes(byArray, 0, (int)s);
                    object = this.uniqueIdentifierToString(byArray);
                    nArray[0] = 1010;
                    break;
                }
                case 34: 
                case 35: 
                case 99: {
                    short s = this.reader.readUnsignedInt8();
                    if (s == 0) break;
                    this.reader.readAndDiscardBytes(s + 8);
                    int n17 = this.reader.readInt32();
                    switch (by) {
                        case 99: {
                            object = this.reader.getReader(n17);
                            nArray[0] = 1018;
                            break block1;
                        }
                        case 35: {
                            this.reader.setTransliterator(utilTransliterator);
                            if (n == 1015) {
                                object = this.reader.getAsciiStream(n17);
                                nArray[0] = 1015;
                            } else {
                                object = this.reader.getReader(n17);
                                nArray[0] = 1018;
                            }
                            this.reader.setTransliterator((UtilTransliterator)this.conn.unicodeTransliterator);
                            break block1;
                        }
                        case 34: {
                            object = this.reader.getInputStream(n17);
                            nArray[0] = 1014;
                            break block1;
                        }
                        default: {
                            if (object != null) return object;
                        }
                    }
                }
                case 98: {
                    int n18 = this.reader.readInt32();
                    if (n18 == 0) break;
                    byte[] byArray = new byte[5];
                    UtilTransliterator utilTransliterator2 = null;
                    int n19 = 0;
                    short s = 0;
                    short s2 = 0;
                    byte by3 = this.reader.readInt8();
                    short s3 = this.reader.readUnsignedInt8();
                    switch (by3) {
                        case -91: 
                        case -83: 
                        case 37: 
                        case 45: {
                            n19 = this.reader.readUnsignedInt16();
                            break;
                        }
                        case -89: 
                        case -81: 
                        case -25: 
                        case -17: 
                        case 39: 
                        case 47: {
                            this.reader.readBytes(byArray, 0, 5);
                            utilTransliterator2 = this.conn.getTransliteratorForCodePage(this.conn.mapCollationToCodePage(byArray));
                            n19 = this.reader.readUnsignedInt16();
                            break;
                        }
                        case 106: 
                        case 108: {
                            s = this.reader.readUnsignedInt8();
                            s2 = this.reader.readUnsignedInt8();
                            break;
                        }
                        case 36: 
                        case 48: 
                        case 50: 
                        case 52: 
                        case 56: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 111: 
                        case 122: 
                        case 127: {
                            UtilDebug.assert((String)"Unexpected sql_variant property", (s3 == 0 ? 1 : 0) != 0);
                            break;
                        }
                        case 34: 
                        case 35: 
                        case 38: 
                        case 55: 
                        case 63: 
                        case 98: 
                        case 99: 
                        case 104: 
                        case 109: 
                        case 110: {
                            UtilDebug.assert((String)"Unexpected sql_variant type.", (boolean)false);
                            break;
                        }
                    }
                    object = this.getSqlVariantValue(n18 - (2 + s3), this.returnValueType, by3, utilTransliterator2, s, s2);
                    break;
                }
                default: {
                    String[] stringArray = new String[]{this.getNameOfUnhandledDataType(by)};
                    throw this.conn.exceptions.getException(11007, stringArray);
                }
            }
            if (object != null) return object;
            nArray[0] = 1019;
            return object;
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public boolean getRow(BaseWarnings baseWarnings) throws SQLException {
        try {
            byte by;
            if (this.numRowsFetchedFromResultSet > 0) {
                this.getColumnDataForRow(0, 1019);
            }
            if ((by = this.getTokenType()) == -47) {
                this.lastColumnProcessedForCurrentRow = 0;
                ++this.numRowsFetchedFromResultSet;
                this.lastRowReturned = false;
                return true;
            }
            if (by == -3 || by == -1) {
                int n = this.reader.readUnsignedInt16();
                int n2 = this.reader.readUnsignedInt16();
                int n3 = this.reader.readInt32();
                if (this.numRowsFetchedFromResultSet != n3 || n3 == 0) {
                    this.processOutstandingCancelAcknowledgements();
                }
            } else {
                this.processReplyToken(by, baseWarnings);
            }
            if (this.exception != null) {
                throw this.exception;
            }
            this.lastRowReturned = true;
            return false;
        }
        catch (UtilException utilException) {
            this.lastRowReturned = true;
            return false;
        }
    }

    Object getSqlVariantValue(int n, int[] nArray, byte by, UtilTransliterator utilTransliterator, int n2, int n3) throws SQLException {
        try {
            Object object = null;
            switch (by) {
                case -89: 
                case -81: {
                    this.reader.setTransliterator(utilTransliterator);
                    object = this.reader.readString(n);
                    nArray[0] = 1010;
                    this.reader.setTransliterator((UtilTransliterator)this.conn.unicodeTransliterator);
                    if (by != -81) break;
                    int n4 = n2 - n;
                    StringBuffer stringBuffer = new StringBuffer(n4);
                    while (n4 > 0) {
                        stringBuffer.append(' ');
                        --n4;
                    }
                    object = ((String)object).concat(stringBuffer.toString());
                    break;
                }
                case -25: 
                case -17: {
                    object = this.reader.readString(n);
                    nArray[0] = 1010;
                    break;
                }
                case 48: {
                    object = new Integer(this.reader.readUnsignedInt8());
                    nArray[0] = 1004;
                    break;
                }
                case 52: {
                    object = new Integer(this.reader.readInt16());
                    nArray[0] = 1004;
                    break;
                }
                case 56: {
                    object = new Integer(this.reader.readInt32());
                    nArray[0] = 1004;
                    break;
                }
                case 127: {
                    object = new Long(this.reader.readInt64());
                    nArray[0] = 1005;
                    break;
                }
                case 106: 
                case 108: {
                    short s = this.reader.readUnsignedInt8();
                    byte[] byArray = new byte[--n];
                    this.reader.readBytes(byArray, 0, n);
                    byte[] byArray2 = new byte[byArray.length];
                    int n5 = 0;
                    while (n5 < byArray.length) {
                        byArray2[n5] = byArray[byArray.length - n5 - 1];
                        ++n5;
                    }
                    BigInteger bigInteger = s == 0 ? new BigInteger(-1, byArray2) : new BigInteger(1, byArray2);
                    object = new BigDecimal(bigInteger, n3);
                    nArray[0] = 1008;
                    break;
                }
                case 60: {
                    byte[] byArray = new byte[4];
                    byte[] byArray3 = new byte[4];
                    this.reader.readBytes(byArray, 0, 4);
                    UtilByteArray.reverse((byte[])byArray);
                    this.reader.readBytes(byArray3, 0, 4);
                    UtilByteArray.reverse((byte[])byArray3);
                    BigInteger bigInteger = new BigInteger(UtilByteArray.concatenate((byte[])byArray, (byte[])byArray3));
                    object = new BigDecimal(bigInteger, n3);
                    nArray[0] = 1008;
                    break;
                }
                case 122: {
                    byte[] byArray = new byte[4];
                    this.reader.readBytes(byArray, 0, 4);
                    UtilByteArray.reverse((byte[])byArray);
                    BigInteger bigInteger = new BigInteger(byArray);
                    object = new BigDecimal(bigInteger, n3);
                    nArray[0] = 1008;
                    break;
                }
                case 62: {
                    object = new Double(this.reader.readIEEE64BitDouble());
                    nArray[0] = 1007;
                    break;
                }
                case 59: {
                    object = new Float(this.reader.readIEEE32BitFloat());
                    nArray[0] = 1007;
                    break;
                }
                case 50: {
                    object = new Byte(this.reader.readInt8());
                    nArray[0] = 1001;
                    break;
                }
                case -91: 
                case -83: {
                    byte[] byArray;
                    if (by == -83) {
                        byArray = new byte[n2];
                        this.reader.readBytes(byArray, 0, n);
                        long l = byArray.length - n;
                        while (l > 0L) {
                            byArray[(int)((long)n + l) - 1] = 0;
                            --l;
                        }
                    } else {
                        byArray = new byte[n];
                        this.reader.readBytes(byArray, 0, n);
                    }
                    object = byArray;
                    nArray[0] = 1002;
                    break;
                }
                case 61: {
                    int n6 = this.reader.readInt32();
                    int n7 = this.reader.readInt32();
                    TDSDateTime tDSDateTime = new TDSDateTime(n6, n7);
                    object = tDSDateTime.timestamp;
                    nArray[0] = 1013;
                    break;
                }
                case 58: {
                    int n8 = this.reader.readUnsignedInt16();
                    int n9 = this.reader.readUnsignedInt16() * 18000;
                    TDSDateTime tDSDateTime = new TDSDateTime(n8, n9);
                    object = tDSDateTime.timestamp;
                    nArray[0] = 1013;
                    break;
                }
                case 36: {
                    byte[] byArray = new byte[n];
                    this.reader.readBytes(byArray, 0, n);
                    object = this.uniqueIdentifierToString(byArray);
                    nArray[0] = 1010;
                    break;
                }
                default: {
                    String[] stringArray = new String[]{this.getNameOfUnhandledDataType(by)};
                    throw this.conn.exceptions.getException(11007, stringArray);
                }
            }
            return object;
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }

    private byte getTokenType() throws UtilException {
        byte by;
        if (this.lookaheadTokenType == 0) {
            by = this.reader.readInt8();
        } else {
            by = this.lookaheadTokenType;
            this.lookaheadTokenType = 0;
        }
        return by;
    }

    public boolean hasLongColumns() {
        if (this.longColumnsCount == -1) {
            this.longColumnsCount = 0;
            int n = 0;
            while (n < this.nativeColumns.size()) {
                SQLServerColumn sQLServerColumn = (SQLServerColumn)this.nativeColumns.elementAt(n);
                if (sQLServerColumn.isLongColumn()) {
                    ++this.longColumnsCount;
                }
                ++n;
            }
        }
        return this.longColumnsCount > 0;
    }

    void processColInfo() throws UtilException, SQLException {
        int n = this.reader.readUnsignedInt16();
        int n2 = 1;
        while (n2 <= this.nativeColumns.size()) {
            short s;
            short s2 = this.reader.readUnsignedInt8();
            BaseColumn baseColumn = this.columnDescriptions.get(n2);
            short s3 = this.reader.readUnsignedInt8();
            if (s3 != 0 && this.tableNames != null && s3 <= this.tableNames.size()) {
                baseColumn.tableName = (String)this.tableNames.elementAt(s3 - 1);
            }
            if (((s = this.reader.readUnsignedInt8()) & 0x10) != 0) {
                baseColumn.isHidden = true;
            }
            if ((s & 8) != 0) {
                baseColumn.isKey = true;
            }
            if ((s & 0x20) != 0) {
                String string = this.reader.readString(this.reader.readUnsignedInt8() * 2);
            }
            ++n2;
        }
        this.columnDescriptions.resetCount();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void processColMetaData() throws UtilException, SQLException {
        this.lastRowReturned = false;
        if (this.tableNames != null) {
            this.tableNames.removeAllElements();
        }
        if ((var1_1 = this.reader.readUnsignedInt16()) == 65535) {
            return;
        }
        this.columnDescriptions = new BaseColumns();
        this.nativeColumns = new Vector<E>();
        this.longColumnsCount = -1;
        var2_2 = 1;
        while (var2_2 <= var1_1) {
            block66: {
                block65: {
                    block64: {
                        var3_3 = 0;
                        var4_4 = 0;
                        var5_5 = 0;
                        var6_6 = new BaseColumn();
                        var7_7 = new SQLServerColumn();
                        var8_8 = this.reader.readUnsignedInt16();
                        var9_9 = this.reader.readUnsignedInt16();
                        var7_7.TDSType = var10_10 = this.reader.readInt8();
                        switch (var10_10) {
                            case 36: 
                            case 38: 
                            case 104: 
                            case 106: 
                            case 108: 
                            case 109: 
                            case 110: 
                            case 111: {
                                var5_5 = this.reader.readUnsignedInt8();
                                break;
                            }
                            case -91: 
                            case -89: 
                            case -83: 
                            case -81: 
                            case -25: 
                            case -17: {
                                var5_5 = this.reader.readUnsignedInt16();
                                break;
                            }
                            case 34: 
                            case 35: 
                            case 99: {
                                var5_5 = (int)this.reader.readUnsignedInt32();
                                break;
                            }
                            case 98: {
                                var5_5 = (int)this.reader.readUnsignedInt32() - 9;
                                break;
                            }
                        }
                        if (var10_10 == 106 || var10_10 == 108) {
                            var3_3 = this.reader.readUnsignedInt8();
                            var4_4 = this.reader.readUnsignedInt8();
                        }
                        if (this.conn.getTDSVersion() != 2) break block64;
                        var11_11 /* !! */  = new byte[5];
                        switch (var10_10) {
                            case -89: 
                            case -81: 
                            case 35: {
                                this.reader.readBytes(var11_11 /* !! */ , 0, 5);
                                var6_6.transliterator = var7_7.nonUnicodeCharTransliterator = this.conn.getTransliteratorForCodePage(this.conn.mapCollationToCodePage(var11_11 /* !! */ ));
                                ** GOTO lbl54
                            }
                            case -25: 
                            case -17: 
                            case 99: {
                                this.reader.readBytes(var11_11 /* !! */ , 0, 5);
                                var6_6.transliterator = this.conn.unicodeTransliterator;
                                ** GOTO lbl54
                            }
                            default: {
                                if (var10_10 == 35) break block65;
                            }
                        }
                    }
                    if (var10_10 == -81 || var10_10 == -89 || var10_10 == 35) {
                        var7_7.nonUnicodeCharTransliterator = this.conn.nonUnicodeTransliterator;
                        var6_6.transliterator = this.conn.nonUnicodeTransliterator;
                    }
lbl54:
                    // 5 sources

                    if (var10_10 == 35) break block65;
                    if (var10_10 != 99 && var10_10 != 34) break block66;
                }
                var6_6.tableName = this.reader.readString(this.reader.readUnsignedInt16() * 2);
            }
            var6_6.label = var6_6.name = this.reader.readString(this.reader.readUnsignedInt8() * 2);
            switch (var7_7.TDSType) {
                case 50: 
                case 104: {
                    var6_6.isSearchable = true;
                    var6_6.isSigned = false;
                    var6_6.setType(-7);
                    var6_6.typeName = new String("bit");
                    break;
                }
                case -25: {
                    var6_6.displaySize = var5_5 / 2;
                    var6_6.precision = var5_5 / 2;
                    var6_6.isSearchable = true;
                    var6_6.isSigned = false;
                    var6_6.setType(12);
                    var6_6.typeName = new String("nvarchar");
                    break;
                }
                case -89: {
                    var6_6.displaySize = var5_5;
                    var6_6.precision = var5_5;
                    var6_6.isSearchable = true;
                    var6_6.isSigned = false;
                    var6_6.setType(12);
                    var6_6.typeName = new String("varchar");
                    break;
                }
                case -17: {
                    var6_6.displaySize = var5_5 / 2;
                    var6_6.precision = var5_5 / 2;
                    var6_6.isSearchable = true;
                    var6_6.isSigned = false;
                    var6_6.setType(1);
                    var6_6.typeName = new String("nchar");
                    break;
                }
                case -81: {
                    var6_6.displaySize = var5_5;
                    var6_6.precision = var5_5;
                    var6_6.isSearchable = true;
                    var6_6.isSigned = false;
                    var6_6.setType(1);
                    var6_6.typeName = new String("char");
                    break;
                }
                case -83: {
                    var6_6.precision = var5_5;
                    var6_6.displaySize = var6_6.precision * 2;
                    var6_6.isSearchable = true;
                    var6_6.isSigned = false;
                    var6_6.setType(-2);
                    if (var8_8 == 80) {
                        var6_6.typeName = new String("timestamp");
                        break;
                    }
                    var6_6.typeName = new String("binary");
                    break;
                }
                case -91: {
                    var6_6.precision = var5_5;
                    var6_6.displaySize = var6_6.precision * 2;
                    var6_6.isSearchable = true;
                    var6_6.isSigned = false;
                    var6_6.setType(-3);
                    var6_6.typeName = new String("varbinary");
                    break;
                }
                case 106: 
                case 108: {
                    var6_6.precision = var3_3;
                    var6_6.displaySize = var6_6.precision + 2;
                    var6_6.scale = var4_4;
                    if (var6_6.precision == var6_6.scale) {
                        ++var6_6.displaySize;
                    }
                    var6_6.isSearchable = true;
                    if (var7_7.getTDSType() == 108) {
                        var6_6.setType(2);
                        var6_6.typeName = new String("numeric");
                        break;
                    }
                    var6_6.setType(3);
                    var6_6.typeName = new String("decimal");
                    break;
                }
                case 38: {
                    var6_6.isSearchable = true;
                    if (var5_5 == 1) {
                        var6_6.typeName = new String("tinyint");
                        var6_6.setType(-6);
                        var6_6.displaySize = 3;
                        var6_6.isSigned = false;
                        break;
                    }
                    if (var5_5 == 2) {
                        var6_6.typeName = new String("smallint");
                        var6_6.setType(5);
                        break;
                    }
                    if (var5_5 == 4) {
                        var6_6.typeName = new String("int");
                        var6_6.setType(4);
                        break;
                    }
                    if (var5_5 == 8) {
                        var6_6.typeName = new String("bigint");
                        var6_6.setType(-5);
                        break;
                    }
                    UtilDebug.assert((String)"Unexpected integer length returned", (boolean)false);
                    break;
                }
                case 111: {
                    var6_6.isSearchable = true;
                    var6_6.isSigned = false;
                    var6_6.setType(93);
                    if (var5_5 == 4) {
                        var6_6.typeName = new String("smalldatetime");
                        var6_6.displaySize = 16;
                        var6_6.precision = 16;
                        var6_6.scale = 0;
                        break;
                    }
                    if (var5_5 != 8) break;
                    var6_6.typeName = new String("datetime");
                    var6_6.displaySize = 23;
                    var6_6.precision = 23;
                    var6_6.scale = 3;
                    break;
                }
                case 61: {
                    var6_6.isSearchable = true;
                    var6_6.isSigned = false;
                    var6_6.typeName = new String("datetime");
                    var6_6.setType(93);
                    var6_6.displaySize = 23;
                    var6_6.precision = 23;
                    var6_6.scale = 3;
                    break;
                }
                case 58: {
                    var6_6.isSearchable = true;
                    var6_6.isSigned = false;
                    var6_6.typeName = new String("smalldatetime");
                    var6_6.setType(93);
                    var6_6.displaySize = 16;
                    var6_6.precision = 16;
                    var6_6.scale = 3;
                    break;
                }
                case 36: {
                    var6_6.displaySize = 36;
                    var6_6.precision = 36;
                    var6_6.isSearchable = true;
                    var6_6.isSigned = false;
                    var6_6.setType(1);
                    var6_6.typeName = new String("uniqueidentifier");
                    break;
                }
                case 110: {
                    var6_6.scale = 4;
                    var6_6.isCurrency = true;
                    var6_6.isSearchable = true;
                    var6_6.setType(3);
                    if (var5_5 == 4) {
                        var6_6.typeName = new String("smallmoney");
                        var6_6.displaySize = 12;
                        var6_6.precision = 10;
                        break;
                    }
                    if (var5_5 != 8) break;
                    var6_6.typeName = new String("money");
                    var6_6.displaySize = 21;
                    var6_6.precision = 19;
                    break;
                }
                case 60: {
                    var6_6.scale = 4;
                    var6_6.isCurrency = true;
                    var6_6.isSearchable = true;
                    var6_6.setType(3);
                    var6_6.typeName = new String("money");
                    var6_6.displaySize = 21;
                    var6_6.precision = 19;
                    break;
                }
                case 122: {
                    var6_6.scale = 4;
                    var6_6.isCurrency = true;
                    var6_6.isSearchable = true;
                    var6_6.setType(3);
                    var6_6.typeName = new String("smallmoney");
                    var6_6.displaySize = 12;
                    var6_6.precision = 10;
                    break;
                }
                case 109: {
                    var6_6.isSearchable = true;
                    if (var5_5 == 4) {
                        var6_6.typeName = new String("real");
                        var6_6.setType(7);
                        break;
                    }
                    if (var5_5 != 8) break;
                    var6_6.typeName = new String("float");
                    var6_6.setType(6);
                    break;
                }
                case 62: {
                    var6_6.isSearchable = true;
                    var6_6.typeName = new String("float");
                    var6_6.setType(6);
                    break;
                }
                case 59: {
                    var6_6.isSearchable = true;
                    var6_6.typeName = new String("real");
                    var6_6.setType(7);
                    break;
                }
                case 48: {
                    var6_6.isSearchable = true;
                    var6_6.setType(-6);
                    var6_6.typeName = new String("tinyint");
                    break;
                }
                case 52: {
                    var6_6.isSearchable = true;
                    var6_6.setType(5);
                    var6_6.typeName = new String("smallint");
                    break;
                }
                case 56: {
                    var6_6.isSearchable = true;
                    var6_6.setType(4);
                    var6_6.typeName = new String("int");
                    break;
                }
                case 127: {
                    var6_6.isSearchable = true;
                    var6_6.setType(-5);
                    var6_6.typeName = new String("bigint");
                    break;
                }
                case 34: {
                    var6_6.displaySize = var5_5;
                    var6_6.precision = var5_5;
                    var6_6.isSigned = false;
                    var6_6.isSearchable = false;
                    var6_6.setType(-4);
                    var6_6.typeName = new String("image");
                    break;
                }
                case 35: {
                    var6_6.displaySize = var5_5;
                    var6_6.precision = var5_5;
                    var6_6.isSigned = false;
                    var6_6.isSearchable = true;
                    var6_6.setType(-1);
                    var6_6.baseDataType = 1018;
                    var6_6.typeName = new String("text");
                    break;
                }
                case 99: {
                    var6_6.displaySize = var5_5 / 2;
                    var6_6.precision = var5_5 / 2;
                    var6_6.isSigned = false;
                    var6_6.isSearchable = true;
                    var6_6.setType(-1);
                    var6_6.typeName = new String("ntext");
                    break;
                }
                case 98: {
                    var6_6.displaySize = var5_5;
                    var6_6.precision = 0;
                    var6_6.isSigned = false;
                    var6_6.isSearchable = true;
                    var6_6.setType(12);
                    var6_6.typeName = new String("sql_variant");
                    break;
                }
                default: {
                    var11_11 /* !! */  = (byte[])new String[]{this.getNameOfUnhandledDataType(var7_7.getTDSType())};
                    throw this.conn.exceptions.getException(11007, (String[])var11_11 /* !! */ );
                }
            }
            var6_6.isNullable = (var9_9 & 1) == 0 ? 0 : 1;
            if ((var9_9 & 16) == 0) {
                var6_6.isAutoIncrement = false;
            } else {
                var6_6.isAutoIncrement = true;
                var6_6.typeName = String.valueOf(var6_6.typeName) + " identity";
            }
            var6_6.isCaseSensitive = (var9_9 & 2) != 0;
            var6_6.isDefinitelyWritable = false;
            switch (var9_9 & 12) {
                case 0: {
                    var6_6.isReadOnly = true;
                    var6_6.isWritable = false;
                    break;
                }
                case 4: {
                    var6_6.isReadOnly = false;
                    var6_6.isWritable = true;
                    break;
                }
                case 8: {
                    var6_6.isReadOnly = false;
                    var6_6.isWritable = true;
                    break;
                }
                default: {
                    UtilDebug.assert((String)"Unexpected read flags", (boolean)false);
                }
            }
            this.columnDescriptions.add(var6_6);
            this.nativeColumns.addElement(var7_7);
            ++var2_2;
        }
        this.resultType = 2;
        this.numRowsFetchedFromResultSet = 0;
        this.getExtendedMetaData();
    }

    void processEnvChange(BaseWarnings baseWarnings) throws UtilException {
        Object[] objectArray;
        String string = "";
        String string2 = "";
        int n = this.reader.readUnsignedInt16() - 1;
        byte by = this.reader.readInt8();
        String string3 = "";
        switch (by) {
            case 1: {
                string3 = String.valueOf(string3) + "Database changed";
                break;
            }
            case 2: {
                string3 = String.valueOf(string3) + "Language changed";
                break;
            }
            case 3: {
                string3 = String.valueOf(string3) + "Character set changed";
                break;
            }
            case 4: {
                string3 = String.valueOf(string3) + "Packet size changed";
                break;
            }
            case 5: {
                string3 = String.valueOf(string3) + "Unicode LCID changed";
                break;
            }
            case 6: {
                string3 = String.valueOf(string3) + "Unicode data sorting comparison changed";
                break;
            }
            case 7: {
                string3 = String.valueOf(string3) + "SQL collation changed";
                break;
            }
            default: {
                UtilDebug.assert((String)"Unrecognized environment change type.", (boolean)false);
            }
        }
        byte by2 = this.reader.readInt8();
        if (by == 7) {
            objectArray = new byte[by2];
            this.reader.readBytes(objectArray, 0, (int)by2);
            try {
                this.conn.setSQLCollation((byte[])objectArray);
            }
            catch (SQLException sQLException) {
                this.exception = sQLException;
            }
        } else if (by == 3) {
            string = this.reader.readString(by2 * 2);
            try {
                this.conn.setNonUnicodeTransliterator(string);
            }
            catch (SQLException sQLException) {
                this.exception = sQLException;
            }
        } else {
            string = this.reader.readString(by2 * 2);
        }
        string3 = String.valueOf(string3) + " to " + string;
        by2 = this.reader.readInt8();
        if (by == 7) {
            this.reader.readAndDiscardBytes((int)by2);
        } else {
            string2 = this.reader.readString(by2 * 2);
        }
        if (by == 1 || by == 2) {
            if (by == 1) {
                this.conn.setCatalog(string);
            }
            objectArray = new String[]{string3};
            baseWarnings.add(6002, (String[])objectArray);
        } else if (by == 4) {
            this.conn.setPacketSize(Integer.valueOf(string));
        }
    }

    void processErrorToken() throws SQLException {
        try {
            int n = this.reader.readUnsignedInt16();
            int n2 = this.reader.readInt32();
            short s = this.reader.readUnsignedInt8();
            short s2 = this.reader.readUnsignedInt8();
            String string = this.reader.readString(this.reader.readUnsignedInt16() * 2);
            String string2 = this.reader.readString(this.reader.readUnsignedInt8() * 2);
            String string3 = this.reader.readString(this.reader.readUnsignedInt8() * 2);
            int n3 = this.reader.readUnsignedInt16();
            String[] stringArray = new String[]{string};
            this.exception = this.conn.exceptions.getException(this.exception, 1, 6002, stringArray, SQLServerImplConnection.mapNativeErrorToSQLState(n2), n2);
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }

    boolean processInfoToken(BaseWarnings baseWarnings) throws SQLException {
        boolean bl = true;
        try {
            int n = this.reader.readUnsignedInt16();
            if (baseWarnings == null) {
                this.reader.readAndDiscardBytes(n);
            } else {
                int n2 = this.reader.readInt32();
                byte by = this.reader.readInt8();
                byte by2 = this.reader.readInt8();
                String string = this.reader.readString(this.reader.readUnsignedInt16() * 2);
                this.reader.readString(this.reader.readInt8() * 2);
                this.reader.readString(this.reader.readInt8() * 2);
                this.reader.readUnsignedInt16();
                String[] stringArray = new String[]{string};
                if (this.exception != null) {
                    this.exception = this.conn.exceptions.getException(this.exception, 1, 6002, stringArray, SQLServerImplConnection.mapNativeErrorToSQLState(n2), n2);
                } else {
                    baseWarnings.add(6002, stringArray, "", 0);
                }
                bl = this.processInfoTokenAction(n2, by, by2);
            }
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
        return bl;
    }

    protected boolean processInfoTokenAction(int n, byte by, byte by2) {
        return true;
    }

    void processOrderToken() throws UtilException, SQLException {
        int n = this.reader.readUnsignedInt16();
        this.reader.readAndDiscardBytes(n);
    }

    void processOutstandingCancelAcknowledgements() {
        if (this.conn.numOutstandingCancelRequests == 0) {
            return;
        }
        this.conn.socketProvider.setTimeoutValue(1000);
        int n = 0;
        while (n < this.conn.numOutstandingCancelRequests) {
            try {
                this.reader.receive();
                this.processReply(null);
            }
            catch (Exception exception) {}
            ++n;
        }
        this.conn.socketProvider.setTimeoutValue(0);
        this.conn.numOutstandingCancelRequests = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processReply(BaseWarnings baseWarnings) throws SQLException {
        try {
            try {
                boolean bl = true;
                this.exception = null;
                while (bl) {
                    byte by = this.getTokenType();
                    bl = this.processReplyToken(by, baseWarnings);
                }
            }
            catch (UtilException utilException) {
                if (utilException.getReason() != 1001) {
                    throw this.conn.exceptions.getException((Exception)((Object)utilException));
                }
                this.processOutstandingCancelAcknowledgements();
                this.resultType = 1;
            }
            Object var3_5 = null;
            if (this.exception == null) return;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            if (this.exception == null) throw throwable;
            throw this.exception;
        }
        throw this.exception;
    }

    public boolean processReplyToken(byte by, BaseWarnings baseWarnings) throws SQLException {
        boolean bl = true;
        try {
            switch (by) {
                case -3: 
                case -2: 
                case -1: {
                    int n = this.reader.readUnsignedInt16();
                    int n2 = this.reader.readUnsignedInt16();
                    if ((n & 0x20) != 0) {
                        --this.conn.numOutstandingCancelRequests;
                        this.reader.empty();
                        this.exception = this.conn.exceptions.getException(this.exception, 1, 6079, "HY008");
                        bl = true;
                    } else if ((n & 2) != 0 && this.exception == null) {
                        String[] stringArray = new String[]{"An unspecified error occurred"};
                        this.exception = this.conn.exceptions.getException(this.exception, 1, 11009);
                        this.reader.readInt32();
                        bl = true;
                    } else if ((n & 0x10) != 0 && n2 != 193) {
                        this.resultType = 3;
                        this.numRowsAffected = this.reader.readInt32();
                        bl = false;
                    } else if (n2 == 198 || n2 == 216 || n2 == 199 || n2 == 222 || n2 == 223) {
                        this.reader.readInt32();
                        this.resultType = 3;
                        this.numRowsAffected = 0;
                        bl = false;
                    } else {
                        this.reader.readInt32();
                        this.numRowsAffected = -1;
                        bl = true;
                    }
                    break;
                }
                case -47: {
                    this.ungetTokenType(by);
                    bl = false;
                    break;
                }
                case -92: {
                    this.processTabName();
                    bl = true;
                    break;
                }
                case -91: {
                    this.processColInfo();
                    bl = true;
                    break;
                }
                case -87: {
                    this.processOrderToken();
                    bl = true;
                    break;
                }
                case -85: {
                    bl = this.processInfoToken(baseWarnings);
                    break;
                }
                case 121: {
                    this.returnValue = this.reader.readInt32();
                    bl = true;
                    break;
                }
                case -84: {
                    int n = this.reader.readUnsignedInt16();
                    this.reader.readAndDiscardBytes(n);
                    bl = true;
                    break;
                }
                case -86: {
                    this.processErrorToken();
                    bl = true;
                    break;
                }
                case -29: {
                    this.processEnvChange(baseWarnings);
                    break;
                }
                case -120: 
                case -45: {
                    throw this.conn.exceptions.getException(11017);
                }
                default: {
                    String[] stringArray = new String[]{this.getNameForTokenType(by)};
                    throw this.conn.exceptions.getException(11005, stringArray);
                }
            }
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
        return bl;
    }

    void processTabName() throws UtilException, SQLException {
        this.tableNames = new Vector();
        int n = this.reader.readUnsignedInt16();
        while (n > 0) {
            int n2 = this.reader.readUnsignedInt16() * 2;
            if (n2 == 0) {
                this.tableNames.addElement("");
            } else {
                this.tableNames.addElement(this.reader.readString(n2));
            }
            n -= n2 + 2;
        }
    }

    public void submitRequest() throws SQLException {
    }

    private void ungetTokenType(byte by) {
        this.lookaheadTokenType = by;
    }

    private String uniqueIdentifierToString(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] cArray2 = new char[]{cArray[byArray[3] >> 4 & 0xF], cArray[byArray[3] & 0xF], cArray[byArray[2] >> 4 & 0xF], cArray[byArray[2] & 0xF], cArray[byArray[1] >> 4 & 0xF], cArray[byArray[1] & 0xF], cArray[byArray[0] >> 4 & 0xF], cArray[byArray[0] & 0xF], '-', cArray[byArray[5] >> 4 & 0xF], cArray[byArray[5] & 0xF], cArray[byArray[4] >> 4 & 0xF], cArray[byArray[4] & 0xF], '-', cArray[byArray[7] >> 4 & 0xF], cArray[byArray[7] & 0xF], cArray[byArray[6] >> 4 & 0xF], cArray[byArray[6] & 0xF], '-', cArray[byArray[8] >> 4 & 0xF], cArray[byArray[8] & 0xF], cArray[byArray[9] >> 4 & 0xF], cArray[byArray[9] & 0xF], '-', cArray[byArray[10] >> 4 & 0xF], cArray[byArray[10] & 0xF], cArray[byArray[11] >> 4 & 0xF], cArray[byArray[11] & 0xF], cArray[byArray[12] >> 4 & 0xF], cArray[byArray[12] & 0xF], cArray[byArray[13] >> 4 & 0xF], cArray[byArray[13] & 0xF], cArray[byArray[14] >> 4 & 0xF], cArray[byArray[14] & 0xF], cArray[byArray[15] >> 4 & 0xF], cArray[byArray[15] & 0xF]};
        return new String(cArray2);
    }
}

