/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.util;

import com.microsoft.util.UtilDataConsumer;
import com.microsoft.util.UtilDataConversions;
import com.microsoft.util.UtilException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class UtilBufferedDataConsumer
implements UtilDataConsumer {
    private static String footprint = "$Revision:   1.3.1.1  $";
    private byte[] buffer;
    private int currentBufferInsertPosition;
    private int numBytesPlacedInBuffer;
    private int bufferSizeIncrement;
    private boolean printDebugInfo;
    private PrintWriter debugOutputStream;
    private UtilDataConsumer dataConsumerObject;
    public static final int END_OF_BUFFER = Integer.MAX_VALUE;

    public UtilBufferedDataConsumer(UtilDataConsumer utilDataConsumer) {
        this.dataConsumerObject = utilDataConsumer;
        this.currentBufferInsertPosition = 0;
        this.numBytesPlacedInBuffer = 0;
        this.bufferSizeIncrement = 4096;
        this.printDebugInfo = false;
    }

    private void assureBufferSpace(int n) {
        int n2;
        int n3 = n2 = this.buffer == null ? 0 : this.buffer.length;
        if (this.currentBufferInsertPosition + n <= n2) {
            return;
        }
        int n4 = n2 + n / this.bufferSizeIncrement * this.bufferSizeIncrement + (n % this.bufferSizeIncrement == 0 ? 0 : this.bufferSizeIncrement);
        byte[] byArray = new byte[n4];
        this.bufferSizeIncrement *= 2;
        if (this.buffer != null && this.numBytesPlacedInBuffer != 0) {
            System.arraycopy(this.buffer, 0, byArray, 0, this.numBytesPlacedInBuffer);
        }
        this.buffer = byArray;
    }

    public void clearBuffer() {
        this.currentBufferInsertPosition = 0;
        this.numBytesPlacedInBuffer = 0;
    }

    public void disableDebugInfo() {
        this.printDebugInfo = false;
    }

    public void enableDebugInfo() throws IOException {
        if (this.debugOutputStream == null) {
            File file = new File("c:\\UtilBufferedDataConsumer.out");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.debugOutputStream = new PrintWriter(fileOutputStream);
        }
        this.printDebugInfo = true;
    }

    public int getPosition() {
        return this.currentBufferInsertPosition;
    }

    public void putArrayOfBytes(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 <= 0) {
            return;
        }
        this.assureBufferSpace(n2);
        System.arraycopy(byArray, n, this.buffer, this.currentBufferInsertPosition, n2);
        this.currentBufferInsertPosition += n2;
        if (this.currentBufferInsertPosition > this.numBytesPlacedInBuffer) {
            this.numBytesPlacedInBuffer = this.currentBufferInsertPosition;
        }
    }

    public void putByte(byte by) throws UtilException {
        this.assureBufferSpace(1);
        this.buffer[this.currentBufferInsertPosition++] = by;
        if (this.currentBufferInsertPosition >= this.numBytesPlacedInBuffer) {
            this.numBytesPlacedInBuffer = this.currentBufferInsertPosition;
        }
    }

    public void send() throws UtilException {
        if (this.printDebugInfo) {
            this.debugOutputStream.print("\n\n*************** Writing ");
            this.debugOutputStream.print(this.numBytesPlacedInBuffer);
            this.debugOutputStream.print(" bytes ***************");
            int n = 0;
            while (n < this.numBytesPlacedInBuffer) {
                if (n % 20 == 0) {
                    this.debugOutputStream.print("\n");
                }
                this.debugOutputStream.print(String.valueOf(UtilDataConversions.byteToHex(this.buffer[n])) + " ");
                ++n;
            }
            this.debugOutputStream.print("\n***********************************************************");
            this.debugOutputStream.flush();
        }
        this.dataConsumerObject.putArrayOfBytes(this.buffer, 0, this.numBytesPlacedInBuffer);
        this.dataConsumerObject.send();
        this.currentBufferInsertPosition = 0;
        this.numBytesPlacedInBuffer = 0;
    }

    public void setBufferIncrementSize(int n) {
        this.bufferSizeIncrement = n;
    }

    public void setPosition(int n) {
        this.currentBufferInsertPosition = n < 0 ? 0 : (n > this.numBytesPlacedInBuffer || n == Integer.MAX_VALUE ? this.numBytesPlacedInBuffer : n);
    }
}

