/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ntt.lms.installer.lms;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Logger;
import jp.co.ntt.lms.installer.core.InstallerAction;
import jp.co.ntt.lms.installer.core.InstallerActionValue;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.core.util.InstallerDatabaseUtil;
import jp.co.ntt.lms.installer.core.util.InstallerFileUtil;
import jp.co.ntt.lms.installer.core.util.InstallerUiUtil;
import jp.co.ntt.lms.installer.lms.ConfirmDbInitializeValue;
import jp.co.ntt.lms.installer.lms.ManagerInputValue;
import jp.co.ntt.lms.installer.util.LoggerUtil;
import jp.co.ntt.lms.installer.util.StringUtil;

public abstract class CreateDbAbstractAction
implements InstallerAction {
    private static Logger _logger = LoggerUtil.getLogger(class$jp$co$ntt$lms$installer$lms$CreateDbAbstractAction == null ? (class$jp$co$ntt$lms$installer$lms$CreateDbAbstractAction = CreateDbAbstractAction.class$("jp.co.ntt.lms.installer.lms.CreateDbAbstractAction")) : class$jp$co$ntt$lms$installer$lms$CreateDbAbstractAction);
    private Connection _dbaConection;
    private Connection _lmsConection;
    static /* synthetic */ Class class$jp$co$ntt$lms$installer$lms$CreateDbAbstractAction;
    static /* synthetic */ Class class$jp$co$ntt$lms$installer$lms$ConfirmDbInitializeAction;
    static /* synthetic */ Class class$jp$co$ntt$lms$installer$lms$ManagerInputAction;

    public final boolean isSkipped(InstallerValues installerValues) {
        ConfirmDbInitializeValue confirmDbInitializeValue = (ConfirmDbInitializeValue)installerValues.getActionValue((class$jp$co$ntt$lms$installer$lms$ConfirmDbInitializeAction == null ? (class$jp$co$ntt$lms$installer$lms$ConfirmDbInitializeAction = CreateDbAbstractAction.class$("jp.co.ntt.lms.installer.lms.ConfirmDbInitializeAction")) : class$jp$co$ntt$lms$installer$lms$ConfirmDbInitializeAction).getName());
        return !confirmDbInitializeValue.isConfirmInitialize() || !installerValues.getDbCategory().equals(this.getDbCategory());
    }

    public InstallerActionValue action(InstallerValues installerValues) throws InstallerException {
        LoggerUtil.methodHead(_logger, "action(InstallerValues)");
        boolean bl = false;
        try {
            InstallerUiUtil.outputMessageAsTitle(installerValues, "CreateDbAbstractAction.head");
            this.createUserAndDatabase(installerValues);
            Connection connection = this.getLmsUserConnection(installerValues);
            this.executeQueryType(installerValues, connection, "common.first");
            this.executeQueriesOptionLO(installerValues, connection);
            this.executeQueryType(installerValues, connection, "common.second");
            if (this._lmsConection != null && !this._lmsConection.getAutoCommit()) {
                this._lmsConection.commit();
            }
            if (this._dbaConection != null && !this._dbaConection.getAutoCommit()) {
                this._dbaConection.commit();
            }
            bl = true;
            InstallerUiUtil.outputMessage(installerValues, "CreateDbAbstractAction.tail", true);
        }
        catch (InstallerException installerException) {
            InstallerUiUtil.outputMessage(installerValues, "CreateDbAbstractAction.error", true);
            this.rollback();
            throw installerException;
        }
        catch (Exception exception) {
            InstallerUiUtil.outputMessage(installerValues, "CreateDbAbstractAction.error", true);
            this.rollback();
            throw new InstallerException(exception);
        }
        finally {
            this.closeConnection(bl);
        }
        LoggerUtil.methodTail(_logger, "action(InstallerValues)");
        return null;
    }

    protected abstract String getDbCategory();

    protected void createUserAndDatabase(InstallerValues installerValues) throws InstallerException {
        Connection connection = this.getDbaConnection(installerValues);
        this.executeQueryType(installerValues, connection, "create.database");
        this.executeQueryType(installerValues, connection, "create.user");
    }

    protected boolean isIgnoreQuery(String string) {
        return false;
    }

    protected final void executeQueryType(InstallerValues installerValues, Connection connection, String string) throws InstallerException {
        LoggerUtil.methodHead(_logger, "executeQueryType(InstallerValues," + connection + "," + string + ")");
        Statement statement = null;
        boolean bl = false;
        try {
            String[][] stringArray = installerValues.getQueryResources(string);
            if (stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Object[] objectArray = this.loadQuery(installerValues, stringArray[i][0], stringArray[i][1]);
                    _logger.info("[" + i + "]" + "[" + StringUtil.toString(objectArray) + "]");
                    for (int j = 0; j < objectArray.length; ++j) {
                        statement = connection.createStatement();
                        statement.execute((String)objectArray[j]);
                    }
                    InstallerDatabaseUtil.close(statement, true);
                }
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            bl = true;
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        finally {
            InstallerDatabaseUtil.close(statement, bl);
        }
        LoggerUtil.methodTail(_logger, "executeQueryType(InstallerValues," + connection + "," + string + ")");
    }

    protected void executeQueriesOptionLO(InstallerValues installerValues, Connection connection) throws InstallerException {
        LoggerUtil.methodHead(_logger, "executeQueriesOptionLO(InstallerValues)");
        String[] stringArray = installerValues.getOptionLOKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!installerValues.getOptionLOSelected(stringArray[i])) continue;
            this.executeQueryType(installerValues, connection, "optionLO." + stringArray[i]);
        }
        LoggerUtil.methodTail(_logger, "executeQueriesOptionLO(InstallerValues)");
    }

    protected String getDbNameForDba(InstallerValues installerValues) {
        ManagerInputValue managerInputValue = (ManagerInputValue)installerValues.getActionValue((class$jp$co$ntt$lms$installer$lms$ManagerInputAction == null ? (class$jp$co$ntt$lms$installer$lms$ManagerInputAction = CreateDbAbstractAction.class$("jp.co.ntt.lms.installer.lms.ManagerInputAction")) : class$jp$co$ntt$lms$installer$lms$ManagerInputAction).getName());
        return managerInputValue.getDbName();
    }

    protected Connection getDbaConnection(InstallerValues installerValues) throws InstallerException {
        LoggerUtil.methodHead(_logger, "getDbaConnection(InstallerValues)");
        try {
            if (this._dbaConection != null && !this._dbaConection.isClosed()) {
                if (!this._dbaConection.getAutoCommit()) {
                    this._dbaConection.commit();
                }
                this._dbaConection.close();
                this._dbaConection = null;
            }
            ManagerInputValue managerInputValue = (ManagerInputValue)installerValues.getActionValue((class$jp$co$ntt$lms$installer$lms$ManagerInputAction == null ? (class$jp$co$ntt$lms$installer$lms$ManagerInputAction = CreateDbAbstractAction.class$("jp.co.ntt.lms.installer.lms.ManagerInputAction")) : class$jp$co$ntt$lms$installer$lms$ManagerInputAction).getName());
            ConfirmDbInitializeValue confirmDbInitializeValue = (ConfirmDbInitializeValue)installerValues.getActionValue((class$jp$co$ntt$lms$installer$lms$ConfirmDbInitializeAction == null ? (class$jp$co$ntt$lms$installer$lms$ConfirmDbInitializeAction = CreateDbAbstractAction.class$("jp.co.ntt.lms.installer.lms.ConfirmDbInitializeAction")) : class$jp$co$ntt$lms$installer$lms$ConfirmDbInitializeAction).getName());
            String string = managerInputValue.getDbHost();
            String string2 = managerInputValue.getDbPort();
            String string3 = this.getDbNameForDba(installerValues);
            String string4 = confirmDbInitializeValue.getDbaUser();
            String string5 = confirmDbInitializeValue.getDbaPassword();
            this._dbaConection = InstallerDatabaseUtil.getConnection(installerValues, string, string2, string3, string4, string5, "connectionStringPatternDba", true);
        }
        catch (InstallerException installerException) {
            throw installerException;
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "getDbaConnection(InstallerValues)");
        return this._dbaConection;
    }

    protected Connection getLmsUserConnection(InstallerValues installerValues) throws InstallerException {
        LoggerUtil.methodHead(_logger, "getLmsUserConnection(InstallerValues)");
        try {
            if (this._lmsConection != null && !this._lmsConection.isClosed()) {
                if (!this._lmsConection.getAutoCommit()) {
                    this._lmsConection.commit();
                }
                this._lmsConection.close();
                this._lmsConection = null;
            }
            ManagerInputValue managerInputValue = (ManagerInputValue)installerValues.getActionValue((class$jp$co$ntt$lms$installer$lms$ManagerInputAction == null ? (class$jp$co$ntt$lms$installer$lms$ManagerInputAction = CreateDbAbstractAction.class$("jp.co.ntt.lms.installer.lms.ManagerInputAction")) : class$jp$co$ntt$lms$installer$lms$ManagerInputAction).getName());
            String string = managerInputValue.getDbHost();
            String string2 = managerInputValue.getDbPort();
            String string3 = managerInputValue.getDbName();
            String string4 = managerInputValue.getDbUser();
            String string5 = managerInputValue.getDbPassword();
            this._lmsConection = InstallerDatabaseUtil.getConnection(installerValues, string, string2, string3, string4, string5, "connectionStringPattern", true);
        }
        catch (InstallerException installerException) {
            throw installerException;
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "getLmsUserConnection(InstallerValues)");
        return this._lmsConection;
    }

    private void rollback() {
        if (this._dbaConection != null) {
            try {
                if (!this._dbaConection.getAutoCommit()) {
                    this._dbaConection.rollback();
                }
            }
            catch (Exception exception) {
                LoggerUtil.throwable(_logger, exception);
            }
        }
        if (this._lmsConection != null) {
            try {
                if (!this._lmsConection.getAutoCommit()) {
                    this._lmsConection.rollback();
                }
            }
            catch (Exception exception) {
                LoggerUtil.throwable(_logger, exception);
            }
        }
    }

    private void closeConnection(boolean bl) throws InstallerException {
        InstallerException installerException = null;
        if (this._dbaConection != null) {
            block7: {
                try {
                    this._dbaConection.close();
                }
                catch (Exception exception) {
                    LoggerUtil.throwable(_logger, exception);
                    if (!bl) break block7;
                    installerException = new InstallerException(exception);
                }
            }
            this._dbaConection = null;
        }
        if (this._lmsConection != null) {
            block8: {
                try {
                    this._lmsConection.close();
                }
                catch (Exception exception) {
                    LoggerUtil.throwable(_logger, exception);
                    if (!bl || installerException != null) break block8;
                    installerException = new InstallerException(exception);
                }
            }
            this._lmsConection = null;
        }
        if (installerException != null) {
            throw installerException;
        }
    }

    protected String[] loadQuery(InstallerValues installerValues, String string, String string2) throws InstallerException {
        LoggerUtil.methodHead(_logger, "getLmsUserConnection(InstallerValues," + string + "," + string2 + ")");
        BufferedReader bufferedReader = null;
        Object[] objectArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        String string3 = System.getProperty("line.separator");
        try {
            InputStream inputStream = installerValues.getResourcePathStream(string);
            if (inputStream != null) {
                String string4;
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string2));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (this.isIgnoreQuery(string4)) continue;
                    int n = (string4 = this.replace(installerValues, string4)).indexOf(59);
                    if (n >= 0) {
                        String string5 = null;
                        String string6 = null;
                        if (n == 0) {
                            string5 = "";
                            string6 = string4.substring(n + 1);
                        } else if (n + 1 == string4.length()) {
                            string5 = string4.substring(0, n);
                            string6 = "";
                            stringBuffer.append(string5);
                        } else {
                            string5 = string4.substring(0, n);
                            string6 = string4.substring(n + 1);
                            stringBuffer.append(string5);
                        }
                        String string7 = stringBuffer.toString().trim();
                        if (string7.length() > 0) {
                            arrayList.add(string7);
                        }
                        stringBuffer = new StringBuffer(string6);
                        stringBuffer.append(string3);
                        continue;
                    }
                    stringBuffer.append(string4);
                    stringBuffer.append(string3);
                }
                if (stringBuffer.length() > 0 && (string4 = stringBuffer.toString().trim()).length() > 0) {
                    arrayList.add(string4);
                }
            }
            objectArray = new String[arrayList.size()];
            arrayList.toArray(objectArray);
            bl = true;
        }
        catch (Exception exception) {
            try {
                LoggerUtil.throwable(_logger, exception);
                throw new InstallerException(exception);
            }
            catch (Throwable throwable) {
                InstallerFileUtil.close(bufferedReader, bl);
                throw throwable;
            }
        }
        InstallerFileUtil.close(bufferedReader, bl);
        LoggerUtil.methodTail(_logger, "getLmsUserConnection(InstallerValues," + string + "," + string2 + ")", StringUtil.toString(objectArray));
        return objectArray;
    }

    protected String replace(InstallerValues installerValues, String string) {
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

