using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace PhoenixClient
{
    public partial class PhoenixServiceClient : Form
    {
        // 1y[W̕\
        private const int ROWS_IN_PAGE = 20;
        // ݂̃y[Wԍ
        private int pagenum = 0;

        #region RXgN^
        /// <summary>
        /// RXgN^
        /// </summary>
        public PhoenixServiceClient()
        {
            InitializeComponent();
        }
        #endregion

        #region Cxgnh

        /// <summary>
        /// {^̃Cxgnh
        /// </summary>
        /// <param name="sender">CxgM</param>
        /// <param name="e">CxgIuWFNg</param>
        private void SearchButton_Click(object sender, EventArgs e)
        {
            pagenum = 0;
            doSearch();
        }
        /// <summary>
        /// Oy[W{^̃Cxgnh
        /// </summary>
        /// <param name="sender">CxgM</param>
        /// <param name="e">CxgIuWFNg</param>
        private void prevButton_Click(object sender, EventArgs e)
        {
            pagenum--;
            doSearch();
        }
        /// <summary>
        /// y[W{^̃Cxgnh
        /// </summary>
        /// <param name="sender">CxgM</param>
        /// <param name="e">CxgIuWFNg</param>
        private void nextButton_Click(object sender, EventArgs e)
        {
            pagenum++;
            doSearch();
        }

        #endregion

        #region WbN

        /// <summary>
        /// s
        /// </summary>
        private void doSearch()
        {
            // ̓`FbN
            string keywords = KeywordInputRegion.Text;
            if (keywords == null || keywords.Length == 0)
            {
                MessageBox.Show("L[[h͂Ă");
            }
            else
            {
                // T[rX̌Ăяo
                localhost.PhoenixServiceResponse response = InvokePhoenixWebServices(keywords);
                // ʂ̕\
                DisplayResponse(response);
            }
        }
        /// <summary>
        /// ʂ͂ꂽL[[hŌT[rXN
        /// </summary>
        /// <param name="keywords">L[[h</param>
        /// <returns>񓚌</returns>
        private localhost.PhoenixServiceResponse InvokePhoenixWebServices(string keywords)
        {
            string[] terms = keywords.Split(' ');

            localhost.PhoenixServiceRequest request = new localhost.PhoenixServiceRequest();
            // S\bh
            request.method = "ngramFtsSearchLogic";
            // 
            localhost.And condition = new localhost.And();
            condition.term = terms;
            request.and = new localhost.And[] { condition };
            // ͈
            request.startIndex = pagenum * ROWS_IN_PAGE;
            request.endIndex = request.startIndex + ROWS_IN_PAGE;

            // Ăяo
            localhost.PhoenixSearchService service = new localhost.PhoenixSearchService();
            localhost.PhoenixServiceResponse response = service.search(request);

            return response;
        }
        /// <summary>
        /// ʂ\
        /// ^Cg, T}[, URL̏ŕ\
        /// </summary>
        /// <param name="response">T[rX̉</param>
        private void DisplayResponse(localhost.PhoenixServiceResponse response)
        {
            if (response == null)
            {
                MessageBox.Show("Yf[^܂");
                return;
            }
            // Y̕\
            hitCountLabel.Text = "" + response.hits + " ";

            // ʂ̕\
            string text = "";
            foreach(localhost.Record record in response.record)
            {
                localhost.Site site = record.site;
                // y[W^Cg
                text += site.title + " [" + site.url + "]\r\n";
                text += site.summary + "\r\n";
                text += "-----------------------------------------\r\n";
            }

            // {^̕\ԕύX
            prevButton.Enabled = pagenum > 0;
            nextButton.Enabled = (response.hits / ROWS_IN_PAGE) > pagenum;

            responseTextArea.Text = text;

            // y[Wԍ̕\
            pageNumLabel.Text = "" + (1 + pagenum) + "/" + response.hits;
        }

        #endregion
    }
}