/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: MethodHandlerFactory.java,v 1.1 2005/05/11 17:48:20 rampil Exp $
 */
package org.logical_paradox.httpd.method;

import java.util.HashMap;
import java.util.Map;

import org.logical_paradox.httpd.HttpdProperties;

/**
 * httpvgR̃\bhnht@Ng
 * ^ꂽHTTP\bhɑΉnhNX𐶐܂D
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class MethodHandlerFactory {
	/** GET\bh */
	public static final String HTTP_GET = "GET";
	/** POST\bh */
	public static final String HTTP_POST = "POST";
	/** HEAD\bh */
	public static final String HTTP_HEAD = "HEAD";
	/** EXIT\bh */
	public static final String HTTP_EXIT = "EXIT";

	/** ftHgt@Ng(singleton) */
	private static MethodHandlerFactory defaultFactory = new MethodHandlerFactory();
	/** \bhnhNX̃}bv */
	private static final Map handlers;

	/*
	 * X^eBbNCjVCU
	 * \bhnh̃}bv
	 */
	static {
		HashMap m = new HashMap();
		// GET
		m.put(HTTP_GET, HttpdProperties.getProperty(HttpdProperties.MHDLR_GET));
		// POST
		m.put(HTTP_POST, HttpdProperties.getProperty(HttpdProperties.MHDLR_POST));
		// HEAD
		m.put(HTTP_HEAD, HttpdProperties.getProperty(HttpdProperties.MHDLR_HEAD));
		// EXIT
		m.put(HTTP_EXIT, HttpdProperties.getProperty(HttpdProperties.MHDLR_EXIT));

		handlers = m;
	}
	/**
	 * RXgN^
	 */
	protected MethodHandlerFactory() {
	}
	/**
	 * ftHgt@Ng̃CX^Xݒ肷
	 * @param newFactory ftHgt@Ng̃CX^X
	 */
	protected void setInstance(MethodHandlerFactory newFactory) {
		defaultFactory = newFactory;
	}
	/**
	 * ftHg̃\bhnht@Ng̃CX^XԂ
	 * @return ftHg̃\bhnht@Ng
	 */
	public static final MethodHandlerFactory getInstance() {
		return defaultFactory;
	}

	/**
	 * w肳ꂽHTTP\bhɑΉnhNX𐶐ĕԂ
	 * @param type ^Cv(HTTP\bh)
	 * @return ꂽnhNX(null=o^)
	 */
	public HttpMethodHandler getMethodHandler(String type) {
		Object handler = handlers.get(type);
		if(handler == null) {
			// w肳ꂽ\bhɑΉnhNXo^ĂȂꍇ
			return null;
		} else if(handler instanceof String) {
			// }bvɊi[Ă̂nhNXł͂Ȃ(=܂CX^XĂȂ)
			try {
				Class clazz = Class.forName((String)handler);
				HttpMethodHandler hdl = (HttpMethodHandler)clazz.newInstance();
				handlers.put(type, hdl);
				return hdl;
			} catch (Exception e) {
				e.printStackTrace();
				return null;
			}
		} else if(handler instanceof HttpMethodHandler) {
			// }bvɊi[Ă̂nhNX̂̂̏ꍇAꎩ̂Ԃ
			return (HttpMethodHandler)handler;
		} else {
			// ȊO̖ȃNX̃CX^Xi[Ă
			throw new IllegalStateException();
		}
	}
}
