/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: DefaultErrorPageGenerator.java,v 1.1 2005/05/11 17:48:20 rampil Exp $
 */
package org.logical_paradox.httpd.html;

/**
 * łVvȃG[y[WWFl[^
 * G[R[hƓeo͂
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class DefaultErrorPageGenerator extends ErrorPageGenerator {
	/** G[y[W(HTML)̃ev[g */
	public static final String ERROR_PAGE_TEMPLATE =
			"<HTML><HEAD><TITLE>%%ERROR_CODE%% %%ERROR_MSG%%</TITLE></HEAD>" +
			"<BODY><H2>%%ERROR_CODE%% %%ERROR_MSG%%</H2></BODY></HTML>";
	/**
	 * G[R[hɑΉG[y[W(HTML)𐶐ĕԂ
	 * @param errorCode G[R[h
	 * @return ꂽG[y[W
	 */
	public String generateErrorPage(int errorCode) {
		// G[R[h̒u
		String errorPage = ERROR_PAGE_TEMPLATE.replaceAll("%%ERROR_CODE%%", "" + errorCode);
		// G[bZ[W̒u
		errorPage = errorPage.replaceAll("%%ERROR_MSG%%", ErrorCodeDictionary.getMessage(errorCode));

		return errorPage;
	}
}
