/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Server.java,v 1.1 2005/05/11 17:48:20 rampil Exp $
 */
package org.logical_paradox.httpd;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.util.Cache;
import org.logical_paradox.httpd.html.ErrorPageGenerator;


/**
 * HTTPT[o[
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Server {
	/** HTTPT[o[̏ -  */
	public static final int E_INIT = 0;
	/** HTTPT[o[̏ - NCAgڑ҂ */
	public static final int E_WAITING = 1;
	/** HTTPT[o[̏ - I */
	public static final int E_CLOSING = 100;
	/** HTTPT[o[̏ - ~ */
	public static final int E_CLOSED = 255;

	/** ftHg̃NGXg󂯎҂(1) */
	public static final int DEFAULT_CONNECTION_WAIT_MSEC = 60000;
	/** T[o[\Pbgaccept҂Ԍp */
	public static final int SERVER_SOCKET_TIMEOUT_SEC = 5000;

	/** ݂̃T[o[Xe[^X */
	private int serverStatus = E_INIT;

	/** K[ */
	private static final Log log = LogFactory.getLog(Server.class);

	/** T[o[\Pbg */
	private ServerSocket serverSocket;

	/** T[o[RtBO[V */
	private final Config config;
	/** NGXgXbh */
	private RequestProcessor[] processor;
	/** NGXgvZbT̋󂫑҂(msec) */
	private int waittime = DEFAULT_CONNECTION_WAIT_MSEC;
	/** T[o[\Pbgacceptf^C~O */
	private int serverSocketTimeoutSec = SERVER_SOCKET_TIMEOUT_SEC;

	/** ҋ@̃XbhXg */
	private Cache waitingThreads = new Cache();

	/**
	 * RXgN^
	 * @param c T[o[RtBO[V
	 */
	public Server(Config c) {
		config = c;
	}
	/**
	 * httpT[o[Jn
	 */
	public void start() {
		// NGXgXbh𐶐(ݒ肳Ăő吔mۂ)
		processor = new RequestProcessor[config.getThreads()];
		// ftHg̃v[OŏɃXbh쐬Ă
		for(int i = 0; i < config.getThreads(); i++) {
			processor[i] = new RequestProcessor(i+1, this, config);
			waitingThreads.add(processor[i]);
			processor[i].start();
		}

		// ڑ҂Ԃɓ
		waiting();

		// ڑ҂Ԃꂽ̂ŁCIԂɓ
		try {
			shutdown();
		} catch (InterruptedException e) {
			log.warn("NGXgvZbTXbh̒~҂f܂B~܂B");
		}
	}
	/**
	 * T[o[Xe[^XԂ
	 * @return T[o[Xe[^X
	 */
	public int getServerStatus() {
		return serverStatus;
	}
	/**
	 * T[o[Xe[^Xݒ肷
	 * @param status T[o[Xe[^X
	 */
	public void setServerStatus(int status) {
		serverStatus = status;
	}
	/**
	 * ҋ@XbhXgԂ
	 * @return ҋ@XbhXg
	 */
	Cache getWaitingThreads() {
		return waitingThreads;
	}
	/**
	 * ڑ҂Ԃɓ
	 */
	protected void waiting() {
		try {
			// T[o[\Pbg̍쐬
			serverSocket = new ServerSocket(config.getPort());
			serverSocket.setSoTimeout(serverSocketTimeoutSec);

			// T[o[Xe[^X"ڑ҂"ɑJڂ
			setServerStatus(E_WAITING);

			// liteningJn
			log.info("|[gԍ[" + config.getPort() + "]listenĂ܂");

			// T[o[Xe[^XWAITING̊ԑ҂
			while(serverStatus == E_WAITING) {
				Socket clientSocket = null;
				try {
					clientSocket = serverSocket.accept();
				} catch(SocketTimeoutException soe) {
					// ԊuŃT[o[̃Xe[^XύXo邽߂̏uȂ̂
					// T[o[\Pbg^CAEgƂĂȂ([vŏp)
					continue;
				}
				// NGXgvZbTXbhɏp
				try {
					RequestProcessor processor = getRequestProcessor();
					processor.execute(clientSocket);
				} catch (InterruptedException e1) {
					log.warn("" + waittime + "msec҂܂ANGXgvZbT̎擾ł܂ł");
					// T[o[busỹbZ[WM
					ServerResponse serverResponse = new ServerResponse(new ResponseHeader(), ErrorPageGenerator.getInstance().generateErrorPage(503));
					try {
						RequestProcessor.send(clientSocket, serverResponse);
					} catch(IOException e) {
						// G[y[WMɃG[
						log.warn("G[y[WMɓo̓G[܂");
					}
				}
			}
		} catch (IOException e) {
			// bindɎsȂǂ̗O
			e.printStackTrace();
			log.error("|[gԍ[" + config.getPort() + "listeningԂɓ邱Ƃł܂ł");
			return;
		}
	}
	/**
	 * httpT[o[~
	 */
	public void shutdown() throws InterruptedException {
		setServerStatus(E_CLOSING);

		log.info("httpT[o[̃Vbg_EJn܂");
		log.info("SĂ̑҂󂯃Xbh~Ă܂");
		for(int i = 0; i < processor.length; i++) {
			processor[i].tearDown();
		}
		// NGXgvZbTXbh̒~҂
		for(int i = 0; i < processor.length; i++) {
			processor[i].join();
		}
		log.info("SĂ̑҂󂯃Xbh~܂");

		// SẴXbhɒ~ꍇAXe[^XύX
		setServerStatus(E_CLOSED);
	}
	/**
	 * ݉ɂɂĂ郊NGXgvZbTԂ
	 * ΂炭҂Ă݂āAȂ悤ȂT[o[busyƂ
	 * @return 擾ꂽNGXgvZbT
	 * @throws InterruptedException ҂^CAEg
	 */
	protected RequestProcessor getRequestProcessor() throws InterruptedException {
		synchronized(waitingThreads) {
			while(waitingThreads.size() == 0) {
				waitingThreads.wait(waittime);
			}
			// 1Xbho
			return (RequestProcessor)waitingThreads.getOne();
		}
	}
	/**
	 * C\bh
	 * webserverN܂
	 * @param args vO
	 * @throws Exception ȂO
	 */
	public static final void main(String[] args) throws Exception {
		log.info("httpT[o[NĂ܂");
		// httpT[o[̋N
		Server server = new Server(new Config(args));
		server.start();

		log.info("httpT[o[~܂");
	}
}
