/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Config.java,v 1.1 2005/05/11 17:48:20 rampil Exp $
 */
package org.logical_paradox.httpd;

import org.logical_paradox.common.cli.Argument;
import org.logical_paradox.common.cli.ArgumentParser;
import org.logical_paradox.httpd.exception.*;

/**
 * httpT[o[Ɋւݒ
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class Config {
	/** ftHg|[gԍ */
	public static final int DEFAULT_LISTENING_PORT = 1111;
	/** ftHg̃NGXgvZbT[Xbhv[O */
	public static final int DEFAULT_POOLING_THREADS = 25;
	/** ftHg̃zXg */
	public static final String DEFAULT_HOSTNAME = "localhost";

	/** listen|[gԍ */
	private int port = DEFAULT_LISTENING_PORT;
	/** v[OĂXbh */
	private int threads = DEFAULT_POOLING_THREADS;
	/** T[o[̃zXg */
	private String hostname = DEFAULT_HOSTNAME;

	/**
	 * RXgN^
	 * ͂ăRtBO[Vl쐬
	 * @param args vO
	 */
	public Config(String[] args) throws IllegalConfigException {
		parser(args);
	}

	/**
	 * p[U[
	 * @param args ̔z
	 */
	protected void parser(String[] args) throws IllegalConfigException {
		IllegalConfigException ice = new IllegalConfigException();

		// R}hC̉
		Argument[] arguments = ArgumentParser.parse(args);

		for(int i = 0; i < arguments.length; i++) {
			Argument arg = arguments[i];
			if(arg.isOption() == true) {
				if("port".equals(arg.getName())) {
					// listen|[gԍ
					setPort(Integer.parseInt(arg.getValue()));
				} else if("threads".equals(arg.getName())) {
					// Xbhv[O
					setThreads(Integer.parseInt(arg.getValue()));
				} else if("host".equals(arg.getName())) {
					// zXg
					setHostName(arg.getValue());
				} else {
					// mȂIvV̏ꍇ
					ice.add("IvV[" + arg.getName() + "," + arg.getValue() + "]͖ł");
				}
			}
		}

		// G[bZ[Wς܂Ăꍇ͗OX[
		if(ice.hasError()) {
			throw ice;
		}
	}
	/**
	 * |[gԍԂ
	 * @return |[gԍ
	 */
	public int getPort() {
		return port;
	}
	/**
	 * |[gԍݒ肷
	 * @param p |[gԍ
	 */
	public void setPort(int p) {
		port = p;
	}

	/**
	 * v[OĂXbhԂ
	 * @return Xbhv[O
	 */
	public int getThreads() {
		return threads;
	}
	/**
	 * v[OĂXbhݒ肷
	 * @param th Xbhv[O
	 */
	public void setThreads(int th) {
		threads = th;
	}
	/**
	 * zXgԂ
	 * @return zXg
	 */
	public String getHostName() {
		return hostname;
	}
	/**
	 * zXgݒ肷
	 * @param hn zXg
	 */
	public void setHostName(String hn) {
		hostname = hn;
	}
}
