/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.swing;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JWindow;
import org.logical_paradox.common.swing.WindowPanel;

public class Window {
    private final String title;
    private final WindowPanel wndpnl;
    private final int width;
    private final int height;
    private JFrame mainFrm;
    private boolean show = false;

    public Window(String name, WindowPanel panel, int w, int h) {
        this.title = name;
        this.wndpnl = panel;
        this.width = w;
        this.height = h;
        this.init();
    }

    protected void init() {
        this.mainFrm = new JFrame();
        this.wndpnl.init();
        this.mainFrm.getContentPane().add(this.wndpnl);
        this.mainFrm.setTitle(this.title);
        new JWindow(this.mainFrm);
        this.mainFrm.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Window.this.mainFrm.dispose();
            }
        });
        Dimension windowLocation = Toolkit.getDefaultToolkit().getScreenSize();
        this.mainFrm.setLocation(((int)windowLocation.getWidth() - this.width) / 2, ((int)windowLocation.getHeight() - this.height) / 2);
        this.mainFrm.setSize(new Dimension(this.width, this.height));
    }

    public void setVisible(boolean b) {
        this.mainFrm.setVisible(b);
        this.show = b;
    }

    public boolean getVisible() {
        return this.show;
    }
}

