/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.message;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.logical_paradox.common.message.MessageResource;
import org.logical_paradox.common.util.StringUtils;

public class MessageBuilder {
    public static final String DEFAULT_MESSAGE_RESOURCE = "message";
    private ResourceBundle rb = null;

    public MessageBuilder() {
        this(DEFAULT_MESSAGE_RESOURCE);
    }

    public MessageBuilder(String basename) {
        this.rb = ResourceBundle.getBundle(basename);
    }

    public String getMessage(MessageResource resource) {
        String mf = this.rb.getString(resource.getMsgCode());
        if (StringUtils.isEmpty(mf)) {
            return "";
        }
        return MessageFormat.format(mf, resource.getParameters());
    }

    public String getMessage(String code) {
        return this.getMessage(new MessageResource(code));
    }

    public String getMessage(String code, Object o1) {
        return this.getMessage(new MessageResource(code, o1));
    }

    public String getMessage(String code, Object o1, Object o2) {
        return this.getMessage(new MessageResource(code, o1, o2));
    }

    public String getMessage(String code, Object o1, Object o2, Object o3) {
        return this.getMessage(new MessageResource(code, o1, o2, o3));
    }

    public String getMessage(String code, Object[] objects) {
        return this.getMessage(new MessageResource(code, objects));
    }
}

