/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: ErrorCodeDictionary.java,v 1.1 2005/05/11 17:48:20 rampil Exp $
 */
package org.logical_paradox.httpd.html;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * G[R[hƃG[bZ[W̑Ή\
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class ErrorCodeDictionary {
	/** G[R[h̎ */
	private static final Map dictionary;

	/*
	 * X^eBbNCjVCU[
	 */
	static {
		HashMap map = new HashMap();
		map.put("100","Continue");
		map.put("101","Switching Protocols");
		map.put("200","OK");
		map.put("201","Created");
		map.put("202","Accepted");
		map.put("203","Non-Authoritative Information");
		map.put("204","No Content");
		map.put("205","Reset Content");
		map.put("206","Partial Content");
		map.put("300","Multiple Choices");
		map.put("301","Moved Permanently");
		map.put("302","Moved Temporarily");
		map.put("303","See Other");
		map.put("304","Not Modified");
		map.put("305","Use Proxy");
		map.put("400","Bad Request");
		map.put("401","Unauthorized");
		map.put("402","Payment Required");
		map.put("403","Forbidden");
		map.put("404","Not Found");
		map.put("405","Method Not Allowed");
		map.put("406","Not Acceptable");
		map.put("407","Proxy Authentication Required");
		map.put("408","Request Time-out");
		map.put("409","Conflict");
		map.put("410","Gone");
		map.put("411","Length Required");
		map.put("412","Precondition Failed");
		map.put("413","Request Entity Too Large");
		map.put("414","Request-URI Too Large");
		map.put("415","Unsupported Media Type");
		map.put("500","Internal Server Error");
		map.put("501","Not Implemented");
		map.put("502","Bad Gateway");
		map.put("503","Server Temporary Unavailable");
		map.put("504","Gateway Time-out");
		map.put("505","HTTP Version not supported");

		dictionary = Collections.unmodifiableMap(map);
	}
	/**
	 * G[R[hɑΉ\Ԃ
	 * @param errorCode G[R[h
	 * @return G[bZ[W(\)
	 */
	public static final String getMessage(int errorCode) {
		return (String)dictionary.get("" + errorCode);
	}
}
