/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: RequestProcessor.java,v 1.1 2005/05/11 17:48:20 rampil Exp $
 */
package org.logical_paradox.httpd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.util.Cache;
import org.logical_paradox.httpd.exception.*;
import org.logical_paradox.httpd.html.ErrorPageGenerator;
import org.logical_paradox.httpd.method.HttpMethodHandler;
import org.logical_paradox.httpd.method.MethodHandlerFactory;

/**
 * NGXgXbh
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class RequestProcessor extends Thread {
	/** K[ */
	private Log log = LogFactory.getLog(RequestProcessor.class);

	/** ݏĂ\Pbg */
	private Socket socket;
	/** Xbhԍ */
	private int threadNo;
	/** T[o[̃CX^X */
	private Server parent;
	/** ҋ@XbhL[ */
	private Cache queue;
	/** T[o[̋NIvV */
	private final Config config;

	private final String lock = "lock";

	/** Vbg_EɃNCAgƂ̐ڑ҂b(msec) */
	public static final int SHUTDOWN_TIMEOUT_SEC = 60000;
	/**
	 * RXgN^
	 * @param no Xbhԍ
	 * @param server T[o[CX^X
	 */
	public RequestProcessor(int no, Server server, Config c) {
		threadNo = no;
		parent = server;
		queue = server.getWaitingThreads();
		config = c;
	}
	/**
	 * \Pbgݒ肷
	 * \Pbg̐ݒ肪gK[ƂȂāAXbhsleepEočĊJ
	 * @param s \Pbg
	 */
	public void execute(Socket s) {
		log.trace("NGXgt܂:" + s.toString());
		socket = s;
		// lockIuWFNgő҂ĂXbhN
		synchronized(lock) {
			lock.notifyAll();
		}
	}
	/**
	 * XbhԍԂ
	 * @return Xbhԍ
	 */
	public int getThreadNo() {
		return threadNo;
	}
	/**
	 * ҋ@ǂԂ
	 * @return true:ҋ@ / false:
	 */
	public boolean isWaiting() {
		return socket == null;
	}
	/**
	 * XbhC
	 */
	public void run() {
		try {
			while(true) {
				synchronized(lock) {
					while(socket == null) {
						lock.wait();
					}
					ClientRequest clientRequest = null;
					ServerResponse serverResponse = null;

					try {
						// \Pbg烊NGXg̓e󂯎
						BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
						StringBuffer request = new StringBuffer();
						String line = null;

						while((line = br.readLine()) != null && line.trim().length() > 0) {
							request.append(line + "\n");
						}

						// NGXgIuWFNg̍쐬
						clientRequest = new ClientRequest(request.toString(), config);

						// NGXgp[^`̏ꍇCNGXg
						if(clientRequest != null) {
							// NGXgׂ\bh̃nh擾
							HttpMethodHandler handler = MethodHandlerFactory.getInstance().getMethodHandler(clientRequest.getMethod());
							if(handler == null) {
								// \bhnho^ĂȂ̂ŁC̃NGXg̓G[Ƃ
							} else {
								serverResponse = handler.execute(clientRequest);
							}
						}
					} catch (HttpException e) {
						// hLg擾ɔO(Not FoundForbiddenȂ)
						log.warn("hLg̎擾Ɏs܂: HTTPXe[^XR[h[" + e.getHttpStatusCode() + "]");
						serverResponse = new ServerResponse(new ResponseHeader(), ErrorPageGenerator.getInstance().generateErrorPage(e.getHttpStatusCode()));
					} catch (TerminationException e) {
						// IVOiM̂ŃT[o[̒~Jn
						parent.setServerStatus(Server.E_CLOSING);
						log.info("T[o[̒~MM܂");
						serverResponse = new ServerResponse(new ResponseHeader(), ErrorPageGenerator.getInstance().generateErrorPage(202));
					} catch (IOException e) {
						// \PbgI/OɒʐMG[
						// 悭邱ƂȂ̂ŕʂɋCɂȂ
						log.warn("NCAgƂ̊ԂŒʐMG[܂");
						serverResponse = null;
					} finally {
						// NCAgƂ̐ڑN[Y
						try {
							if(socket != null && socket.isConnected() == true) {
								if(serverResponse != null) {
									// NCAg\PbgƂ܂qĂꍇ̓T[o[̃X|X𑗐M
									send(socket, serverResponse);
								}
								socket.close();
							}
						} catch (IOException e1) {
							log.warn("NCAgSẴf[^MĂȂ\܂");
						} finally {
							socket = null;
							queue.add(this);
						}
					}
				}
			}
		} catch(InterruptedException e) {
			tearDown();
		}
	}
	/**
	 * NCAg\Pbgɑ΂ăT[o[̃X|X𑗐M
	 * @param client NCAg\Pbg
	 * @param response Me
	 * @throws IOException o͗O
	 */
	public static void send(Socket client, ServerResponse response) throws IOException {
		BufferedWriter out = new BufferedWriter(new OutputStreamWriter(client.getOutputStream()));

		// HTTPXe[^X
		out.write(response.getHttpStatusCode() + "\r\n");

		// wb_̑M
		for(Iterator it = response.headers(); it.hasNext();) {
			out.write(it.next().toString() + "\r\n");
		}
		out.write("\r\n");

		// f[^̑M
		out.write(response.getData());

		out.flush();
		out.close();
	}
	/**
	 * Xbh̏I
	 */
	protected void tearDown() {
		log.info("Xbh[" + getThreadNo() + "]̒~");
		int waitcnt = SHUTDOWN_TIMEOUT_SEC / 500;
		try {
			while(socket != null && waitcnt > 0) {
				waitcnt--;
				Thread.sleep(500);
			}
		} catch (InterruptedException e) {
			log.warn("NGXgvZbT̒~҂Ɋ荞݂܂");
		}
		interrupt();
		log.info("Xbh[" +  getThreadNo() + "]̒~");
	}
}
