/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.net.async;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.Vector;
import org.logical_paradox.common.net.async.AsyncEvent;
import org.logical_paradox.common.net.async.AsyncEventListener;
import org.logical_paradox.common.net.async.CAsyncClientSocket;
import org.logical_paradox.common.net.async.CAsyncClientSocketFactory;
import org.logical_paradox.common.net.async.CAsyncServerSocketFactory;
import org.logical_paradox.common.net.async.CAsyncSocket;
import org.logical_paradox.common.util.StringUtils;

public class Multiplexer {
    public static final String KEY_SERVER_SOCKET_FACTORY = "serversocketfactory";
    public static final String KEY_CLIENT_SOCKET_FACTORY = "clientsocketfactory";
    public static final String KEY_PORT_NUMBER = "portnumber";
    public static final String KEY_REMOTE_HOST = "remotehost";
    public static final int MPX_MODE_CLIENT = 1;
    public static final int MPX_MODE_SERVER = 100;
    private final String remoteHost;
    private final int port;
    private Vector clientChannels = new Vector();
    private final Selector selector;
    private final int mpxMode;
    private final CAsyncServerSocketFactory serverSocketFactory;
    private final CAsyncClientSocketFactory clientSocketFactory;

    public Multiplexer(int mode, Map m) throws IOException {
        this.mpxMode = mode;
        this.remoteHost = this.mpxMode == 100 ? "localhost" : (String)m.get(KEY_REMOTE_HOST);
        this.port = Integer.parseInt((String)m.get(KEY_PORT_NUMBER));
        this.clientSocketFactory = (CAsyncClientSocketFactory)m.get(KEY_CLIENT_SOCKET_FACTORY);
        this.serverSocketFactory = (CAsyncServerSocketFactory)m.get(KEY_SERVER_SOCKET_FACTORY);
        this.selector = SelectorProvider.provider().openSelector();
    }

    public void addChannel(CAsyncSocket client, int ops) throws TooManyListenersException, IOException {
        client.addEventListener(client);
        client.configureBlocking(false);
        client.register(this.selector, ops);
        this.clientChannels.addElement(client);
    }

    public void addChannel(int ops) throws TooManyListenersException, IOException {
        CAsyncSocket client = null;
        switch (this.mpxMode) {
            case 1: {
                client = this.clientSocketFactory.createClientSocket(this.remoteHost, this.port);
                break;
            }
            case 100: {
                client = this.serverSocketFactory.createServerSocket(this.port);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u30de\u30eb\u30c1\u30d7\u30ec\u30af\u30b5: \u30bd\u30b1\u30c3\u30c8\u306e\u4f5c\u6210\u306b\u5931\u6557");
            }
        }
        this.addChannel(client, ops);
    }

    protected Vector getChannels() {
        return this.clientChannels;
    }

    public void doWork() throws Exception {
        int TIMEOUT_SEC = 60000;
        int nofk = this.selector.select();
        if (nofk <= 0) {
            return;
        }
        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            it.remove();
            AsyncEventListener callback = (AsyncEventListener)key.attachment();
            if (callback == null) continue;
            if (key.isConnectable()) {
                SocketChannel sockch;
                if (!(key.channel() instanceof SocketChannel) || !(sockch = (SocketChannel)key.channel()).isConnectionPending()) continue;
                sockch.finishConnect();
                callback.onConnect(new AsyncEvent(this, key.channel()));
                continue;
            }
            if (key.isReadable()) {
                callback.onReceive(new AsyncEvent(this, key.channel()));
                continue;
            }
            if (key.isWritable()) {
                callback.onSend(new AsyncEvent(this, key.channel()));
                continue;
            }
            if (!key.isAcceptable()) continue;
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            SocketChannel client = server.accept();
            this.addChannel(this.clientSocketFactory.createClientSocket(client), 13);
            callback.onAccept(new AsyncEvent(this, client));
        }
    }

    public void sendAll() throws Exception {
        int i = 0;
        while (i < this.clientChannels.size()) {
            CAsyncSocket casock = (CAsyncSocket)this.clientChannels.elementAt(i);
            if (casock instanceof CAsyncClientSocket) {
                casock.sendMessage(StringUtils.randomText(16, true).getBytes());
            }
            ++i;
        }
    }
}

