/*
 * KeyTest
 * KeyNXUT
 */
package org.logical_paradox.fts;

import java.util.*;

import junit.framework.TestCase;

public class KeyTest extends TestCase {
	public KeyTest( String name ) {
		super( name );
	}

	// xN^[NXł̌eXg(n)
	public void testFindInVectorSuccess() {
		Vector v = new Vector();
		v.addElement( new KeyAdapter( "L[1" ) );
		Key k = new KeyAdapter( "L[1" );

		Enumeration e = v.elements();
		while( e.hasMoreElements() ) {
			if( k.equals( e.nextElement() ) ) {
				return;
			}
		}

		fail( "L[܂ł" );
	}

	// nbVR[h̃eXg(n)
	public void testHashCodeSuccess() {
		Key key1 = new KeyAdapter( "L[1" );
		Key key2 = new KeyAdapter( "L[1" );
		assertTrue( "nbVR[hvȂ", key1.hashCode() == key2.hashCode() );
	}
	// nbVR[h̃eXg(Qn)
	public void testHashCodeFail() {
		Key key1 = new KeyAdapter( "L[1" );
		Key key2 = new KeyAdapter( "2" );
		assertTrue( "nbVR[hvȂ͂", key1.hashCode() != key2.hashCode() );
	}

	// IuWFNg擾̃eXg
	public void testGetObjectSuccess() {
		String o = new String( "eXg" );
		Key key = new KeyAdapter( "NAME" );
		key.setObject(o);
		assertTrue( "RXgN^Őݒ肵YtIuWFNg̔reXg", key.getObject() == o );
	}
	// L[̐ݒ/擾eXg(n)
	public void testGetKeySuccess() {
		String o = new String( "" );
		Key key = new KeyAdapter( o );
		assertTrue( "RXgN^Őݒ肵L[̎擾eXg", key.getKey().equals( o ) );
	}
	// L[̐ݒeXg(Qn)
	public void testConstructorFailed() {
		try {
			Key key = new KeyAdapter( null );
			fail( "L[ݒ̏Qʂ삵܂ł" );
		} catch( IllegalArgumentException iae ) {}
	}
	// reXg(n)
	public void testEqualsSuccess() {
		Key key = new KeyAdapter( "L[1" );
		assertTrue( "L[̔reXg", key.equals( new KeyAdapter( "L[1" ) ) );
	}
	// reXg(Qn)
	public void testEqualsFail() {
		Key key = new KeyAdapter( "L[1" );
		assertFalse( "L[̔reXg", key.equals( new KeyAdapter( "L[2" ) ) );
	}

	class KeyAdapter extends Key {
		public KeyAdapter( String k ) throws IllegalArgumentException {
			super( k );
		}
	}
}

// end of KeyTest.java
