/*
 * FullTextSearch
 * SAvP[V
 */
package org.logical_paradox.fts.summary;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

import org.logical_paradox.fts.InvertedIndexKey;
import org.logical_paradox.fts.KeywordLocation;
import org.logical_paradox.fts.KeywordLocationComparator;
import org.logical_paradox.fts.ParsedKeyLocation;
import org.logical_paradox.fts.SearchResult;

/**
 * T}[쐬ĕԂ
 */
public class SimpleSummaryGenerator extends SummaryGenerator {
	/*
	 * RXgN^
	 */
	public SimpleSummaryGenerator() throws Exception {
		super();
	}

	// ʒu񂩂T}[쐬āCʂƂĕԂ
	// locations[] - ʒu
	// founddic - ꂪʂđ݂Ă镶ԍ
	public SearchResult[] getSummary(ParsedKeyLocation[] locations, long founddic) {
		// ܂C^ꂽ̍\Ɉɂ̂ŁCύX
		// locationsPerSummary[no.] = { ʒu1, ʒu2, .. ʒun }
		// Ƃ\ɂDʒúC̎ނɊ֌WȂCoʒuԂɊi[X^CƂD
		InvertedIndexKey ik = new InvertedIndexKey( "", founddic );
		Map locationsPerSummary = new HashMap();
		for( int i = 0; i < locations.length; i++ ) {
			KeywordLocation[] kl = (KeywordLocation[])locations[i].getLocations();
			for( int j = 0; j < kl.length; j++ ) {
//System.err.println( "docno=" + kl[j]._dicno + ", pos=" + kl[j]._pos );
				if( ik.isTermFoundInDocument( kl[j]._dicno ) == false ) {
					continue;
				}
//System.err.println( "docno=" + kl[j]._dicno + ", pos=" + kl[j]._pos );
				Vector v = (Vector)locationsPerSummary.get(new Integer( kl[j]._dicno ));
				if( v == null ) {
					v = new Vector();
				}
				v.addElement( kl[j] );
				locationsPerSummary.put( new Integer( kl[j]._dicno ), v );
			}
		}

		Iterator it = locationsPerSummary.keySet().iterator();
		SearchResult[] rcs = new SearchResult[ locationsPerSummary.size() ];
		int rcsc = 0;
		Integer intg = null;
		Vector vref = null;
		String rcstr = null;
		KeywordLocation[] lo = null;

		while( it.hasNext() ) {
			intg = (Integer)it.next();
			if( intg != null && (vref = (Vector)locationsPerSummary.get( intg )) != null ) {
				Collections.sort( vref, KeywordLocationComparator.getComparator() );
				lo = (KeywordLocation[])vref.toArray( new KeywordLocation[0] );
				rcstr = getSummaryByLocations( lo );
				rcs[rcsc++] = new SearchResult( lo, rcstr.toString() );
			}
		}

		return rcs;
	}

	// ʒu񂩂T}[؂oĕԂ
	protected String getSummaryByLocations( KeywordLocation[] lo ) {
		int highScore = 0;
		int lastCnt = 0;
		int lengthOfSummary = 100;
		int basep = 0;
		int score = 1;							// ȂƂ1͔͈͓Ɋ܂܂Ă͂

		for( int i = 0; i < lo.length; i++ ) {
			basep = lo[i]._pos;					// _̎擾
			score = score <= 1 ? 1 : (score-1);
			for( int j = score; j < lo.length; j++ ) {
				if( basep + lengthOfSummary > lo[j]._pos ) {
					score++;
				}
			}
			if( highScore < score ) {
				// nCXRAXV
				highScore = score;
				lastCnt = i;
			}
		}

		try {
			// ̃C^[tF[XgāChLgɃANZX
			String document = documentManager.getDocument(lo[0]._dicno+1);
			int lastp = 0;
			if( document.length() <= lengthOfSummary + lo[lastCnt]._pos ) {
				lastp = document.length()-1;
			} else {
				lastp = lo[lastCnt]._pos + lengthOfSummary -1;
			}

			String summary = document.substring( lo[lastCnt]._pos, lastp );
			return summary;
		} catch(Exception e) {
			e.printStackTrace();
			return "";
		}
	}
}
