/*
 * FullTextSearch
 * SAvP[V
 */
package org.logical_paradox.fts;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

/**
 * ̏oʒu𕶏ԍƂɊǗĂz<p>
 * 
 * locations[dicno][n] = KeywordLocation ̌`ŊǗĂD<br>
 * dicno = ԍCn = A<br>
 * ]āCԍ3̈ʒuSĂ擾ꍇCget(dicno)\bhŎ擾łD<br>
 * 
 * @author satoshi akabane@logical-paradox.org
 */
public class ParsedKeyLocation {
	private final Hashtable locations;
	public long docno;

	/**
	 * RXgN^
	 *
	 */
	public ParsedKeyLocation() {
		docno = 0;
		locations = new Hashtable();
	}
	/**
	 * z񂪋󂩂ǂԂ
	 * 
	 * @return true: / false:łȂ
	 */
	public boolean isEmpty() {
		return locations.isEmpty();
	}
	/**
	 * ̔zɐVǉ
	 * @param lo ǉ
	 */
	public void add( KeywordLocation lo ) {
		Integer dn = new Integer( lo._dicno );
		Vector locationsInDocument = (Vector)locations.get(dn);
		if( locationsInDocument == null ) {
			locationsInDocument = new Vector();
		}
		locationsInDocument.addElement( lo );
		locations.put( dn, locationsInDocument );
	}
	/**
	 * ̔zɐV̔zǉ
	 * @param lo ǉ̔z
	 */
	public void add( KeywordLocation[] lo ) {
		for( int i = 0; i < lo.length; i++ ) {
			add( lo[i] );
		}
	}
	/**
	 * ǗĂSĂ̍Ԃ
	 * @return ̔z
	 */
	public KeywordLocation[] getLocations() {
		Iterator it = locations.keySet().iterator();
		Vector v = new Vector();
		Vector lo = null;

		while( it.hasNext() ) {
			Integer dn = (Integer)it.next();
			if( dn == null ) {
				continue;
			}
			if( dn != null && (lo = (Vector)locations.get(dn)) != null ) {
				v.addAll( lo );
			}
		}

		return (KeywordLocation[])v.toArray( new KeywordLocation[0] );
	}
	/**
	 * w肳ꂽԍ̍SĕԂ
	 * @param dn ԍ
	 * @return 擾ꂽ(݂Ȃꍇ[0]̔z񂪕Ԃ)
	 */
	public KeywordLocation[] get( int dn ) {
		Vector locationsInDocument = (Vector)locations.get( new Integer( dn ) );
		if( locationsInDocument == null ) {
			return new KeywordLocation[0];
		} else {
			return (KeywordLocation[])locationsInDocument.toArray( new KeywordLocation[0] );
		}
	}
}
