/*
 * KeywordLocation
 * ꂪoʒuL^\
 * ԍƏoʒui[ł
 */
package org.logical_paradox.fts;

import java.io.Serializable;
import java.nio.ByteBuffer;

import org.logical_paradox.common.io.ByteStream;
import org.logical_paradox.common.lang.VariableFormatNumber;

public class KeywordLocation implements ByteStream, Serializable {
	public int _dicno;
	public int _pos;
	public String _str;

	public KeywordLocation( int dicno, int pos ) {
		_dicno = dicno;
		_pos = pos;

		_str = new String( "[" + dicno + "]" + pos );
	}
	/**
	 * RXgN^
	 * w肳ꂽoCg񂩂ʒu𕜌
	 * @param bstream oCg
	 */
	public KeywordLocation(byte[] bstream) {
		createObjectFromByteStream(bstream);
	}
	protected int findNextNumber(byte[] bstream, int offset) {
		while(offset < bstream.length) {
			if((bstream[offset] & 0x80) == 0) {
				return offset+1;
			}
			offset++;
		}
		return -1;
	}
	public String toString() {
		return _str;
	}
	/**
	 * ̍ʒuoCgɕϊ
	 * @return ϊꂽoCg
	 */
	public byte[] byteStream() {
		byte[] byteOfDicno = new VariableFormatNumber(_dicno).byteStream();
		byte[] byteOfPos = new VariableFormatNumber(_pos).byteStream();
		byte[] byteOfStr = _str.getBytes();

		// oCgi[邽߂̃obt@mۂ
		ByteBuffer buffer = ByteBuffer.allocate(byteOfDicno.length + byteOfPos.length + byteOfStr.length);
		buffer.rewind();

		buffer.put(byteOfDicno);			// ԍ̊i[
		buffer.put(byteOfPos);				// ʒůi[
		buffer.put(byteOfStr);				// {̂̊i[

		// oCgԂ
		return buffer.array();
	}
	/**
	 * oCg񂩂L[ʒu𕜌
	 * @param bstream oCg
	 * @throws IllegalArgumentException oCg񂩂̕Ɏs
	 */
	protected void createObjectFromByteStream(byte[] bstream) throws IllegalArgumentException {
		int offset = 0;
		_dicno = new VariableFormatNumber(bstream, offset).intValue();

		offset = findNextNumber(bstream, offset);
		_pos = new VariableFormatNumber(bstream, offset).intValue();

		offset = findNextNumber(bstream, offset);
		_str = new String(bstream,offset, bstream.length-offset);
	}
	/**
	 * R[hlr
	 * @param o rΏ
	 * @return true:  / false:Ⴄ
	 */
	public boolean equals(Object o) {
		KeywordLocation l = (KeywordLocation)o;
		return
				_dicno == l._dicno &&
				_pos == l._pos &&
				_str.equals(l._str);
	}
	/**
	 * ̃R[h̃TCYԂ
	 * @return R[hTCY(oCg)
	 */
	public int getRecordSize() {
		return byteStream().length;
	}
}

// end of KeywordLocation.java
