/*
 * Indexer
 * ]uCfbNX쐬NX
 */
package org.logical_paradox.fts;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Calendar;

public final class Indexer {
	private final String contentsDirectory;
	protected final IndexAccessor accessor;			// ]uCfbNXf[^t@CɃANZX邽߂̃C^[tF[X
	protected final Parser parser;

	/*
	 * RXgN^
	 */
	public Indexer( String dirname ) throws Exception {
		contentsDirectory = dirname;
		accessor = IndexAccessorFactory.getIndexAccessor(FullTextSearchProperty.FTS_INDEX_PROPERTY_NAME);
		parser = new Parser( accessor, FullTextSearchProperty.GRAM_LENGTH );
	}

	/*
	 * QƂĂRecfBNgԂ
	 */
	public String getContentsDirectory() {
		return contentsDirectory;

	}

	/*
	 * w肳ꂽfBNgɊi[Ă镶̃t@CzɂĕԂ
	 */
	public File[] documents() throws IOException {
		return new File( contentsDirectory ).listFiles();
	}

	/*
	 * SẴt@C͂
	 */
	public void parseAllFiles() throws Exception {
		File[] files = documents();

		for( int i = 0; i < files.length; i++ ) {
			if(files[i].isFile() == false) {
				// fBNg͖
				continue;
			}
			System.err.println( "processing: " + files[i] );

			BufferedReader br = new BufferedReader( new InputStreamReader( new FileInputStream( files[i] ), "UnicodeBig" ) );
			StringBuffer sb = new StringBuffer();
			String line = null;

			while( (line = br.readLine()) != null ) {
				sb.append( line );
			}
			br.close();
			parser.parse( sb.toString(), i );
		}
	}

	/*
	 * 
	 */
	public void close() throws Exception {
		if( accessor.isClosed() == false ) {
			accessor.close();
		}
	}

	/*
	 * N\bh
	 */
	public static void main( String[] args ) throws Exception {
		String dirname = null;
		if( args.length == 0 ) {
			dirname = "db";
		} else {
			dirname = args[0];
		}

		System.out.println("Jn: " + Calendar.getInstance().getTime());

		Indexer idxr = new Indexer( dirname );
		idxr.parseAllFiles();
		idxr.close();

		System.out.println("I: " + Calendar.getInstance().getTime());
		System.err.println( "done." );
	}
}

// end of Indexer.java
