/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.fts;

import java.io.IOException;

import org.logical_paradox.common.btree.Btree;
import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeResultSet;
import org.logical_paradox.common.btree.BtreeSession;
import org.logical_paradox.common.vrm.Record;
import org.logical_paradox.common.vrm.RecordFactory;
import org.logical_paradox.common.vrm.VariableRecordManager;

/**
 * @author satoshi akabane@logical-paradox.org
 * @version $Id: CommonBtreeIndexAccessor.java,v 1.1 2004/07/22 16:16:48 rampil Exp $
 */
public class CommonBtreeIndexAccessor implements IndexAccessor {
	private final BtreeSession session;
	private final VariableRecordManager vrm;

	/**
	 * ftHgRXgN^
	 * @param filename t@C
	 */
	public CommonBtreeIndexAccessor(String filename) throws IOException {
		try {
			session = Btree.getInstance(new FTSBtreeFactory()).getSession().open(filename);
			// ftHg̃R[ht@NgŉϒR[h}l[W[쐬
			vrm = new VariableRecordManager(filename + ".dat", RecordFactory.getInstance("org.logical_paradox.fts.KeywordLocationArrayRecordFactory"));
		} catch(BtreeException be) {
			be.printStackTrace();
			throw new IOException(be.getMessage());
		} catch(Exception e) {
			e.printStackTrace();
			throw new IOException(e.getMessage());
		}
	}
	/**
	 * ANZTN[YĂ邩ǂ]
	 * @return true: Ă / false:JĂ
	 */
	public boolean isClosed() {
		return session.isClosed();
	}
	/**
	 * CfbNXANZT
	 * @exception IndexAccessException N[Yɉ炩̗O
	 */
	public void close() throws IndexAccessException {
		try {
			vrm.close();
			session.close();
		} catch(Exception be) {
			throw new IndexAccessException(be.getMessage());
		}
	}
	/**
	 * VL[Xg[Wɑ}
	 * @param k L[
	 * @param o IuWFNg
	 * @exception IndexAccessException }ɉ炩̗O
	 */
	public void addKey(Key k, Object o) throws IndexAccessException {
		try {
			// w肳ꂽL[ɕRtĂf[^ɓo^Ă邩ǂ𒲂ׂ
			// ɑ݂ꍇC̃f[^͍폜Ȃ΂ȂȂ
			FTSBtreeKey key = (FTSBtreeKey)session.newKey(k.toString());
			BtreeResultSet rs = session.find(key);
			if(rs != null) {
				FTSBtreeKey oldKey = (FTSBtreeKey)rs.getKey();
				if(oldKey != null) {
					// ɓo^ς݂̏ꍇ̓f[^폜
					vrm.delete(key.getOffset());
					// t@C擾L[ėp
					key = oldKey;
				}
			}
			// VRMɑ΂Ă܂f[^o^
			// o^f[^͕KRecord̔hNXłȂ΂ȂȂ
			long offset = vrm.insert((Record)o);
				
			// oCgψʂݒ肵ăL[o^
			// ɑ݂ꍇ̓L[̍XVɂȂ
			key.setOffset(offset);
			session.insert(key);
		} catch(Exception be) {
			be.printStackTrace();
			throw new IndexAccessException(be.getMessage());
		}
	}
	/**
	 * L[ɑΉIuWFNg폜
	 * @param k L[
	 * @return 폜ꂽIuWFNg
	 * @exception IndexAccessException 폜Ɏs
	 */
	public Object removeKey(Key k) throws IndexAccessException {
		// 폜͂܂ĂȂ͂
		return null;
	}

	/**
	 * L[ɑΉlIuWFNgTĕԂ
	 * @param k L[
	 * @return oꂽIuWFNg
	 * @exception IndexAccessException Ɏs
	 */
	public Object getValue(Key k) throws IndexAccessException {
		// L[̂̂IuWFNgłƉ肵āCL[Ԃ
		try {
			BtreeResultSet result = session.find(session.newKey(k.toString()));
			if(result == null) {
				return null;
			}
			FTSBtreeKey key = (FTSBtreeKey)result.getKey();
			if(key == null) {
				return null;
			}

			// VRMYʒũf[^擾ĕԂ
			return vrm.get(key.getOffset());
		} catch(BtreeException be) {
			throw new IndexAccessException(be.getMessage());
		} catch(IOException ioe) {
			ioe.printStackTrace();
			throw new IndexAccessException(ioe.getMessage());
		}
	}
}
