/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.btree.simulation.bts;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.logical_paradox.common.btree.simulation.bts.BTSEventHandler;
import org.logical_paradox.common.btree.simulation.bts.Diagram;
import org.logical_paradox.common.btree.simulation.bts.DiagramCanvas;

public class BtreeSimulatorMainPanel
extends JPanel {
    private Diagram diagram;
    private static FontMetrics metrics;
    protected DiagramCanvas canvas;
    protected JTextField keyInputField;
    protected JButton btnAdd;
    protected JButton btnRemove;
    protected JButton btnChange;
    protected BTSEventHandler handler;

    public BtreeSimulatorMainPanel() throws Exception {
        this.init();
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public Dimension getCanvasSize() {
        return this.canvas.getPreferredSize();
    }

    public static FontMetrics getFontMetrics() {
        return metrics;
    }

    public void init() throws Exception {
        this.diagram = new Diagram(this);
        this.handler = new BTSEventHandler(this);
        this.canvas = new DiagramCanvas();
        JPanel controlPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        this.keyInputField = new JTextField();
        this.keyInputField.addActionListener(this.handler);
        this.btnAdd = new JButton("\u8ffd\u52a0");
        this.btnRemove = new JButton("\u524a\u9664");
        this.btnChange = new JButton("\u5909\u66f4");
        this.btnAdd.addActionListener(this.handler);
        this.btnRemove.addActionListener(this.handler);
        this.btnChange.addActionListener(this.handler);
        buttonPanel.setLayout(new GridLayout(1, 3));
        buttonPanel.add(this.btnAdd);
        buttonPanel.add(this.btnChange);
        buttonPanel.add(this.btnRemove);
        controlPanel.setLayout(new BorderLayout());
        controlPanel.add((Component)this.keyInputField, "Center");
        controlPanel.add((Component)buttonPanel, "East");
        controlPanel.add((Component)new JLabel("  key    "), "West");
        controlPanel.add((Component)new JSeparator(), "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.canvas, "Center");
        this.add((Component)controlPanel, "North");
        this.validate();
    }

    public JTextField getTextField() {
        return this.keyInputField;
    }

    public JButton getAddButton() {
        return this.btnAdd;
    }

    public JButton getRemoveButton() {
        return this.btnRemove;
    }

    public JButton getChangeButton() {
        return this.btnChange;
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setFont(new Font("SanSelif", 0, 10));
        metrics = g.getFontMetrics();
        this.diagram.paint(g);
    }
}

