/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.btree;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeFactory;
import org.logical_paradox.common.btree.BtreeFile;
import org.logical_paradox.common.btree.BtreeKey;
import org.logical_paradox.common.btree.BtreeKeyTestImpl;
import org.logical_paradox.common.btree.BtreePage;

public class BtreePageTest
extends TestCase {
    private BtreeFactory _factory = null;

    public BtreePageTest(String name) {
        super(name);
    }

    public void testBtreePage_Constructor1() throws Exception {
        BtreePage bp = null;
        this._factory.getProperty().setProperty("btreefile.order", "64");
        bp = new BtreePage(this._factory, 1L);
        Assert.assertTrue((String)"\u6b63\u5e38\u7cfb\u306e\u6b21\u6570\u304c\u304a\u304b\u3057\u3044", (bp.order() == 64 ? 1 : 0) != 0);
        Assert.assertTrue((String)"\u6b63\u5e38\u7cfb\u306e\u30da\u30fc\u30b8\u756a\u53f7\u304c\u304a\u304b\u3057\u3044", (bp.getPageNo() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((String)"\u6b63\u5e38\u7cfb\u306e\u5b50\u30ce\u30fc\u30c9\u6570\u304c\u304a\u304b\u3057\u3044", (bp.children() == 65 ? 1 : 0) != 0);
        try {
            this._factory.getProperty().setProperty("btreefile.order", "0");
            bp = new BtreePage(this._factory, 0L);
            Assert.fail((String)"\u6b21\u65700\u3067\u4f5c\u6210\u3055\u308c\u3066\u3057\u307e\u3063\u305f");
        }
        catch (BtreeException btreeException) {
            // empty catch block
        }
        try {
            this._factory.getProperty().setProperty("btreefile.order", "-1");
            bp = new BtreePage(this._factory, 0L);
            Assert.fail((String)"\u6b21\u6570-1\u3067\u4f5c\u6210\u3055\u308c\u3066\u3057\u307e\u3063\u305f");
        }
        catch (BtreeException btreeException) {
            // empty catch block
        }
        try {
            this._factory.getProperty().setProperty("btreefile.order", "1");
            bp = new BtreePage(this._factory, -1L);
            Assert.fail((String)"\u30da\u30fc\u30b8\u756a\u53f7-1\u3067\u4f5c\u6210\u3055\u308c\u3066\u3057\u307e\u3063\u305f");
        }
        catch (BtreeException btreeException) {
            // empty catch block
        }
        this._factory.getProperty().setProperty("btreefile.order", "1");
        bp = new BtreePage(this._factory, 0L);
    }

    public void testBtreePage_Constructor2() {
    }

    public void testInsert() throws Exception {
        this._factory.getProperty().setProperty("btreefile.order", "3");
        BtreePage bp = new BtreePage(this._factory, 0L);
        BtreeKey[] keys = new BtreeKey[]{new BtreeKeyTestImpl("\u30ad\u30fc1"), new BtreeKeyTestImpl("\u30ad\u30fc2"), new BtreeKeyTestImpl("\u30ad\u30fc3"), new BtreeKeyTestImpl("\u30ad\u30fc4")};
        int i = 0;
        while (i < 4) {
            BtreePage.PromoResult pr = bp.insert(keys[i], -1L);
            Assert.assertTrue((String)("\u306a\u305c\u304b\u6607\u9032\u304c\u767a\u751f\u3057\u305f: i=" + i), (pr == null || i == 3 ? 1 : 0) != 0);
            Assert.assertTrue((String)("\u30ad\u30fc\u306e\u7dcf\u6570\u304c\u304a\u304b\u3057\u3044: k=" + bp.keyCount()), (bp.keyCount() == i + 1 && i < 3 || bp.keyCount() == 2 && i == 3 ? 1 : 0) != 0);
            Assert.assertTrue((String)"\u633f\u5165\u3057\u305f\u306f\u305a\u306a\u306e\u306b\u30da\u30fc\u30b8\u306b\u683c\u7d0d\u3055\u308c\u3066\u3044\u306a\u3044", (bp.isContained(keys[i]) && i < 3 || !bp.isContained(keys[i]) && i == 3 ? 1 : 0) != 0);
            if (i == 3) {
                Assert.assertTrue((String)"\u6607\u9032\u304c\u767a\u751f\u3057\u306a\u304b\u3063\u305f", (pr != null && pr._promoKey != null ? 1 : 0) != 0);
                Assert.assertTrue((String)"\u5206\u5272\u304c\u767a\u751f\u3057\u305f\u306a\u304b\u3063\u305f", (pr != null && pr._page != null ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testPromotion() throws Exception {
        this._factory.getProperty().setProperty("btreefile.order", "3");
        BtreePage bp = new BtreePage(this._factory, 0L);
        BtreePage.PromoResult pr = null;
        BtreeKeyTestImpl key1 = new BtreeKeyTestImpl("A");
        pr = bp.insert(key1, -1L);
        Assert.assertTrue((String)"\u306a\u305c\u304b\u6607\u9032\u304c\u767a\u751f\u3057\u305f - A", (pr == null ? 1 : 0) != 0);
        BtreeKeyTestImpl key2 = new BtreeKeyTestImpl("G");
        pr = bp.insert(key2, 1L);
        Assert.assertTrue((String)"\u306a\u305c\u304b\u6607\u9032\u304c\u767a\u751f\u3057\u305f - G", (pr == null ? 1 : 0) != 0);
        BtreeKeyTestImpl key3 = new BtreeKeyTestImpl("M");
        pr = bp.insert(key3, 3L);
        Assert.assertTrue((String)"\u306a\u305c\u304b\u6607\u9032\u304c\u767a\u751f\u3057\u305f - M", (pr == null ? 1 : 0) != 0);
        BtreeKeyTestImpl key4 = new BtreeKeyTestImpl("Q");
        pr = bp.insert(key4, -1L);
        Assert.assertTrue((String)"\u6607\u9032\u304c\u767a\u751f\u3057\u306a\u304b\u3063\u305f - Q", (pr != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"\u6607\u9032\u304c\u767a\u751f\u3057\u305f\u306e\u304cM\u3067\u306a\u304b\u3063\u305f", (boolean)pr._promoKey.equals(new BtreeKeyTestImpl("M")));
        Assert.assertTrue((String)"\u6607\u9032\u304c\u767a\u751f\u3057\u305f\u306e\u304cG\u3060\u3063\u305f", (!pr._promoKey.equals(new BtreeKeyTestImpl("G")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"\u6607\u9032\u304c\u767a\u751f\u3057\u305f\u306e\u304cQ\u3060\u3063\u305f", (!pr._promoKey.equals(new BtreeKeyTestImpl("Q")) ? 1 : 0) != 0);
        Assert.assertTrue((String)"\u6607\u9032\u304c\u767a\u751f\u3057\u305f\u306e\u304cA\u3060\u3063\u305f", (!pr._promoKey.equals(new BtreeKeyTestImpl("A")) ? 1 : 0) != 0);
        Assert.assertTrue((String)("\u5206\u5272\u306b\u3088\u3063\u3066\u767a\u751f\u3057\u305f\u30da\u30fc\u30b8\u306b\u683c\u7d0d\u3055\u308c\u3066\u3044\u308b\u30ad\u30fc\u306e\u6570\u304c1\u3067\u306a\u3044:" + pr._page.keyCount()), (pr._page.keyCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"\u5206\u5272\u306b\u3088\u3063\u3066\u767a\u751f\u3057\u305f\u30da\u30fc\u30b8\u306bA\u304c\u542b\u307e\u308c\u3066\u3044\u305f", (!pr._page.isContained(key1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"\u5206\u5272\u306b\u3088\u3063\u3066\u767a\u751f\u3057\u305f\u30da\u30fc\u30b8\u306bG\u304c\u542b\u307e\u308c\u3066\u3044\u305f", (!pr._page.isContained(key2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"\u5206\u5272\u306b\u3088\u3063\u3066\u767a\u751f\u3057\u305f\u30da\u30fc\u30b8\u306bM\u304c\u542b\u307e\u308c\u3066\u3044\u305f", (!pr._page.isContained(key3) ? 1 : 0) != 0);
        Assert.assertTrue((String)"\u5206\u5272\u306b\u3088\u3063\u3066\u767a\u751f\u3057\u305f\u30da\u30fc\u30b8\u306bQ\u304c\u542b\u307e\u308c\u3066\u3044\u306a\u304b\u3063\u305f", (boolean)pr._page.isContained(key4));
        Assert.assertTrue((String)"A\u306e\u5de6\u306e\u5b50\u304c-1\u3067\u306a\u304b\u3063\u305f", (bp.leftChildOf(key1) == -1L ? 1 : 0) != 0);
        Assert.assertTrue((String)"A\u306e\u53f3\u306e\u5b50\u304c-1\u3067\u306a\u304b\u3063\u305f", (bp.rightChildOf(key1) == -1L ? 1 : 0) != 0);
        Assert.assertTrue((String)"G\u306e\u5de6\u306e\u5b50\u304c-1\u3067\u306a\u304b\u3063\u305f", (bp.leftChildOf(key2) == -1L ? 1 : 0) != 0);
        Assert.assertTrue((String)"G\u306e\u53f3\u306e\u5b50\u304c1\u3067\u306a\u304b\u3063\u305f", (bp.rightChildOf(key2) == 1L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Q\u306e\u5de6\u306e\u5b50\u304c3\u3067\u306a\u304b\u3063\u305f", (pr._page.leftChildOf(key4) == 3L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Q\u306e\u53f3\u306e\u5b50\u304c-1\u3067\u306a\u304b\u3063\u305f", (pr._page.rightChildOf(key4) == -1L ? 1 : 0) != 0);
    }

    public void testFind() throws Exception {
        this._factory.getProperty().setProperty("btreefile.order", "5");
        BtreePage bp = new BtreePage(this._factory, 0L);
        BtreeKeyTestImpl key = new BtreeKeyTestImpl("\u30c6\u30b9\u30c8\u30ad\u30fc");
        BtreePage.PromoResult pr = bp.insert(key, -1L);
        Assert.assertTrue((String)"\u30da\u30fc\u30b8\u304b\u3089\u898b\u3064\u3051\u3089\u308c\u306a\u304b\u3063\u305f", (bp.find(key.toString()) != null ? 1 : 0) != 0);
    }

    public void testShouldBeContained() throws Exception {
        this._factory.getProperty().setProperty("btreefile.order", "7");
        BtreePage bp = new BtreePage(this._factory, 0L);
        BtreeKeyTestImpl key1 = new BtreeKeyTestImpl("A");
        BtreeKeyTestImpl key2 = new BtreeKeyTestImpl("D");
        BtreeKeyTestImpl key3 = new BtreeKeyTestImpl("B");
        BtreePage.PromoResult pr = null;
        pr = bp.insert(key1, -1L);
        pr = bp.insert(key2, -1L);
        Assert.assertTrue((String)"\u542b\u307e\u308c\u308b\u3079\u304d\u306f\u305a\u306a\u306e\u306b\u542b\u307e\u308c\u306a\u3044\u3068\u3067\u305f", (bp.shouldBeContained(key3) ? 1 : 0) != 0);
        pr = bp.insert(key3, 0L);
        BtreeKeyTestImpl key4 = new BtreeKeyTestImpl("C");
        BtreeKeyTestImpl key5 = new BtreeKeyTestImpl("0");
        bp.insert(key5, 1L);
        BtreeKeyTestImpl key6 = new BtreeKeyTestImpl("Q");
        bp.insert(key6, -1L);
    }

    public void testIsContained() throws Exception {
        BtreeKeyTestImpl key2 = new BtreeKeyTestImpl("\u3053\u3093\u306b\u3061\u306f");
        BtreeKeyTestImpl key1 = new BtreeKeyTestImpl("abc");
        this._factory.getProperty().setProperty("btreefile.order", "16");
        BtreePage bp = new BtreePage(this._factory, 0L);
        bp.insert(key2, -1L);
        bp.insert(key1, -1L);
        Assert.assertNotNull((Object)bp.find("abc"));
        Assert.assertNotNull((Object)bp.find("\u3053\u3093\u306b\u3061\u306f"));
    }

    public void testToByteStream() throws Exception {
        BtreeFile file = this._factory.getFileHandle("aa");
        this._factory.getProperty().setProperty("btreefile.order", "64");
        BtreePage btp = file.newPage();
        int keyByteSize = 128;
        int _order = 64;
        int pageStreamSize = keyByteSize * _order + 8 * (_order + 1) + 4;
        Assert.assertEquals((int)64, (int)Integer.parseInt(this._factory.getProperty().getProperty("btreefile.order")));
        Assert.assertEquals((int)keyByteSize, (int)this._factory.keyByteSize());
        Assert.assertEquals((int)_order, (int)btp.order());
        Assert.assertEquals((int)pageStreamSize, (int)btp.getByteStream().length);
    }

    public void testFromByteStream() throws Exception {
        BtreeFile file = this._factory.getFileHandle("aa");
        this._factory.getProperty().setProperty("btreefile.order", "64");
        BtreePage btp1 = file.newPage();
        btp1.insert(this._factory.newKey("\u3042\u3042\u3042"), 1024L);
        BtreePage btp2 = new BtreePage(this._factory, 100L, btp1.getByteStream());
        Assert.assertEquals((int)btp1.order(), (int)btp2.order());
        Assert.assertEquals((int)btp1.keyCount(), (int)btp2.keyCount());
        Assert.assertNotNull((Object)btp1.find("\u3042\u3042\u3042"));
        Assert.assertNotNull((Object)btp2.find("\u3042\u3042\u3042"));
        Assert.assertEquals((Object)btp1.find("\u3042\u3042\u3042"), (Object)btp2.find("\u3042\u3042\u3042"));
        Assert.assertEquals((long)btp1.rightChildOf(btp1.find("\u3042\u3042\u3042")), (long)btp2.rightChildOf(btp2.find("\u3042\u3042\u3042")));
        Assert.assertEquals((long)btp1.leftChildOf(btp1.find("\u3042\u3042\u3042")), (long)btp2.leftChildOf(btp2.find("\u3042\u3042\u3042")));
    }

    public void testDelete() {
    }

    public void setUp() throws Exception {
        this._factory = BtreeFactory.getInstance("org.logical_paradox.common.btree.BtreeFactoryTestImpl");
    }
}

