/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.btree;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.logical_paradox.common.io.AvailableList;

public class BtreeAvailableList
extends AvailableList {
    public BtreeAvailableList(String filename) {
        super(filename, 0);
    }

    public BtreeAvailableList(String filename, int size) {
        super(filename, size);
    }

    protected void restore(ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            this.cache.add((Object)new Long(buffer.getLong()));
        }
    }

    public void flush() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(this.cache.size() * 8).order(ByteOrder.BIG_ENDIAN);
        Long buf = null;
        while ((buf = (Long)this.cache.getOne()) != null) {
            buffer.putLong(buf);
        }
        OutputStream out = this.getOutputStream();
        out.write(buffer.array());
        out.close();
    }
}

