/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.btree;

import java.io.IOException;
import java.util.Properties;
import java.util.Stack;
import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeFactory;
import org.logical_paradox.common.btree.BtreeFile;
import org.logical_paradox.common.btree.BtreeKey;
import org.logical_paradox.common.btree.BtreeManipulationException;
import org.logical_paradox.common.btree.BtreePage;
import org.logical_paradox.common.btree.BtreeResultSet;
import org.logical_paradox.common.btree.BtreeSession;
import org.logical_paradox.common.thread.ReadWriteLock;

public class Btree {
    private int _order = 0;
    private String _filename = null;
    private BtreeFile _file = null;
    private BtreePage[] _cachedPages = null;
    private final BtreeFactory _factory;
    private ReadWriteLock _lock = null;

    protected Btree(BtreeFactory factory) {
        this._factory = factory;
        this._lock = new ReadWriteLock();
    }

    public static Btree getInstance(BtreeFactory factory) {
        return new Btree(factory);
    }

    public void open(String filename) throws BtreeException {
        this.open(filename, 0);
    }

    public void open(String filename, int cachesize) throws BtreeException {
        Properties prop = this._factory.getProperty();
        this._filename = filename;
        this._order = Integer.parseInt(prop.getProperty("btreefile.order"));
        this._filename = filename;
        this._cachedPages = new BtreePage[cachesize];
        try {
            this._file = this._factory.getFileHandle(filename);
            if (this._file.length() > 0L) {
                this._file.reload();
            } else {
                this._file.flush();
            }
        }
        catch (Exception fn) {
            throw new BtreeException(fn.getMessage());
        }
    }

    public BtreeSession getSession() throws BtreeException {
        return new BtreeSession(this);
    }

    protected void close() throws BtreeException {
        try {
            this._file.close();
        }
        catch (IOException ioe) {
            throw new BtreeException(ioe.getMessage());
        }
    }

    public boolean isClosed() {
        return this._file == null || this._file.isClosed();
    }

    protected BtreeKey newKey(Object o) throws BtreeException {
        return this._factory.newKey(o);
    }

    protected void insert(BtreeKey key) throws BtreeException, BtreeManipulationException {
        try {
            try {
                this._lock.beginRead();
                BtreePathTrace trace = this.findInsertablePage(this._file.getRootPageNo(), key, new BtreePathTrace());
                BtreePage insertableTarget = trace.getFound();
                if (insertableTarget == null) {
                    insertableTarget = this._file.newPage();
                }
                BtreePage.PromoResult promo = null;
                long rightChild = -1L;
                long originalPageNo = -1L;
                while ((promo = insertableTarget.insert(key, rightChild)) != null) {
                    this.commit(insertableTarget);
                    originalPageNo = insertableTarget.getPageNo();
                    promo._page.setPageNo(-1L);
                    this.commit(promo._page);
                    key = promo._promoKey;
                    rightChild = promo._page.getPageNo();
                    insertableTarget = trace.pop();
                    if (rightChild == 685L) {
                        System.out.println("aaa");
                    }
                    if (insertableTarget != null) continue;
                    insertableTarget = this._file.newPage();
                    insertableTarget.setChildNodeAt(0, originalPageNo);
                    this._file.replaceRootPageNo(insertableTarget.getPageNo());
                }
                if (insertableTarget != null) {
                    this.commit(insertableTarget);
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                throw new BtreeException(ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                this._lock.release();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        Object var9_10 = null;
        try {
            this._lock.release();
        }
        catch (Exception e) {}
    }

    protected void delete(BtreeKey key) throws BtreeException {
    }

    protected void update(BtreeKey key) throws BtreeException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BtreeResultSet find(BtreeKey key) throws BtreeException {
        Object result = null;
        try {
            try {
                this._lock.beginRead();
                BtreeResultSet btreeResultSet = this.findRecursive(this._file.getRootPageNo(), key);
                Object var4_4 = null;
                try {
                    this._lock.release();
                    return btreeResultSet;
                }
                catch (Exception ee) {
                    // empty catch block
                }
                return btreeResultSet;
            }
            catch (BtreeException be) {
                be.printStackTrace();
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BtreeException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {}
            catch (Exception ee) {
                throw throwable;
            }
            this._lock.release();
            throw throwable;
        }
    }

    protected void commit(BtreePage bp) throws BtreeException {
        if (bp.getPageNo() == -1L) {
            BtreePage newp = this._file.newPage();
            bp.setPageNo(newp.getPageNo());
        }
        if (bp.getPageNo() == 685L) {
            System.out.println("685 was created");
        }
        this._file.replacePage(bp);
    }

    protected BtreeResultSet findRecursive(long root, BtreeKey key) throws BtreeException {
        if (root <= 0L) {
            return null;
        }
        BtreePage btp = this.getPage(root);
        BtreeKey bk = btp.find(key.toString());
        if (bk != null) {
            BtreeResultSet result = new BtreeResultSet();
            result.setKey(bk);
            return result;
        }
        return this.findRecursive(btp.getChildPageNo(key), key);
    }

    protected BtreePathTrace findInsertablePage(long root, BtreeKey key, BtreePathTrace pt) throws BtreeException {
        if (root <= 0L) {
            return pt;
        }
        BtreePage btp = this.getPage(root);
        if (btp.shouldBeContained(key)) {
            pt.setFound(btp);
            return pt;
        }
        pt.push(btp);
        long child = btp.getChildPageNo(key);
        return this.findInsertablePage(child, key, pt);
    }

    protected BtreePage getPage(long pageno) throws BtreeException {
        return this.getPage(pageno, false);
    }

    protected BtreePage getPage(long pageno, boolean swap) throws BtreeException {
        return this._file.getPage(pageno);
    }

    protected class BtreePathTrace {
        private final Stack pathStack = new Stack();
        private BtreePage foundPage = null;

        protected BtreePathTrace() {
        }

        protected void push(BtreePage bp) {
            this.pathStack.push(bp);
        }

        protected BtreePage pop() {
            return !this.pathStack.empty() ? (BtreePage)this.pathStack.pop() : null;
        }

        protected void setFound(BtreePage bp) {
            this.foundPage = bp;
        }

        protected BtreePage getFound() {
            return this.foundPage;
        }

        protected boolean isEmpty() {
            return this.pathStack.empty();
        }

        protected void clear() {
            Stack stack = this.pathStack;
            synchronized (stack) {
                while (!this.pathStack.empty()) {
                    this.pathStack.pop();
                }
            }
        }
    }
}

