/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.vrm;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import org.logical_paradox.common.io.AvailableList;
import org.logical_paradox.common.util.Cache;
import org.logical_paradox.common.util.PriorityCache;
import org.logical_paradox.common.vrm.AvailableRecord;

public class VRMAvailableList
extends AvailableList {
    private long offset;

    public VRMAvailableList(String filename) {
        super(filename);
    }

    public VRMAvailableList(String filename, int size) {
        super(filename, size);
    }

    protected Cache createCache(int size) {
        return new PriorityCache(size, 1);
    }

    protected void restore(ByteBuffer buffer) throws IOException {
        new RestoreThread(buffer, this.cache).start();
    }

    public void setOffset(long o) {
        this.offset = o;
    }

    public long getOffset() {
        return this.offset;
    }

    public void flush() throws IOException {
        OutputStream out = this.getOutputStream();
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        buffer.putLong(this.offset);
        ((Buffer)buffer).rewind();
        out.write(buffer.array());
        AvailableRecord ar = null;
        Iterator it = this.cache.iterator();
        while (it.hasNext()) {
            ar = (AvailableRecord)it.next();
            out.write(ar.byteStream());
        }
        out.flush();
        out.close();
    }

    class RestoreThread
    extends Thread {
        private ByteBuffer buffer;
        private Cache cache;

        RestoreThread(ByteBuffer buf, Cache cache) {
            this.buffer = buf;
            this.cache = cache;
        }

        public void run() {
            if (this.buffer.hasRemaining()) {
                VRMAvailableList.this.offset = this.buffer.getLong();
            } else {
                VRMAvailableList.this.offset = 0L;
            }
            while (this.buffer.hasRemaining()) {
                int availableRecordSize = this.buffer.getInt();
                long nextptr = this.buffer.getLong();
                this.cache.add((Object)new AvailableRecord(availableRecordSize, nextptr));
                if (nextptr < 0L) break;
            }
            System.out.println("\u5229\u7528\u53ef\u80fd\u30ea\u30b9\u30c8\u306e\u5fa9\u5143\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f");
        }
    }
}

