/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.lang;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.logical_paradox.common.io.ByteStream;

public class IntegerByteStream
implements ByteStream {
    private final Integer value;
    private final byte[] bstream;

    public IntegerByteStream(Integer l) {
        this.value = l;
        this.bstream = this.objectToByteStream(l);
    }

    public IntegerByteStream(int l) {
        this(new Integer(l));
    }

    public Integer getIntegerObject() {
        return this.value;
    }

    public long intValue() {
        return this.value.intValue();
    }

    public byte[] byteStream() {
        return this.bstream;
    }

    protected byte[] objectToByteStream(int l) {
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        ((Buffer)buffer).rewind();
        buffer.putInt(l);
        return buffer.array();
    }
}

