/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import jdbm.recman.BlockIo;
import jdbm.recman.RecordFile;

final class TransactionManager {
    private RecordFile owner;
    private FileOutputStream fos;
    private ObjectOutputStream oos;
    static final int TXNS_IN_LOG = 10;
    private ArrayList[] txns = new ArrayList[10];
    private int curTxn = -1;
    static final String extension = ".lg";

    TransactionManager(RecordFile owner) throws IOException {
        this.owner = owner;
        this.recover();
        this.open();
    }

    void add(BlockIo block) throws IOException {
        block.incrementTransactionCount();
        this.txns[this.curTxn].add(block);
    }

    private void close() throws IOException {
        this.sync();
        this.oos.close();
        this.fos.close();
        this.oos = null;
        this.fos = null;
    }

    void commit() throws IOException {
        this.oos.writeObject(this.txns[this.curTxn]);
        this.sync();
        this.setClean(this.txns[this.curTxn]);
        this.oos = new ObjectOutputStream(this.fos);
    }

    private void discardBlocks(ArrayList blocks) throws IOException {
        Iterator k = ((AbstractList)blocks).iterator();
        while (k.hasNext()) {
            BlockIo cur = (BlockIo)k.next();
            cur.decrementTransactionCount();
            if (cur.isInTransaction()) continue;
            this.owner.releaseFromTransaction(cur, false);
        }
    }

    void forceClose() throws IOException {
        this.oos.close();
        this.fos.close();
        this.oos = null;
        this.fos = null;
    }

    private String makeLogName() {
        return String.valueOf(this.owner.getFileName()) + extension;
    }

    private void open() throws IOException {
        this.fos = new FileOutputStream(this.makeLogName());
        this.oos = new ObjectOutputStream(this.fos);
        this.oos.writeShort(4960);
        this.oos.flush();
        this.curTxn = -1;
    }

    private void recover() throws IOException {
        String logName = this.makeLogName();
        File logFile = new File(logName);
        if (!logFile.exists()) {
            return;
        }
        if (logFile.length() == 0L) {
            logFile.delete();
            return;
        }
        FileInputStream fis = new FileInputStream(logFile);
        ObjectInputStream ois = new ObjectInputStream(fis);
        try {
            if (ois.readShort() != 4960) {
                throw new Error("Bad magic on log file");
            }
        }
        catch (IOException iOException) {
            logFile.delete();
            return;
        }
        while (true) {
            ArrayList blocks = null;
            try {
                blocks = (ArrayList)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new Error("Unexcepted exception: " + e);
            }
            catch (IOException iOException) {
                break;
            }
            this.synchronizeBlocks(blocks, false);
            try {
                ois = new ObjectInputStream(fis);
                continue;
            }
            catch (IOException iOException) {}
            break;
        }
        this.owner.sync();
        logFile.delete();
    }

    private void setClean(ArrayList blocks) throws IOException {
        Iterator k = ((AbstractList)blocks).iterator();
        while (k.hasNext()) {
            BlockIo cur = (BlockIo)k.next();
            cur.setClean();
        }
    }

    void shutdown() throws IOException {
        this.synchronizeLogFromMemory();
        this.close();
    }

    void start() throws IOException {
        ++this.curTxn;
        if (this.curTxn == 10) {
            this.synchronizeLogFromMemory();
            this.curTxn = 0;
        }
        this.txns[this.curTxn] = new ArrayList();
    }

    private void sync() throws IOException {
        this.oos.flush();
        this.fos.flush();
        this.fos.getFD().sync();
    }

    private void synchronizeBlocks(ArrayList blocks, boolean fromCore) throws IOException {
        Iterator k = ((AbstractList)blocks).iterator();
        while (k.hasNext()) {
            BlockIo cur = (BlockIo)k.next();
            this.owner.synch(cur);
            if (!fromCore) continue;
            cur.decrementTransactionCount();
            if (cur.isInTransaction()) continue;
            this.owner.releaseFromTransaction(cur, true);
        }
    }

    void synchronizeLogFromDisk() throws IOException {
        this.close();
        int i = 0;
        while (i < 10) {
            if (this.txns[i] != null) {
                this.discardBlocks(this.txns[i]);
                this.txns[i] = null;
            }
            ++i;
        }
        this.recover();
        this.open();
    }

    private void synchronizeLogFromMemory() throws IOException {
        this.close();
        int i = 0;
        while (i < 10) {
            if (this.txns[i] != null) {
                this.synchronizeBlocks(this.txns[i], true);
                this.txns[i] = null;
            }
            ++i;
        }
        this.owner.sync();
        this.open();
    }
}

