/*
 * Decompiled with CFR 0.152.
 */
package jdbm.hash;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import jdbm.hash.HashNode;

final class HashBucket
extends HashNode
implements Externalizable {
    static final long serialVersionUID = 1L;
    public static final int OVERFLOW_SIZE = 8;
    private int _depth;
    private Vector _keys;
    private Vector _values;

    public HashBucket() {
    }

    public HashBucket(int level) {
        if (level > 4) {
            throw new Error("Cannot create bucket with depth > MAX_DEPTH+1. Depth=" + level);
        }
        this._depth = level;
        this._keys = new Vector(8);
        this._values = new Vector(8);
    }

    public Object addElement(Object key, Object value) {
        int existing = this._keys.indexOf(key);
        if (existing != -1) {
            Object before = this._values.elementAt(existing);
            this._values.setElementAt(value, existing);
            return before;
        }
        this._keys.addElement(key);
        this._values.addElement(value);
        return null;
    }

    public int getElementCount() {
        return this._keys.size();
    }

    Vector getKeys() {
        return this._keys;
    }

    public Object getValue(Object key) {
        int existing = this._keys.indexOf(key);
        if (existing != -1) {
            return this._values.elementAt(existing);
        }
        return null;
    }

    Vector getValues() {
        return this._values;
    }

    public boolean hasRoom() {
        if (this.isLeaf()) {
            return true;
        }
        return this._keys.size() < 8;
    }

    public boolean isLeaf() {
        return this._depth > 3;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._depth = in.readInt();
        int entries = in.readInt();
        int vectorSize = Math.max(entries, 8);
        this._keys = new Vector(vectorSize);
        this._values = new Vector(vectorSize);
        int i = 0;
        while (i < entries) {
            this._keys.addElement(in.readObject());
            ++i;
        }
        int i2 = 0;
        while (i2 < entries) {
            this._values.addElement(in.readObject());
            ++i2;
        }
    }

    public Object removeElement(Object key) {
        int existing = this._keys.indexOf(key);
        if (existing != -1) {
            Object obj = this._values.elementAt(existing);
            this._keys.removeElementAt(existing);
            this._values.removeElementAt(existing);
            return obj;
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("HashBucket {depth=");
        buf.append(this._depth);
        buf.append(", keys=");
        buf.append(this._keys);
        buf.append(", values=");
        buf.append(this._values);
        buf.append("}");
        return buf.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._depth);
        int entries = this._keys.size();
        out.writeInt(entries);
        int i = 0;
        while (i < entries) {
            out.writeObject(this._keys.elementAt(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < entries) {
            out.writeObject(this._values.elementAt(i2));
            ++i2;
        }
    }
}

