/*
 * Decompiled with CFR 0.152.
 */
package jdbm;

import java.io.IOException;
import jdbm.HTreeWrapper;
import jdbm.JDBMHashtable;
import jdbm.hash.HTree;
import jdbm.helper.MRU;
import jdbm.helper.ObjectCache;
import jdbm.recman.RecordManager;

public final class JDBMRecordManager {
    private static final int MAX_OBJECT_CACHE = 100;
    private RecordManager _recman;
    private ObjectCache _cache;

    public JDBMRecordManager(String filename) throws IOException {
        this._recman = new RecordManager(filename);
        this._cache = new ObjectCache(this._recman, new MRU(100));
    }

    public synchronized void close() throws IOException {
        this._recman.close();
        this._cache.dispose();
    }

    public synchronized void delete(long recid) throws IOException {
        this._recman.delete(recid);
        this._recman.commit();
    }

    public synchronized void disableTransactions() {
        this._recman.disableTransactions();
    }

    public synchronized byte[] fetchByteArray(long recid) throws IOException {
        byte[] data = this._recman.fetchByteArray(recid);
        this._recman.commit();
        return data;
    }

    public synchronized Object fetchObject(long recid) throws IOException, ClassNotFoundException {
        Object obj = this._cache.fetchObject(recid);
        this._recman.commit();
        return obj;
    }

    public synchronized JDBMHashtable getHashtable(String name) throws IOException {
        long root_recid = this._recman.getNamedObject(name);
        if (root_recid == 0L) {
            HTree tree = new HTree(this._recman, this._cache);
            root_recid = tree.getRecid();
            this._recman.setNamedObject(name, root_recid);
            this._recman.commit();
        }
        return new HTreeWrapper(this._recman, this._cache, root_recid);
    }

    public synchronized long getRoot(int id) throws IOException {
        long rid = this._recman.getRoot(id);
        this._recman.commit();
        return rid;
    }

    public int getRootCount() {
        return this._recman.getRootCount();
    }

    public synchronized long insert(Object obj) throws IOException {
        long id = this._recman.insert(obj);
        this._recman.commit();
        return id;
    }

    public synchronized long insert(byte[] data) throws IOException {
        long id = this._recman.insert(data);
        this._recman.commit();
        return id;
    }

    public synchronized void setRoot(int id, long rowid) throws IOException {
        int invalidRoot = 0;
        if (id == invalidRoot) {
            throw new IllegalArgumentException("Root " + invalidRoot + " is reserved for" + " named objects directory");
        }
        this._recman.setRoot(id, rowid);
        this._recman.commit();
    }

    public synchronized void update(long recid, Object obj) throws IOException {
        this._cache.update(recid, obj);
        this._recman.commit();
    }

    public synchronized void update(long recid, byte[] data) throws IOException {
        this._recman.update(recid, data);
        this._recman.commit();
    }
}

