package com.ibm.trl.tcg.pts.tools;

import junit.framework.TestCase;


/**
 * 
 * TODO verify of Quote2 signature was fail (successed by OpenSSL 1.0.0)
 * 
 * 
 * @author Seiji Munetoh (munetoh@users.sourceforge.jp)
 *
 */
public class SignatureToolTest extends TestCase {

	/**
	 * 
	 * C openpts data Quote2
	 * 2011-05-17
	 * pubkey    : [256]=C3F82071BE92F23EB4A062C0028142BC24C2349BCEC9BDF9061C7C04BA30E76CB29CF3AC4E44C87CF53E92B1379745F77125936ABAB3454BA8824CFB9DB816A26747B5F375883D531CD1CE43497B8F51005AF160E50D36514F93FD08C79BEB762A8CF49579190BD588B9286BEA8E566B00EE62E0C20A902D051E1FC2B44CA619CCECEE1F09641A83342D4313A3C96A66429D5A5ADA917D4CB9AD122A235CC87B24B3318A5775CFB5B130205B2B21D4ABEE4FA36B0D5BE1202B82C4D7BA29FD6342F3EF349E0EF0D1340D3A6F8D3128C6CB25ED35AAAAEEA557F97B18B7096B3057C20DD07E5D890301E01C4A693A9FFE912EB1671C2BBB2DFFFFAF0C246C1D85
	 * message   : [52]=003651555432C7B9651A179C4DE0187E647D706DC96277155C930003FF000000742F0D6AD264BEDB4BF837EAB7C683EEDAFEACEF
	 * signature : [256]=553CCEB3183C70B975D031D2DF485141C94ADAAFA63D8E6F9EE391FE2763FDF9FFD3593B230311C7784EE892F6CE99A28E88BBB3F5F6A0E83043EE10E9155354416BAF9311F9B02F0721154A06D6C7F3D76EC3F6648FB8082EFBADD478542B9CFAA54688614333842E5CE09793C233E9AE57E4780D66D7B53A608893F4239C210A56351E9C8A22CF0C6C64CCE92CB54E7A6E2E39995C09A678D4158A930894CD154C4AF8C1F13D537C8B1F47B08ABF3DBE62E555C26ECA3E234C35A1C7B01898A667496173F9E80E1C1FA80B9D732B9205FDC047E68EB4B1B3A3D00D623F5E847D32C111FFDBFB7F51F601B55179B857934000848D03155086EA169E6B37C735
	 * 
	 * pubkey    : [256]=C3F82071BE92F23EB4A062C0028142BC24C2349BCEC9BDF9061C7C04BA30E76CB29CF3AC4E44C87CF53E92B1379745F77125936ABAB3454BA8824CFB9DB816A26747B5F375883D531CD1CE43497B8F51005AF160E50D36514F93FD08C79BEB762A8CF49579190BD588B9286BEA8E566B00EE62E0C20A902D051E1FC2B44CA619CCECEE1F09641A83342D4313A3C96A66429D5A5ADA917D4CB9AD122A235CC87B24B3318A5775CFB5B130205B2B21D4ABEE4FA36B0D5BE1202B82C4D7BA29FD6342F3EF349E0EF0D1340D3A6F8D3128C6CB25ED35AAAAEEA557F97B18B7096B3057C20DD07E5D890301E01C4A693A9FFE912EB1671C2BBB2DFFFFAF0C246C1D85
message   : [52]=003651555432209138A6635CEC4FBA321AD30C60E5A8627098E70003FF000000742F0D6AD264BEDB4BF837EAB7C683EEDAFEACEF
signature : [256]=83B3F495347D098001FC518F696CC0429E5C2AB3A65629DD8A90CA36D88D614A5B9D768D56C94800CE361A1D27413B8D67175DE40B1E5A2D78F7EA2219502956424FE099A5B27D14F65CB1716142B238A03D7774D988907FCCE39EC362CAA69BB268F77F5D0D2FF7B3F11B7A8DAA54DB362C768C39E2D8550FE48C9DA02C90E4F424B7E265332C6671883D38DAA7C6D0AF81797E4F0FBEB9A29781AE598CE21BDB40A870E73FC6F0AD2B6FC1730406BB191E487F3F367F5533C40509EBDB9826652200AE9A426CEC79B5D77A93BA37C01980677A98B3CE25C2076B04DDAB99AEA2C7C468C971665569B9C43FC52F7A854EBD6463C80476CA3F205105B82C9529

	 * 
	 * 
	 */
	public void test001() {
		byte[] pubKey = HexTool.getBytes("C3F82071BE92F23EB4A062C0028142BC24C2349BCEC9BDF9061C7C04BA30E76CB29CF3AC4E44C87CF53E92B1379745F77125936ABAB3454BA8824CFB9DB816A26747B5F375883D531CD1CE43497B8F51005AF160E50D36514F93FD08C79BEB762A8CF49579190BD588B9286BEA8E566B00EE62E0C20A902D051E1FC2B44CA619CCECEE1F09641A83342D4313A3C96A66429D5A5ADA917D4CB9AD122A235CC87B24B3318A5775CFB5B130205B2B21D4ABEE4FA36B0D5BE1202B82C4D7BA29FD6342F3EF349E0EF0D1340D3A6F8D3128C6CB25ED35AAAAEEA557F97B18B7096B3057C20DD07E5D890301E01C4A693A9FFE912EB1671C2BBB2DFFFFAF0C246C1D85");
		byte[] message =  HexTool.getBytes("003651555432209138A6635CEC4FBA321AD30C60E5A8627098E70003FF000000742F0D6AD264BEDB4BF837EAB7C683EEDAFEACEF");
		byte[] signature =  HexTool.getBytes("83B3F495347D098001FC518F696CC0429E5C2AB3A65629DD8A90CA36D88D614A5B9D768D56C94800CE361A1D27413B8D67175DE40B1E5A2D78F7EA2219502956424FE099A5B27D14F65CB1716142B238A03D7774D988907FCCE39EC362CAA69BB268F77F5D0D2FF7B3F11B7A8DAA54DB362C768C39E2D8550FE48C9DA02C90E4F424B7E265332C6671883D38DAA7C6D0AF81797E4F0FBEB9A29781AE598CE21BDB40A870E73FC6F0AD2B6FC1730406BB191E487F3F367F5533C40509EBDB9826652200AE9A426CEC79B5D77A93BA37C01980677A98B3CE25C2076B04DDAB99AEA2C7C468C971665569B9C43FC52F7A854EBD6463C80476CA3F205105B82C9529");
	
		System.out.println("pubKey    : " + HexTool.getHexString(pubKey));
		System.out.println("message   : " + HexTool.getHexString(message));
		System.out.println("signature : " + HexTool.getHexString(signature));
		
		try {
			boolean rc = SignatureTool.validate(pubKey, message, signature);			
			if (rc == false) {
				System.out.println("QUOTE2 > BAD SIGNATURE  :-(");
				fail("validation  Error");			
			} else {
				System.out.println(":-)");
			}
		} catch (Exception e) {
			e.printStackTrace();
			fail("Exception Error");
		}
	}
	
	
	/**
	 * 
	 * J openpts data
	 * 2011-05-17
	 * pubKey    : 00c3f82071be92f23eb4a062c0028142bc24c2349bcec9bdf9061c7c04ba30e76cb29cf3ac4e44c87cf53e92b1379745f77125936abab3454ba8824cfb9db816a26747b5f375883d531cd1ce43497b8f51005af160e50d36514f93fd08c79beb762a8cf49579190bd588b9286bea8e566b00ee62e0c20a902d051e1fc2b44ca619ccecee1f09641a83342d4313a3c96a66429d5a5ada917d4cb9ad122a235cc87b24b3318a5775cfb5b130205b2b21d4abee4fa36b0d5be1202b82c4d7ba29fd6342f3ef349e0ef0d1340d3a6f8d3128c6cb25ed35aaaaeea557f97b18b7096b3057c20dd07e5d890301e01c4a693a9ffe912eb1671c2bbb2dffffaf0c246c1d85
     * message   : 003651555432196134d027e0044ae8c569de2304ede5446c24b60003ff000001742f0d6ad264bedb4bf837eab7c683eedafeacef
     * signature : 98de146744b1c2522f3ec6db4244ecb921f829495d3494edf1b2e2b6e17badb9892aeb2ed4a1ffc1b9ce8aae31ab81b2859bd6d848057987c4c1575a58904cd654ddd865089202b7f5fc22e58805c9472d15f203ef799762f25d0c660d0b572c7ba250517a2b6ba95dbc6f824e676267e4ab6b6980f43ce35e40d0bda12cd48f93e30fe943c5402aa544d455857a91d57a00f24180e6019308f5be3a9226ea589b82cde8bc7ddaae32e2e760d00127f006dcc3d982ec3496d9b41d8ea36ee71ae0f2f323e0823c08aefce72942107a53364385f4cebd420d6cbcec4821ba9a4bf192cd673cb609d5f6aae94455428c67fae07c90572ee646cb35ffcf9adc4a09
	 */
	public void test002() {
		byte[] pubKey = HexTool.getBytes("00c3f82071be92f23eb4a062c0028142bc24c2349bcec9bdf9061c7c04ba30e76cb29cf3ac4e44c87cf53e92b1379745f77125936abab3454ba8824cfb9db816a26747b5f375883d531cd1ce43497b8f51005af160e50d36514f93fd08c79beb762a8cf49579190bd588b9286bea8e566b00ee62e0c20a902d051e1fc2b44ca619ccecee1f09641a83342d4313a3c96a66429d5a5ada917d4cb9ad122a235cc87b24b3318a5775cfb5b130205b2b21d4abee4fa36b0d5be1202b82c4d7ba29fd6342f3ef349e0ef0d1340d3a6f8d3128c6cb25ed35aaaaeea557f97b18b7096b3057c20dd07e5d890301e01c4a693a9ffe912eb1671c2bbb2dffffaf0c246c1d85");
		//byte[] message =  HexTool.getBytes("003651555432196134d027e0044ae8c569de2304ede5446c24b60003ff000001742f0d6ad264bedb4bf837eab7c683eedafeacef");
		byte[] message =  HexTool.getBytes("003651555432196134d027e0044ae8c569de2304ede5446c24b60003ff000000742f0d6ad264bedb4bf837eab7c683eedafeacef");
		byte[] signature =  HexTool.getBytes("98de146744b1c2522f3ec6db4244ecb921f829495d3494edf1b2e2b6e17badb9892aeb2ed4a1ffc1b9ce8aae31ab81b2859bd6d848057987c4c1575a58904cd654ddd865089202b7f5fc22e58805c9472d15f203ef799762f25d0c660d0b572c7ba250517a2b6ba95dbc6f824e676267e4ab6b6980f43ce35e40d0bda12cd48f93e30fe943c5402aa544d455857a91d57a00f24180e6019308f5be3a9226ea589b82cde8bc7ddaae32e2e760d00127f006dcc3d982ec3496d9b41d8ea36ee71ae0f2f323e0823c08aefce72942107a53364385f4cebd420d6cbcec4821ba9a4bf192cd673cb609d5f6aae94455428c67fae07c90572ee646cb35ffcf9adc4a09");
	
		System.out.println("pubKey    : " + HexTool.getHexString(pubKey));
		System.out.println("message   : " + HexTool.getHexString(message));
		System.out.println("signature : " + HexTool.getHexString(signature));
		
		try {
			boolean rc = SignatureTool.validate(pubKey, message, signature);
			
			if (rc == false) {
				System.out.println("QUOTE2 > BAD SIGNATURE :-(");
				fail("validation  Error");			
			} else {
				System.out.println(":-)");
			}
		} catch (Exception e) {
			e.printStackTrace();
			fail("Exception Error");
		}
	}
	
	/**
	 * 
	 * C  Quote1 => PASS
	 * pubkey    : [256]=717A67AAD618A7D6A51EFE46CC7C3C23967BD0DA83BC1745407B1CDADD8AC43A1DFAF87D7BC0A19CCFBBC1218C10184BFCC35E9B080C46ECE5BA02CBC72DE1EC7B2B9FCF399B10EB7F910DB64F0CA4340959D4FE753A8EB9797251A2C7884903F6BEB4FBF2E188E389807315860ABC8C74CFB50DD0B6F85E052B7C62EDED22D7795E25365C8915F658E97E3FED7CE30D3A295A61BE20427B3E0705B749362B8183803C0482CCB276D486B9D7793FCA99E9284433F7FC1512F94A9C8F0742416AA00F54683C03C131F9C333D26EC933E13E300D87BF4914659D5F0A1298A34BC75C41DD832D90E8380589E22F0363322F2E256F2CC28259C3079A08384CC6080F
   message   : [48]=0101000051554F54120B0A1ACE7609ED67B3A4A58F97C1C7F6637E61196134D027E0044AE8C569DE2304EDE5446C24B6
   signature : [256]=36D28FE59D9CCBDB4AFEC02E866DD03913E22A1D2287F7DCCD4E24AB5CCF763E58F2AA400316F78BAB39F56CC0E45681BB21980D93E9655092BD0535FA9247C9204AAA1FFAD0006BD23DC8ADFDE5DE8C8C6ADA1F3EFA798BBC2731FCDA5D5EF017B8C22DCDE95C6FEB5F0253C89E63808CC0FC0A77F301CC444E883EE379E64DC43FE3B1AB6BCC98CB58D1525751E035C113884A173411B138CD24D646B6A6A7BC386B125C00BE4C14E08C569DA868D8E397F52FC0423A55135B3451482969E9272587961FB8878370EFDD49C7AD9D349C92BC1515CCAFBEAE21FEDF2AD625998E6E7B91EC3CFF4177F0D8B7585B0825FB263C236738DA88F0FAB133D0481705

	 */
	public void test003() {
		byte[] pubKey = HexTool.getBytes("717A67AAD618A7D6A51EFE46CC7C3C23967BD0DA83BC1745407B1CDADD8AC43A1DFAF87D7BC0A19CCFBBC1218C10184BFCC35E9B080C46ECE5BA02CBC72DE1EC7B2B9FCF399B10EB7F910DB64F0CA4340959D4FE753A8EB9797251A2C7884903F6BEB4FBF2E188E389807315860ABC8C74CFB50DD0B6F85E052B7C62EDED22D7795E25365C8915F658E97E3FED7CE30D3A295A61BE20427B3E0705B749362B8183803C0482CCB276D486B9D7793FCA99E9284433F7FC1512F94A9C8F0742416AA00F54683C03C131F9C333D26EC933E13E300D87BF4914659D5F0A1298A34BC75C41DD832D90E8380589E22F0363322F2E256F2CC28259C3079A08384CC6080F");
		
		byte[] message =  HexTool.getBytes("0101000051554F54120B0A1ACE7609ED67B3A4A58F97C1C7F6637E61196134D027E0044AE8C569DE2304EDE5446C24B6");
		//byte[] message =  HexTool.getBytes("A101000051554F54120B0A1ACE7609ED67B3A4A58F97C1C7F6637E61196134D027E0044AE8C569DE2304EDE5446C24B6");

		byte[] signature =  HexTool.getBytes("36D28FE59D9CCBDB4AFEC02E866DD03913E22A1D2287F7DCCD4E24AB5CCF763E58F2AA400316F78BAB39F56CC0E45681BB21980D93E9655092BD0535FA9247C9204AAA1FFAD0006BD23DC8ADFDE5DE8C8C6ADA1F3EFA798BBC2731FCDA5D5EF017B8C22DCDE95C6FEB5F0253C89E63808CC0FC0A77F301CC444E883EE379E64DC43FE3B1AB6BCC98CB58D1525751E035C113884A173411B138CD24D646B6A6A7BC386B125C00BE4C14E08C569DA868D8E397F52FC0423A55135B3451482969E9272587961FB8878370EFDD49C7AD9D349C92BC1515CCAFBEAE21FEDF2AD625998E6E7B91EC3CFF4177F0D8B7585B0825FB263C236738DA88F0FAB133D0481705");
	
		System.out.println("pubKey    : " + HexTool.getHexString(pubKey));
		System.out.println("message   : " + HexTool.getHexString(message));
		System.out.println("signature : " + HexTool.getHexString(signature));
		
		try {
			boolean rc = SignatureTool.validate(pubKey, message, signature);
			
			if (rc == false) {
				System.out.println("BAD SIGNATURE :-(");
				fail("validation  Error");
			} else {
				System.out.println(":-)");
			}
		} catch (Exception e) {
			e.printStackTrace();
			fail("Exception Error");
		}
	}
	/**
	 * 
	 * bad data => FAIL
	 * 
	 */
	public void test004() {
		byte[] pubKey = HexTool.getBytes("717A67AAD618A7D6A51EFE46CC7C3C23967BD0DA83BC1745407B1CDADD8AC43A1DFAF87D7BC0A19CCFBBC1218C10184BFCC35E9B080C46ECE5BA02CBC72DE1EC7B2B9FCF399B10EB7F910DB64F0CA4340959D4FE753A8EB9797251A2C7884903F6BEB4FBF2E188E389807315860ABC8C74CFB50DD0B6F85E052B7C62EDED22D7795E25365C8915F658E97E3FED7CE30D3A295A61BE20427B3E0705B749362B8183803C0482CCB276D486B9D7793FCA99E9284433F7FC1512F94A9C8F0742416AA00F54683C03C131F9C333D26EC933E13E300D87BF4914659D5F0A1298A34BC75C41DD832D90E8380589E22F0363322F2E256F2CC28259C3079A08384CC6080F");
		
		//byte[] message =  HexTool.getBytes("0101000051554F54120B0A1ACE7609ED67B3A4A58F97C1C7F6637E61196134D027E0044AE8C569DE2304EDE5446C24B6");
		byte[] message =  HexTool.getBytes("A101000051554F54120B0A1ACE7609ED67B3A4A58F97C1C7F6637E61196134D027E0044AE8C569DE2304EDE5446C24B6");

		byte[] signature =  HexTool.getBytes("36D28FE59D9CCBDB4AFEC02E866DD03913E22A1D2287F7DCCD4E24AB5CCF763E58F2AA400316F78BAB39F56CC0E45681BB21980D93E9655092BD0535FA9247C9204AAA1FFAD0006BD23DC8ADFDE5DE8C8C6ADA1F3EFA798BBC2731FCDA5D5EF017B8C22DCDE95C6FEB5F0253C89E63808CC0FC0A77F301CC444E883EE379E64DC43FE3B1AB6BCC98CB58D1525751E035C113884A173411B138CD24D646B6A6A7BC386B125C00BE4C14E08C569DA868D8E397F52FC0423A55135B3451482969E9272587961FB8878370EFDD49C7AD9D349C92BC1515CCAFBEAE21FEDF2AD625998E6E7B91EC3CFF4177F0D8B7585B0825FB263C236738DA88F0FAB133D0481705");
	
		System.out.println("pubKey    : " + HexTool.getHexString(pubKey));
		System.out.println("message   : " + HexTool.getHexString(message));
		System.out.println("signature : " + HexTool.getHexString(signature));
		
		try {
			boolean rc = SignatureTool.validate(pubKey, message, signature);
			
			if (rc == false) {
				//System.out.println("BAD SIGNATURE :-)");
			} else {
				System.out.println(":-(");
				fail("validation Success with BAD data");	
			}
		} catch (Exception e) {
			e.printStackTrace();
			fail("Exception Error");
		}
	}
	
	
	
	
	
	/**
	 * J Quote1
	 *   DEBUG [main] (com.ibm.trl.tcg.pts.integrity.VerificationResult:812) -   pubKey    : 00717a67aad618a7d6a51efe46cc7c3c23967bd0da83bc1745407b1cdadd8ac43a1dfaf87d7bc0a19ccfbbc1218c10184bfcc35e9b080c46ece5ba02cbc72de1ec7b2b9fcf399b10eb7f910db64f0ca4340959d4fe753a8eb9797251a2c7884903f6beb4fbf2e188e389807315860abc8c74cfb50dd0b6f85e052b7c62eded22d7795e25365c8915f658e97e3fed7ce30d3a295a61be20427b3e0705b749362b8183803c0482ccb276d486b9d7793fca99e9284433f7fc1512f94a9c8f0742416aa00f54683c03c131f9c333d26ec933e13e300d87bf4914659d5f0a1298a34bc75c41dd832d90e8380589e22f0363322f2e256f2cc28259c3079a08384cc6080f
   DEBUG [main] (com.ibm.trl.tcg.pts.integrity.VerificationResult:813) -   message   : 0101000051554f540101000051554f54120b0a1ace7609ed67b3a4a50000000000000000000000000000000000000000
   DEBUG [main] (com.ibm.trl.tcg.pts.integrity.VerificationResult:814) -   signature : 6af6fc7c8f30051ad2269955a0566b70430300864f0be102f3c1708d30c46dde7b0fd4d70ca7d2b39d18a0713b6490abb17f0f903a8031208d9294e13a94c252cc096eacea3b1861c146a711196e332f7e481ef3c4a7218158edf3623c02215aca8e22b2d47130d53abb8333357b12f04628d239efffef0477c84c2fd898ea7adfc2225eccd7ebe1f97e05fbc749c917d82fdb508a2c1a4ba154c763383cf128ed6e722f179a0db617a14e2a279df01008f5fb83153f036d421c3cbe1ce9646699632a600a0b510fdd98962be0692fa58f029e39014ed59eb67d70fe2e4b1d019e685b626d598f5c131df957f4c86574c99c542ab1cbfc0fc20789714cd0cd63
 
	 */
	/*
	public void test004() {
		byte[] pubKey = HexTool.getBytes("00717a67aad618a7d6a51efe46cc7c3c23967bd0da83bc1745407b1cdadd8ac43a1dfaf87d7bc0a19ccfbbc1218c10184bfcc35e9b080c46ece5ba02cbc72de1ec7b2b9fcf399b10eb7f910db64f0ca4340959d4fe753a8eb9797251a2c7884903f6beb4fbf2e188e389807315860abc8c74cfb50dd0b6f85e052b7c62eded22d7795e25365c8915f658e97e3fed7ce30d3a295a61be20427b3e0705b749362b8183803c0482ccb276d486b9d7793fca99e9284433f7fc1512f94a9c8f0742416aa00f54683c03c131f9c333d26ec933e13e300d87bf4914659d5f0a1298a34bc75c41dd832d90e8380589e22f0363322f2e256f2cc28259c3079a08384cc6080f");
		byte[] message =  HexTool.getBytes("0101000051554f540101000051554f54120b0a1ace7609ed67b3a4a50000000000000000000000000000000000000000");
		byte[] signature =  HexTool.getBytes("6af6fc7c8f30051ad2269955a0566b70430300864f0be102f3c1708d30c46dde7b0fd4d70ca7d2b39d18a0713b6490abb17f0f903a8031208d9294e13a94c252cc096eacea3b1861c146a711196e332f7e481ef3c4a7218158edf3623c02215aca8e22b2d47130d53abb8333357b12f04628d239efffef0477c84c2fd898ea7adfc2225eccd7ebe1f97e05fbc749c917d82fdb508a2c1a4ba154c763383cf128ed6e722f179a0db617a14e2a279df01008f5fb83153f036d421c3cbe1ce9646699632a600a0b510fdd98962be0692fa58f029e39014ed59eb67d70fe2e4b1d019e685b626d598f5c131df957f4c86574c99c542ab1cbfc0fc20789714cd0cd63");
	
		System.out.println("pubKey    : " + HexTool.getHexString(pubKey));
		System.out.println("message   : " + HexTool.getHexString(message));
		System.out.println("signature : " + HexTool.getHexString(signature));
		
		try {
			boolean rc = SignatureTool.validate(pubKey, message, signature);
			
			if (rc == false) {
				System.out.println("BAD SIGNATURE :-(");
				fail("validation  Error");			
			} else {
				System.out.println(":-)");
			}
		} catch (Exception e) {
			e.printStackTrace();
			fail("Exception Error");
		}
	}
	*/
}
