/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2010
 *
 */
package com.ibm.trl.tcg.pts.engine;

import com.ibm.trl.tcg.pts.tools.HexTool;
import junit.framework.TestCase;

/**
 * 
 * 
 * 
 * 
 * @author Seiji Munetoh (munetoh@users.sourceforge.jp)
 *
 */
public class EventLinuxTCBTest extends TestCase {

	
	public void testCheckImaAggregateNG() {

		System.out.println("--- checkImaAggregateNG ----------------------------------------------------------");
	
		EventLinuxTCB elt = new EventLinuxTCB();
		PlatformProperties properties = new PlatformProperties();
		String stateName = ""; 
		//Event event = new Event();

		String []pcrs = {
				"j7/z7OqcVMjRxCz+qT1r8BvzQFs=",
				"D6pQ8C1suACUSaRWN4QFejyQB4E=",
				"fYyNdXW8EfGWlsBkSirkAXEnDdc=",
				"Oj94DxGktJlp/KqAzW45V8M7InU=",
				"ZEc1Hpo9wqvjQd8PPMRS0aLhnjg=",
				"L2wBAWX62a9Hdt9vDJklaL/KvBg=",
				"WF5XnkiZf+6O/SCDDGqEHrNTxig=",
				"Oj94DxGktJlp/KqAzW45V8M7InU=",
				"8MGfID0pA6+kCMP3HNEmDq9B1IQ="
		};
		
		// Prop - set BIOS PCRs	
		for (int i=0;i<8;i++) {
			//PlatformProperty p = new PlatformProperty();
			String pname = "tpm.pcr." + i;
			//p.set(pname, pcrs[i]);
			properties.setProperty(pname, pcrs[i]);
		}
		properties.printProperties();
		
		// Event - set eventlog
		int pcrindex = 10;
		long type = 0; 
		byte[] digest = HexTool.getBytes("8b01230efa529b2cfc6f49b0801848b87723a40e");
		byte[] eventdata = HexTool.getBytes("dd1c47a20412466fea7079785355fc85aabbc7d8626f6f745f616767726567617465");
		//event.set(pcrindex, type, digest, eventdata);
		Event event = new Event(pcrindex, type, digest, eventdata);
		
		try {
			boolean rc = elt.checkImaAggregateNG(properties,stateName,event);
			if (rc == false) {
				fail("Check IMA aggrigate was failed");
			}
		} catch (Exception e) {
			e.printStackTrace();
			fail("Error");
		}
	}	
}
