/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2011
 *
 */

package com.ibm.trl.tcg.pts.verifier.gui;

import javax.swing.SwingUtilities;
//import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JFrame;
import java.awt.Dimension;

import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

import java.awt.Color;
import java.awt.Component;
//import java.awt.Container;
import java.awt.Point;
//import java.awt.ScrollPane;
//import java.awt.Panel;
//import java.awt.GridBagLayout;
//import java.awt.Button;
import javax.swing.JScrollPane;
import javax.swing.JTable;
//import java.awt.CardLayout;
import java.awt.GridLayout;
import javax.swing.JTextField;
//import java.awt.FlowLayout;
//import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
//import javax.swing.table.DefaultTableModel;
//import javax.swing.table.TableModel;

//import com.ibm.trl.tcg.pts.engine.Event;
import com.ibm.trl.tcg.pts.engine.IntegrityProperties;
//import com.ibm.trl.tcg.pts.eventlog.EventSet;
//import com.ibm.trl.tcg.pts.integrity.IntegrityReport;
//import com.ibm.trl.tcg.pts.tools.HexTool;
import com.ibm.trl.tcg.pts.verifier.Target;
import com.ibm.trl.tcg.pts.verifier.TargetList;
import com.jcraft.jsch.JSchException;

import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.UUID;
import java.util.Vector;

import javax.swing.JLabel;
//import javax.swing.JCheckBox;
//import javax.swing.JDialog;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Swing GUI
 * 
 * 
 * @author Seiji Munetoh (munetoh@users.sourceforge.jp)
 *
 */
public class Swing extends JFrame {
	/* Logger */
	private Log log = LogFactory.getLog(this.getClass());
	
	private static final long serialVersionUID = 1L;
	
	private static TargetList _tl = null;

	/*************************************************************************/
	/* Menu                                                                  */
	/*************************************************************************/
	private JMenuBar jJMenuBar = null;

	private JMenu jMenuFile = null;	
	private JMenuItem jMenuItemPreferences = null;
	private JMenuItem jMenuItemImport = null;
	private JMenuItem jMenuItemExport = null;
	private JMenuItem jMenuItemExit = null;

	private JMenu jMenuTarget = null;
	private JMenuItem jMenuItemAddTarget = null;
	private JMenuItem jMenuItemDeleteTarget = null;
	
	private JMenu jMenuAttestation = null;
	private JMenuItem jMenuItemValidateAll = null;
	private JMenuItem jMenuItemValidateSelected = null;
	
	private JMenu jMenuHelp = null;
	private JMenuItem jMenuItemAbout = null;

	/**
	 * This method initializes jJMenuBar	
	 * 	
	 * @return javax.swing.JMenuBar	
	 */
	private JMenuBar getJJMenuBar() {
		if (jJMenuBar == null) {
			jJMenuBar = new JMenuBar();
			jJMenuBar.add(getJMenuFile());
			jJMenuBar.add(getJMenuTarget());
			jJMenuBar.add(getJMenuAttestation());
			jJMenuBar.add(getJMenuHelp());
		}
		return jJMenuBar;
	}

	/**
	 * This method initializes jMenuFile	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getJMenuFile() {
		if (jMenuFile == null) {
			jMenuFile = new JMenu();
			jMenuFile.setText("File");
			//jMenuFile.add(getJMenuItemPreferences());
			//jMenuFile.add(getJMenuItemImport());
			//jMenuFile.add(getJMenuItemExport());
			jMenuFile.add(getJMenuItemExit());
		}
		return jMenuFile;
	}

	/**
	 * This method initializes jMenuItemImport	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemImport() {
		if (jMenuItemImport == null) {
			jMenuItemImport = new JMenuItem();
			jMenuItemImport.setText("Import");
		}
		return jMenuItemImport;
	}

	/**
	 * This method initializes jMenuItemExport	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemExport() {
		if (jMenuItemExport == null) {
			jMenuItemExport = new JMenuItem();
			jMenuItemExport.setText("Export");
		}
		return jMenuItemExport;
	}

	/**
	 * This method initializes jMenuItemExit	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemExit() {
		if (jMenuItemExit == null) {
			jMenuItemExit = new JMenuItem();
			jMenuItemExit.setText("Exit");
			jMenuItemExit.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					System.exit(0);
				}
			});
		}
		return jMenuItemExit;
	}
	/**
	 * This method initializes jMenuAttestation	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getJMenuTarget() {
		if (jMenuTarget == null) {
			jMenuTarget = new JMenu();
			jMenuTarget.setText("Target");
			jMenuTarget.add(getJMenuItemAddTarget());
			jMenuTarget.add(getJMenuItemDeleteTarget());
		}
		return jMenuTarget;
	}
	/**
	 * This method initializes jMenuItemDeleteTarget	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemDeleteTarget() {
		if (jMenuItemDeleteTarget == null) {
			jMenuItemDeleteTarget = new JMenuItem();
			jMenuItemDeleteTarget.setText("Delate Selected Targets");
			jMenuItemDeleteTarget.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					/* Validate selected items  */
					TargetListTableModel tm = (TargetListTableModel) jTableTargetList.getModel();
					tm.deleteSelectedTarget();
					
					/* refresh the table */ 
					tm.fireTableStructureChanged();
				}
			});
		}
		return jMenuItemDeleteTarget;
	}

	/**
	 * This method initializes jMenuItemAddTarget	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemAddTarget() {
		if (jMenuItemAddTarget == null) {
			jMenuItemAddTarget = new JMenuItem();
			jMenuItemAddTarget.setText("Add Target");
			jMenuItemAddTarget.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					/* Open Dialog of add new target(collector)  */
					
					JPanel panel = new JPanel();
					BoxLayout layout = new BoxLayout(panel, BoxLayout.Y_AXIS);
					panel.setLayout(layout);

					panel.add(new JLabel("Hostname"));
					JTextField text1 = new JTextField();
					panel.add(text1);
					panel.add(new JLabel("SSH username"));
					JTextField text2 = new JTextField();
					text2.setText(System.getProperty("user.name"));
					panel.add(text2);
					panel.add(new JLabel("SSH port"));
					JTextField text3 = new JTextField();
					text3.setText("22");
					panel.add(text3);

					JOptionPane.showConfirmDialog(
						null,
						panel,
						"Add New Target",
						JOptionPane.OK_CANCEL_OPTION,
						JOptionPane.QUESTION_MESSAGE);

					String hostname = text1.getText();
					String sshUsername = text2.getText();
					int sshPort = Integer.parseInt(text3.getText());
										
					/* add target */
					if ((hostname == null) || (hostname == "")) {
						log.error("Hostname is null");
					} else {
						log.info("Add Hostname :" + hostname);
						try {
							Target t = new Target(_tl.getConfigDir() , hostname, sshUsername, sshPort);
							/* enroll */
							t.enroll(1);
							/* refresh TargetList */
							_tl.refresh();
						} catch (Exception e1) {
							log.error("add Target " + sshUsername + "@" + hostname + " was failed");
							// TODO show Dialog
							e1.printStackTrace();
						}
					}
					
					/* refresh the table */
					
					TargetListTableModel tm = (TargetListTableModel) jTableTargetList.getModel();
					tm.refreshSelectFlag();
					tm.fireTableStructureChanged();
					
				}
			});
		}
		return jMenuItemAddTarget;
	}

	/**
	 * This method initializes jMenuAttestation	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getJMenuAttestation() {
		if (jMenuAttestation == null) {
			jMenuAttestation = new JMenu();
			jMenuAttestation.setText("Attestation");
			jMenuAttestation.add(getJMenuItemAll());
			jMenuAttestation.add(getJMenuItemValidateSelected());
		}
		return jMenuAttestation;
	}

	/**
	 * This method initializes jMenuItemAll	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemAll() {
		if (jMenuItemValidateAll == null) {
			jMenuItemValidateAll = new JMenuItem();
			jMenuItemValidateAll.setText("Validate All Target");
			jMenuItemValidateAll.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					/* Validate selected items  */
					TargetListTableModel tm = (TargetListTableModel) jTableTargetList.getModel();
					tm.validateAllTargets();
					
					/* refresh the table */ 
					tm.fireTableStructureChanged();
				}
			});
		}
		
		
		
		return jMenuItemValidateAll;
	}
	
	/**
	 * This method initializes jMenuItemAll	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemValidateSelected() {
		if (jMenuItemValidateSelected == null) {
			jMenuItemValidateSelected = new JMenuItem();
			jMenuItemValidateSelected.setText("Validate Selected Target");
			jMenuItemValidateSelected.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					/* Validate selected items  */
					TargetListTableModel tm = (TargetListTableModel) jTableTargetList.getModel();
					tm.validateSelectedTarget();
					
					/* refresh the table */ 
					tm.fireTableStructureChanged();
				}
			});
		}
		return jMenuItemValidateSelected;
	}
	/**
	 * This method initializes jMenuItemPreferences	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemPreferences() {
		if (jMenuItemPreferences == null) {
			jMenuItemPreferences = new JMenuItem();
			jMenuItemPreferences.setText("Preferences");
		}
		return jMenuItemPreferences;
	}

	/**
	 * This method initializes jMenuHelp	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getJMenuHelp() {
		if (jMenuHelp == null) {
			jMenuHelp = new JMenu();
			jMenuHelp.setText("Help");
			jMenuHelp.add(getJMenuItemAbout());
		}
		return jMenuHelp;
	}
	
	
	/**
	 * This method initializes jMenuItemAbout	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemAbout() {
		if (jMenuItemAbout == null) {
			jMenuItemAbout = new JMenuItem();
			jMenuItemAbout.setText("About OpenPTS");
			jMenuItemAbout.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					/* Open Dialog   */
					JOptionPane.showMessageDialog(
							null , 
							"OpenPTS version 0.2.4", 
							"About OpenPTS" , 
							JOptionPane.INFORMATION_MESSAGE
						);
				}
			});
		}
		return jMenuItemAbout;
	}

	/*************************************************************************/
	/* Main panel (target Table)                                             */
	/*************************************************************************/
	private JPanel jPanelTargetList = null;
	private JScrollPane jScrollPaneTargetList = null;
	private JTable jTableTargetList = null;
	
	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelTargetList() {
		if (jPanelTargetList == null) {
			GridLayout gridLayout = new GridLayout();
			gridLayout.setRows(1);
			jPanelTargetList = new JPanel();
			jPanelTargetList.setLayout(gridLayout);
			jPanelTargetList.add(getJScrollPaneTargetList(), null);
		}
		return jPanelTargetList;
	}

	/**
	 * This method initializes jScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPaneTargetList() {
		if (jScrollPaneTargetList == null) {
			jScrollPaneTargetList = new JScrollPane();
			jScrollPaneTargetList.setViewportView(getJTableTargetList());
		}
		return jScrollPaneTargetList;
	}

	/**
	 * This method initializes jTable	
	 * 	
	 * @return javax.swing.JTable	
	 */
	private JTable getJTableTargetList() {
		if (jTableTargetList == null) {
			jTableTargetList = new JTable(new TargetListTableModel());
			jTableTargetList.setDefaultRenderer(Object.class, new TargetListRenderer());
			jTableTargetList.addMouseListener(new PopupListenerTarget());

		}
		return jTableTargetList;
	}

	
	
	
	
	
	/*************************************************************************/
	/* Target Table => PopUp                                   */
	/*************************************************************************/
	
	public class PopupListenerTarget extends MouseAdapter {
		private int _row;

		public void mousePressed(MouseEvent e) {
			showPopupTarget(e);
		}

		public void mouseReleased(MouseEvent e) {
			showPopupTarget(e);
		}


	    
	    // UUID  => 100-nanosecond units since midnight, October 15, 1582 UTC.
	    // Timestamp  => milliseconds since January 1, 1970, 00:00:00 GMT
	    // UUID epoch 1582-10-15 00:00:00 and the Unix epoch 1970-01-01 00:00:00.

	    public String getTimeString (UUID uuid) {
	    	String TIME_FORMAT = "yyyy/MM/dd H:m:s Z";
	    	long t1 = uuid.timestamp();
	    	long t2 = (t1 - 0x01b21dd213814000L) / 10000;
	    	
	    	Timestamp timestamp = new Timestamp(t2); 
	    	
	    	String s = new SimpleDateFormat(TIME_FORMAT).format(timestamp);
			return s;
	    }


		/*************************************************************************/
		/* Target Table => popUp => Target  tab                                   */
		/*************************************************************************/
	    /**
	     * Target Panel
	     * 
	     * 
	     * @return
	     */
	    protected JComponent getTargetPanel(Target t) {
	        JPanel panel = new JPanel(false);
	        
			//BoxLayout layout = new BoxLayout(panel, BoxLayout.Y_AXIS);
			//panel.setLayout(new GridLayout(5, 2));
	        // do not use layout manager
	        //      w1     w2
	        // h1  name   value
	        panel.setLayout(null);
	        
			//Target t = _tl.getTarget(_row);
	        int lines = 15;
	        int height = 18;
			
			JLabel label[][];
			label = new JLabel[lines][2];
			for( int i=0;i<lines;i++) {  // rpw
				label[i][0] = new JLabel();
				label[i][0].setBounds(10,  2 + i*height, 150, 20);  // x, y, width, height
				panel.add(label[i][0]);
				label[i][1] = new JLabel();
				label[i][1].setBounds(160, 2 + i*height, 500, 20);  // x, y, width, height
				panel.add(label[i][1]);
			}
			
			label[0][0].setText("Hostname");
			label[0][1].setText(t._hostname);
			
			label[1][0].setText("SSH username");
			label[1][1].setText(t._ssh_username);
			
			label[2][0].setText("SSH port");
			label[2][1].setText(Integer.toString(t._ssh_port));
			
			label[3][0].setText("Target(Collector) UUID");
			label[3][1].setText(t._uuid.toString());
			label[4][0].setText("  timestamp");
			label[4][1].setText(getTimeString(t._uuid));
			
			label[5][0].setText("Manifest UUID");
			label[5][1].setText(t._rm_uuid.toString());
			label[6][0].setText("  timestamp");
			label[6][1].setText(getTimeString(t._rm_uuid));	
			
			label[7][0].setText("Integrity Report UUID");
			label[8][0].setText("  timestamp");
			if (t._ir_uuid != null) {
				label[7][1].setText(t._ir_uuid.toString());
				label[8][1].setText(getTimeString(t._ir_uuid));	
			} else {
				label[7][1].setText("N/A");
				label[8][1].setText("N/A");	
			}

			// TODO get name from manifest
			label[9][0].setText("Platform");
			label[9][1].setText("N/A");
			label[10][0].setText("TPM");
			label[10][1].setText("N/A");
			label[11][0].setText("BIOS(SRTM)");
			label[11][1].setText("N/A");
			label[12][0].setText("DRTM");
			label[12][1].setText("N/A");
			label[13][0].setText("OS");
			label[13][1].setText("N/A");
			label[14][0].setText("IMA");
			label[14][1].setText("N/A");
			
			panel.setPreferredSize(new Dimension(600, 100));
	        return panel;
	    }
		/*************************************************************************/
		/* Target Table => popUp => Integrity tab                               */
		/*************************************************************************/
	    private JPanel jPanelIntegrityList = null;
		private JScrollPane jScrollPaneIntegrityList = null;
		private JTable jTableIntegrityList = null;
				
		/*************************************************************************/
		/* Target Table => popUp => Properties tab                               */
		/*************************************************************************/
	    private JPanel jPanelPropertiesList = null;
		private JScrollPane jScrollPanePropertiesList = null;
		private JTable jTablePropertiesList = null;
		
	    /*************************************************************************/
		/* Target Table => popUp                                */
		/*************************************************************************/
		
		/**
		 * 
		 * Right Mouse Click on the target at table -> Popup menu
		 *   Validate
		 *   Properties -> Property Dialog (tabbed pane)
		 *   
		 * @param e
		 */
		private void showPopupTarget(MouseEvent e) {
		    if (e.isPopupTrigger()) {
		    	Point p = e.getPoint();
		    	_row = jTableTargetList.rowAtPoint(p);  // TODO global 
		    	
		    	JPopupMenu popupMenu = new JPopupMenu();
		    	
		    	JMenuItem menuItemValidate = new JMenuItem("Validate");
		    	menuItemValidate.addActionListener(new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent e) {
						log.debug("Validate Target[" + _row + "]");
						
						/* Validate selected items  */
						TargetListTableModel tm = (TargetListTableModel) jTableTargetList.getModel();
						tm.validateTargets(_row);
						
						/* refresh the table */ 
						tm.fireTableStructureChanged();
					}
				});
		    	
		    	JMenuItem menuItemProperties = new JMenuItem("Properties");
		    	menuItemProperties.addActionListener(new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent e) {
						log.debug("Show Properties of Target[" + _row + "]");
						Target t = _tl.getTarget(_row);
				        JTabbedPane tabbedPane = new JTabbedPane();
		
				        /* Target */
				        JComponent panel1 = getTargetPanel(t);
				        tabbedPane.addTab("Target", null, panel1,null);
				        tabbedPane.setMnemonicAt(0, KeyEvent.VK_1);
				        
				        /* Manifest  */
				        JComponent panel2 = getIntegrityPanel(t); 
				        tabbedPane.addTab("Integrity", null, panel2,
				                "TBD");
				        tabbedPane.setMnemonicAt(1, KeyEvent.VK_2);
				        
				        /* Property Policy  */
				        JComponent panel3 = getPropertiesPanel(t); // makeTextPanel("Policy");
				        tabbedPane.addTab("Properties and Policy", null, panel3, null);
				        tabbedPane.setMnemonicAt(2, KeyEvent.VK_3);
				        
				        
				        
						//int rc = 
						JOptionPane.showOptionDialog(
							null,
							tabbedPane,
							"Properties",
							JOptionPane.OK_CANCEL_OPTION,
							JOptionPane.INFORMATION_MESSAGE, 
							null, null, null);
		
						
					}
				});
		
		    	JMenuItem menuItemDelete = new JMenuItem("Delete");
		    	menuItemDelete.addActionListener(new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent e) {
						log.debug("Delete Target[" + _row + "]");
						
						/* Delete selected items  */
						TargetListTableModel tm = (TargetListTableModel) jTableTargetList.getModel();
						tm.deleteTarget(_row);
						
						/* refresh the table */ 
						tm.fireTableStructureChanged();
					}
				});
		    	
		        popupMenu.add(menuItemValidate);
		        popupMenu.add(menuItemProperties);
		        popupMenu.add(menuItemDelete);
		        
		    	popupMenu.show(e.getComponent(), e.getX(), e.getY());
		    }
		}

		/****************************************************************************/
		/*  Integrity  Panel  */
		/****************************************************************************/
		protected JComponent getIntegrityPanel(Target t) {
			GridLayout gridLayout = new GridLayout();
			gridLayout.setRows(1);
			jPanelIntegrityList = new JPanel();
			jPanelIntegrityList.setLayout(gridLayout);
			//jPanelIntegrityList.setPreferredSize(new Dimension(800, 500));
			jPanelIntegrityList.add(getJScrollPaneIntegrityList(t), null);
			
			
			
			return jPanelIntegrityList;
	    }
		/**
		 * This method initializes jScrollPane	
		 * 	
		 * @return javax.swing.JScrollPane	
		 */
		private JScrollPane getJScrollPaneIntegrityList(Target t) {
			jScrollPaneIntegrityList = new JScrollPane();
			jScrollPaneIntegrityList.setViewportView(getJTableIntegrityList(t));
			return jScrollPaneIntegrityList;
		}

		/**
		 * This method initializes jTable	
		 * 	
		 * @return javax.swing.JTable	
		 */
		private JTable getJTableIntegrityList(Target t) {
			jTableIntegrityList = new JTable(new IntegrityListTableModel(t));
			jTableIntegrityList.setDefaultRenderer(Object.class, new IntegrityListRenderer());
			//jTableIntegrityList.setPreferredSize(new Dimension(800, 500));
			jTableIntegrityList.getColumnModel().getColumn(0).setPreferredWidth(40); // index
			jTableIntegrityList.getColumnModel().getColumn(1).setPreferredWidth(20); // pcr
			jTableIntegrityList.getColumnModel().getColumn(2).setPreferredWidth(20); // type
			jTableIntegrityList.getColumnModel().getColumn(3).setPreferredWidth(200); // digest
			jTableIntegrityList.getColumnModel().getColumn(4).setPreferredWidth(200); // 
			//jTableIntegrityList.getColumnModel().getColumn(6).setPreferredWidth(10);
			jTableIntegrityList.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
			return jTableIntegrityList;
		}
		
		/****************************************************************************/
		/*  Properties Panel  */
		/****************************************************************************/
		protected JComponent getPropertiesPanel(Target t) {
			GridLayout gridLayout = new GridLayout();
			gridLayout.setRows(1);
			jPanelPropertiesList = new JPanel();
			jPanelPropertiesList.setLayout(gridLayout);
			jPanelPropertiesList.add(getJScrollPanePropertiesList(t), null);
			return jPanelPropertiesList;
	    }
	    
		/**
		 * This method initializes jScrollPane	
		 * 	
		 * @return javax.swing.JScrollPane	
		 */
		private JScrollPane getJScrollPanePropertiesList(Target t) {
			//if (jScrollPanePropertiesList == null) {
				jScrollPanePropertiesList = new JScrollPane();
				jScrollPanePropertiesList.setViewportView(getJTablePropertiesList(t));
			//}
			return jScrollPanePropertiesList;
		}

		/**
		 * This method initializes jTable	
		 * 	
		 * @return javax.swing.JTable	
		 */
		private JTable getJTablePropertiesList(Target t) {
			//if (jTablePropertiesList == null) {
				jTablePropertiesList = new JTable(new PropertiesListTableModel(t));
				jTablePropertiesList.setDefaultRenderer(Object.class, new PropertyListRenderer());
				// jTablePropertiesList.addMouseListener(new PopupListener());
			//}
			return jTablePropertiesList;
		}
	}


	
	
	public class TargetListRenderer extends DefaultTableCellRenderer {
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		private final Color unknownColor = new Color(128, 128, 128);
		private final Color invalidColor = new Color(255, 0, 0);
		private final Color validColor = new Color(0, 255, 0);
		
		@Override public Component getTableCellRendererComponent(JTable table, Object value,
                           boolean isSelected, boolean hasFocus,
                           int row, int column) {
	    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
	    if(isSelected) {
		      setForeground(table.getSelectionForeground());
		      setBackground(table.getSelectionBackground());
	    }else{
		      setForeground(table.getForeground());
		      //setBackground((row%2==0)?evenColor:table.getBackground());
		      Target t = _tl.getTarget(row);
		      String integrity = t.getIntegrity();
		      if (integrity.equals("VALID")) {
		    	  setBackground(validColor);
		      } else if (integrity.equals("INVALID")) {
		    	  setBackground(invalidColor);
		      } else if (integrity.equals("UNVERIFIED")) {
		    	  setBackground(unknownColor);
		      } else {
		    	  setBackground(table.getBackground());
		      }
	    }
	    setHorizontalAlignment((value instanceof Number)?RIGHT:LEFT);
	    return this;
	  }
	}
	
	/**
	 * Target List
	 * 
	 * @author munetoh
	 *
	 */
	public class TargetListTableModel extends AbstractTableModel {
		private String [] colNames = {"Select", "Hostname", "Integrity", "Comments"};
		private Object flag[];
		private int _num;

		private static final long serialVersionUID = 1L;

		public TargetListTableModel() {
			refreshSelectFlag();
		}



		private void refreshSelectFlag() {
			_num = _tl.size();
			/* select flag */
			flag = new Boolean[_num];
			for (int i = 0; i < _num; i++) {
				flag[i] = false;
			}
		}
		
		public void deleteSelectedTarget() {
			for (int i = 0; i < _num; i++) {
				if ((Boolean)flag[i] == true) {
					log.debug("Deleyte Target[" + i + "]");
					try {
						_tl.deleteTarget(i);
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					fireTableCellUpdated(i, 2); // integrity
				}
			}
		}



		public void deleteTarget(int i) {
			log.debug("Delete Target[" + i + "]");
			try {
				_tl.deleteTarget(i);
			} catch (Exception e) {
				e.printStackTrace();
			}
			fireTableCellUpdated(i, 2); // integrity
		}
		
		public void validateTargets(int i) {
			log.debug("Validate Target[" + i + "]");
			try {
				Target t = _tl.getTarget(i);
				t.verify();
			} catch (Exception e) {
				e.printStackTrace();
			}
			fireTableCellUpdated(i, 2); // integrity
		}



		private void validateSelectedTarget() {
			for (int i = 0; i < _num; i++) {
				if ((Boolean)flag[i] == true) {
					log.debug("Validate Target[" + i + "]");
					try {
						Target t = _tl.getTarget(i);
						t.verify();
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					fireTableCellUpdated(i, 2); // integrity
				}
			}
		}
		
		private void validateAllTargets() {
			for (int i = 0; i < _num; i++) {
				log.debug("Validate Target[" + i + "]");
				try {
					Target t = _tl.getTarget(i);
					t.verify();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				fireTableCellUpdated(i, 2); // integrity
			}
		}
		
		@Override
		public int getColumnCount() {
			return colNames.length;
		}
		public String getColumnName(int col) {
			return colNames[col];
		}

		@Override
		public int getRowCount() {
			// TODO Auto-generated method stub
			return _tl.size();
		}

		@Override
		public Object getValueAt(int row, int col) {
			Target t = _tl.getTarget(row);
			if (col == 0) {
				/* select */
				return flag[row];
			} else if (col == 1) {
				/* hostname */
				return t._hostname;
			} else if (col == 2) {
				/* integrity */
				return t.getIntegrity();
			} else if (col == 3) {
				/* check */
				return t.getRemediation();
			}
			return "TBD";
		}
		
		public Class<? extends Object> getColumnClass(int c) {
			return getValueAt(0,c).getClass();
		}
		
		public boolean isCellEditable(int row, int col) {
			if (col == 0) return true;
			else return false;
		}
		
		public void setValueAt(Object value, int row, int col) {
			if (col == 0) {
				flag[row] = (Boolean) value;
			}
			fireTableCellUpdated(row, col);
		}
	}

	/*****************************************************************************/
	/* Integrity Table                                                            */
	/*****************************************************************************/
	
	
	public class IntegrityListRenderer extends DefaultTableCellRenderer {
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		//private final Color unknownColor = new Color(128, 128, 128);
		private final Color invalidColor = new Color(255, 0, 0);
		private final Color validColor = new Color(0, 255, 0);
		
		@Override public Component getTableCellRendererComponent(JTable table, Object value,
                           boolean isSelected, boolean hasFocus,
                           int row, int column) {
	    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
	    if(isSelected) {
		      setForeground(table.getSelectionForeground());
		      setBackground(table.getSelectionBackground());
	    }else{
		      setForeground(table.getForeground());

		      String status = (String) table.getValueAt(row, 5);
		      if (status.equals("VALID")) {
		    	  setBackground(validColor);
		      } else if (status.equals("INVALID")) {
		    	  setBackground(invalidColor);
		      } else if (status.equals("MISSING")) {
		    	  setBackground(invalidColor);
		      } else {
		    	  setBackground(table.getBackground());
		      }
	    }
	    setHorizontalAlignment((value instanceof Number)?RIGHT:LEFT);
	    return this;
	  }
	}
	/**
	 * Integrity List
	 * 
	 * @author munetoh
	 *
	 */
	public class IntegrityListTableModel extends AbstractTableModel {
		private String [] colNames = {"index", "pcr", "type", "digest", "eventdata", "status"};
		private Target _target;
		private IntegrityProperties _ip = null;
		private int _num;
		//private Vector<Event> _el;

		private static final long serialVersionUID = 1L;

		public IntegrityListTableModel(Target t) {
			_target = t;
			try {
				_ip = _target.loadIntegrityProperties();
				_num = _ip.getEventNum();
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		
		@Override
		public int getColumnCount() {
			return colNames.length;
		}
		public String getColumnName(int col) {
			return colNames[col];
		}

		@Override
		public int getRowCount() {
			return _num;
		}

		@Override
		public Object getValueAt(int row, int col) {
			// Event e = _el.get(row);
			if (col == 0) {
				/* name */
				return Integer.toString(row);  // index
			} else if (col == 1) {
				/* value */
				return _ip.getPcrIndexString(row); // pcr
			} else if (col == 2) {
				/* policy */
				return _ip.getEventTypeString(row); // type
			} else if (col == 3) {
				/* policy */
				return _ip.getDigestString(row); // digest in Hex
			} else if (col == 4) {
				/* policy */
				return _ip.getEventDataString(row); // eventdata
			} else if (col == 5) {
				/* policy */
				return _ip.getStatusString(row); // status // TODO VR set flag and keep the status?
			}
			
			return "TBD";
		}
		
		//public Class getColumnClass(int c) {
		//	return getValueAt(0,c).getClass();
		//}
		
		//public boolean isCellEditable(int row, int col) {
		//	//if (col == 0) return true;
		//	//else 
		//	return false;
		//}
		
		//public void setValueAt(Object value, int row, int col) {
		//	if (col == 0) {
		//		flag[row] = (Boolean) value;
		//	}
		//	fireTableCellUpdated(row, col);
		//}
	}
	/*****************************************************************************/
	/* Property Table                                                            */
	/*****************************************************************************/
	
	
	public class PropertyListRenderer extends DefaultTableCellRenderer {
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

		//private final Color unknownColor = new Color(128, 128, 128);
		private final Color invalidColor = new Color(255, 0, 0);
		private final Color validColor = new Color(0, 255, 0);
		
		@Override public Component getTableCellRendererComponent(JTable table, Object value,
                           boolean isSelected, boolean hasFocus,
                           int row, int column) {
	    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
	    if(isSelected) {
		      setForeground(table.getSelectionForeground());
		      setBackground(table.getSelectionBackground());
	    }else{
		      setForeground(table.getForeground());

		      String status = (String) table.getValueAt(row, 3);
		      if (status.equals("VALID")) {
		    	  setBackground(validColor);
		      } else if (status.equals("INVALID")) {
		    	  setBackground(invalidColor);
		      } else if (status.equals("MISSING")) {
		    	  setBackground(invalidColor);
		      } else {
		    	  setBackground(table.getBackground());
		      }
	    }
	    setHorizontalAlignment((value instanceof Number)?RIGHT:LEFT);
	    return this;
	  }
	}
	/**
	 * Properties List
	 * 
	 * @author munetoh
	 *
	 */
	public class PropertiesListTableModel extends AbstractTableModel {
		private String [] colNames = {"name", "actual value", "policy value", "status"};
		//private Object flag[];
		//private int _num;
		private Target _target;
		private Properties _prop;
		//private Enumeration<?> _prop_e;
		private Vector<String> _keys;
		private Properties _policy;
		private Properties _status;

		private static final long serialVersionUID = 1L;

		public PropertiesListTableModel(Target t) {
			_target = t;
			

			try {
				/* row items (= name) */
				_keys = new Vector<String>();
				_status = new Properties();
				
				/* Properties */
				_prop = new Properties();
				_prop.load(new FileInputStream(_target._prop_filename));
				
				/* fill names */
				Enumeration<?> e1 = _prop.propertyNames();
				while(e1.hasMoreElements()) {
					String key = (String) e1.nextElement();
					_keys.add(key);
					_status.setProperty(key, "DON'T CARE");
				}
				
				/* Policy */
				_policy = new Properties();
				_policy.load(new FileInputStream(_target._policy_filename));
				Enumeration<?> e2 = _policy.propertyNames();
				while(e2.hasMoreElements()) {
					String key = (String) e2.nextElement();
					String prop = _prop.getProperty(key);
					if ( prop != null) {
						/* Hit */
						String pol =  _policy.getProperty(key);
						if (pol.equals(prop)) _status.setProperty(key, "VALID");
						else                  _status.setProperty(key, "INVALID");
					} else {
						/* Miss */
						_keys.add(key);
						_status.setProperty(key, "MISSING");
					}
				}
				
				
			} catch (FileNotFoundException e) {
				// not verified yet => show Dialog?
				//e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		
		@Override
		public int getColumnCount() {
			return colNames.length;
		}
		public String getColumnName(int col) {
			return colNames[col];
		}

		@Override
		public int getRowCount() {
			// TODO Auto-generated method stub
			return _keys.size();
		}

		@Override
		public Object getValueAt(int row, int col) {
			
			if (col == 0) {
				/* name */
				return _keys.get(row);  // name
			} else if (col == 1) {
				/* value */
				return _prop.getProperty((String) _keys.get(row)); // value
			} else if (col == 2) {
				/* policy */
				return _policy.getProperty((String) _keys.get(row)); // value
			} else if (col == 3) {
				/* policy */
				return _status.getProperty((String) _keys.get(row)); // value
			}
			return "TBD";
		}
		
		//public Class getColumnClass(int c) {
		//	return getValueAt(0,c).getClass();
		//}
		
		//public boolean isCellEditable(int row, int col) {
		//	//if (col == 0) return true;
		//	//else 
		//	return false;
		//}
		
		//public void setValueAt(Object value, int row, int col) {
		//	if (col == 0) {
		//		flag[row] = (Boolean) value;
		//	}
		//	fireTableCellUpdated(row, col);
		//}
	}
	
	/*************************************************************************/
	/* Main                                                                  */
	/*************************************************************************/
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {

		SwingUtilities.invokeLater(new Runnable() {

			public void run() {
				/* check local */
				String dirname = System.getProperty("user.home") + File.separator +  ".openpts";	
				File config_dir = new File(dirname);
				
				try {
					/* if dir is missing => create new dir, and conf*/
					if ( config_dir.exists() == false ) {
						/* not initialized yet => ask */
						int rc = JOptionPane.showConfirmDialog(
								null,
								"Initialize the OpenPTS verifier?",
								"Confirmation",
								JOptionPane.YES_NO_OPTION);
						
						if (rc == JOptionPane.YES_OPTION){
							/* Initialize */
							/* get target list (also init openpts configs) */
							_tl = new TargetList(true);  // Force create
							if (_tl.isInitialized() == false) {
								System.exit(1);
							}
						} else {
							System.exit(1);
						}
					} else {
						/* initialized */
						_tl = new TargetList(false);
						if (_tl.isInitialized() == false) {
							System.exit(2);
						}
					}
				} catch (FileNotFoundException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (JSchException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
				/* fill TableModel */
				//tm = new DefaultTableModel(rowData, colNames);
				//tm = (TableModel) new TargetTableModel;
				
				
				Swing thisClass = new Swing();
				thisClass.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
				thisClass.setVisible(true);
				
			}
		});
	}

	/**
	 * This is the default constructor
	 */
	public Swing() {
		super();
		initialize();
	}

	
	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(640, 480);
		this.setContentPane(getJPanelTargetList());
		this.setJMenuBar(getJJMenuBar());
		this.setTitle("OpenPTS Verifier");
		this.setLocationRelativeTo(null);
	}

}  //  @jve:decl-index=0:visual-constraint="13,10"
