/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007, 2011
 *
 */
package com.ibm.trl.tcg.pts.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.util.zip.GZIPOutputStream;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;


// IBM JRE
//import org.apache.xml.serializer.OutputPropertiesFactory;
// SUN JRE
//import com.sun.org.apache.xml.internal.serializer.OutputPropertiesFactory;

import org.w3c.dom.Document;


/**
 * 
 * @author Seiji Munetoh (munetoh@users.sourceforge.jp)
 * 
 */
public class XmlTool {

	/**
	 * 
	 * @param filename
	 *            to write
	 * @param doc
	 * @param indent
	 *            format XML
	 * @throws Exception
	 */
	public static void saveToFile(String filename, Document doc, boolean indent)
			throws Exception {
		if (indent) {
			// try {
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer();
			transformer.setOutputProperty(
					javax.xml.transform.OutputKeys.ENCODING, "UTF-8");

			DOMSource source = new DOMSource(doc);
			File newXML = new File(filename + ".tmp");
			FileOutputStream os = new FileOutputStream(newXML);
			StreamResult result = new StreamResult(os);
			transformer.transform(source, result);

			/* format well */
			String xsltFilename = "../pvs/style.xslt";
			File xsltFile = new File(xsltFilename);
			if (xsltFile.isFile()) {
				//
				File inXml = new File(filename + ".tmp");
				File outXml = new File(filename);
				File xsl = new File("../pvs/style.xslt");

				TransformerFactory tf = TransformerFactory.newInstance();
				Source xslSource = new StreamSource(xsl);
				Transformer tfo = tf.newTransformer(xslSource);

				Source src = new StreamSource(inXml);
				Result res = new StreamResult(outXml);

				tfo.transform(src, res);
				// TODO close file, then delete
				// if (inXml.delete() == false) System.err.println("fail to
				// delete : " + inXml.getAbsoluteFile());
			} else {
				File inXml = new File(filename + ".tmp");
				File outXml = new File(filename);

				// Transformer
				//TransformerFactory tf = TransformerFactory.newInstance();
				Transformer tfo = transFactory.newTransformer();
				tfo.setOutputProperty(OutputKeys.INDENT, "yes");
				tfo.setOutputProperty(OutputKeys.METHOD, "xml");
				//tfo.setOutputProperty(
				//		OutputPropertiesFactory.S_KEY_INDENT_AMOUNT, "2");

				Source src = new StreamSource(inXml);
				Result res = new StreamResult(outXml);

				// outXml
				tfo.transform(src, res);
			}
		} else {
			// try {
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer();
			transformer.setOutputProperty(
					javax.xml.transform.OutputKeys.ENCODING, "UTF-8");
			DOMSource source = new DOMSource(doc);
			File newXML = new File(filename);
			FileOutputStream os = new FileOutputStream(newXML);
			StreamResult result = new StreamResult(os);
			transformer.transform(source, result);

		}

	}

	public static void print(Document result) {
		System.out.println(result.toString());
	}

	/**
	 * Document to message(base64)
	 * 
	 * @param doc
	 * @return
	 * @throws Exception
	 */
	public static String getBase64String(Document doc) throws Exception {
		/* doc to string */
		TransformerFactory transFactory = TransformerFactory.newInstance();
		Transformer transformer = transFactory.newTransformer();
		transformer.setOutputProperty(javax.xml.transform.OutputKeys.ENCODING,
				"UTF-8");
		DOMSource source = new DOMSource(doc);

		StringWriter writer = new StringWriter();

		transformer.transform(source, new StreamResult(writer));

		/* byte[] to Base64 */
		String base64 = Base64Tool.encode(writer.toString().getBytes());
		return base64;
	}

	/**
	 * 
	 * XML -> GZIP -> Base64
	 * 
	 * @param doc
	 * @return
	 * @throws Exception
	 */
	public static String getGipedBase64String(Document doc) throws Exception {
		/* doc to string */
		TransformerFactory transFactory = TransformerFactory.newInstance();
		Transformer transformer = transFactory.newTransformer();
		transformer.setOutputProperty(javax.xml.transform.OutputKeys.ENCODING,
				"UTF-8");
		DOMSource source = new DOMSource(doc);

		StringWriter writer = new StringWriter();

		transformer.transform(source, new StreamResult(writer));

		/* Gzip */
		ByteArrayOutputStream baos = new ByteArrayOutputStream(64000);
		GZIPOutputStream gos = new GZIPOutputStream(baos);
		gos.write(writer.toString().getBytes());

		/* byte[] to Base64 */
		// String base64 = Base64Tool.encode(writer.toString().getBytes());
		String base64 = Base64Tool.encode(baos.toByteArray());
		gos.finish();
		gos.close();
		baos.close();

		return base64;
	}

}
