/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007, 2011
 *
 */
package com.ibm.trl.tcg.pts.tools;

import java.io.UnsupportedEncodingException;

/**
 * 
 * @author Seiji Munetoh (munetoh@users.sourceforge.jp)
 *
 */
public class BlobTool {

	/**
	 * Big Endian
	 * 
	 * @param b
	 * @param offset
	 * @return
	 */
	public static int UINT32(byte b[], int offset) {
		int i;

		i = b[offset + 3] & 0xFF;
		i = i << 8;
		i += b[offset + 2] & 0xFF;
		i = i << 8;
		i += b[offset + 1] & 0xFF;
		i = i << 8;
		i += b[offset] & 0xFF;

		return i;
	}
	
	/**
	 * Little Endian
	 * @param b
	 * @param offset
	 * @return
	 */
	public static int UINT32_LE(byte b[], int offset) {
		int i;

		i = b[offset] & 0xFF;
		i = i << 8;
		i += b[offset + 1] & 0xFF;
		i = i << 8;
		i += b[offset + 2] & 0xFF;
		i = i << 8;
		i += b[offset + 3] & 0xFF;

		return i;
	}

	public static String getString(byte[] data, int offset, int size) {
		
		if (offset > data.length) {
			return null;
		}
		if (offset + size > data.length) {
			size = data.length - offset;
		}
		
		byte[] buf = new byte[size]; 
		
		for (int i = 0; i < size; i++) {
			buf[i] = data[i + offset];
		}
		
		String str = null;
		try {
			str = new String(buf, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return str;
	}
}
