/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package com.ibm.trl.tcg.pts.integrity;

import java.io.FileInputStream;
//import java.security.Key;
import java.security.KeyException;
//import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.Certificate;

import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyValue;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * Signature
 * 
 * 
 * @author Seiji Munetoh (munetoh@users.sourceforge.jp)
 * 
 */
public class PTSKeySelector extends KeySelector {

	/* Logger */
	private Log log = LogFactory.getLog(this.getClass());

	//private String pvskeystore = "testca.cert"; // TODO load from properties

	private char[] password = { 'i', 'b', 'm', 't', 'r', 'l' };

	private String filename = "testca.cert";

	private String alias = "ptstestca";

	//private String keyAlg = "DSA";

	//private String sigAlg = "SHA1WithDSA";

	//private int keySize = 1024;

	//private String dname = "CN=IBM PTS Test, OU=IBM Research, O=IBM Tokyo, C=JP";

	private PublicKey _publicKey;

	public PTSKeySelector() throws Exception {
		//KeyPair kp;
		Certificate cert;
		KeyStore ks = KeyStore.getInstance("JKS");
		FileInputStream fis = new FileInputStream(filename);
		ks.load(fis, password);
		//Key key = ks.getKey(alias, password);
		cert = ks.getCertificate(alias);
		_publicKey = cert.getPublicKey();

		// log.debug(cert.toString());
		// log.debug(publicKey.toString());

	}

	@Override
	public KeySelectorResult select(KeyInfo keyInfo, Purpose purpose,
			AlgorithmMethod method, XMLCryptoContext context)
			throws KeySelectorException {
		try {
			for (Object element : keyInfo.getContent()) {
				if (element instanceof KeyValue) {
					PublicKey publicKey = ((KeyValue) element).getPublicKey();

					if (isSameKey(publicKey, method.getAlgorithm())) {
						return new PTSKeySelectorResult(publicKey);
					}
				}
			}
		} catch (KeyException exception) {
			throw new KeySelectorException(exception);
		}
		return null;
	}

	private boolean isSameKey(PublicKey key, String algorithmUri) {

		// TODO DSA only
		if ("DSA".equalsIgnoreCase(key.getAlgorithm())
				&& SignatureMethod.DSA_SHA1.equals(algorithmUri)) {
			if (key.equals(_publicKey)) {
				if (log.isDebugEnabled())
					log.debug("key HIT " + key.toString());
				return true;
			} else {
				if (log.isDebugEnabled())
					log.debug("key does not match " + key.toString());
			}

		}
		return false;
	}

}
