#!/bin/sh
#
# Reference
#  Web Services Over SSL - HOW TO
#  http://www.pankaj-k.net/WSOverSSL/WSOverSSL-HOWTO.html

PASSWORD=changeit

ALIAS=demopvaserver
DNAME="CN=124.32.19.56, OU=Demo, O=Demo, L=Tokyo, C=JP"
KEYSTORE=server.keystore
CERTFILE=server.cer
CLIENT_KEYSTORE=client.keystore
CLIENT_ALIAS=demotpclient
CLIENT_DNAME="CN=Client, OU=Demo, O=Demo, L=Tokyo, C=JP"
CLIENT_CERTFILE=client.cer
CERT_ALIAS=demopva

echo "JAVA_HOME     : $JAVA_HOME"
echo "DNAME         : $DNAME"
echo "Keystore file : $KEYSTORE"


echo "--- Gen Key for Server ---"
keytool -genkey -alias $ALIAS -dname "$DNAME" -keyalg RSA -keypass $PASSWORD -storepass $PASSWORD -keystore $KEYSTORE

echo "--- Exporting the cert ---"
keytool -export -alias $ALIAS -storepass $PASSWORD -file $CERTFILE -keystore $KEYSTORE

echo "--- Gen Key for Client ---"
keytool -genkey -alias $CLIENT_ALIAS -dname "$CLIENT_DNAME" -keyalg RSA -keypass $PASSWORD -storepass $PASSWORD -keystore $CLIENT_KEYSTORE

echo "--- Exporting the client cert ---"
keytool -export -alias $CLIENT_ALIAS -storepass $PASSWORD -file $CLIENT_CERTFILE -keystore $CLIENT_KEYSTORE


echo "--- Import client cert into server keystore ---"
keytool -import -v -trustcacerts -alias $CERT_ALIAS -file $CERTFILE -keystore $CLIENT_KEYSTORE -keypass $PASSWORD -storepass $PASSWORD

echo "--- Import server cert into client keystore ---"

keytool -import -v -trustcacerts -alias $CERT_ALIAS -file $CLIENT_CERTFILE -keystore $KEYSTORE -keypass $PASSWORD -storepass $PASSWORD



# EOF