#!/bin/sh
#
##
## Licensed Materials - Property of IBM
## Open Platform Trust Services - An open source TCG PTS
## (C) Copyright International Business Machines Corp. 2007
##
#
# Collect Package info of Debian/Knoppix
# 
#  $ditroname/tm3-data.txt
#  $ditroname/data/*.matadata
#  $ditroname/data/*.sha1.filelist
#  $ditroname/data/*.md5.filelist
#

if [ $# -lt 1 ]
then
	echo "USAGE: $0 package_name"
	exit
fi

echo "Collect Package info of $1"

mkdir -p $1/data

echo "  treemap data..."
perl deb-tm3-one.pl $1

echo "  metadata..."
perl deb-meta-one.pl $1 $1/data

echo "  md5 digests..."
perl deb-file-one.pl $1 md5 $1/data

echo "  sha1 digests..."
perl deb-file-one.pl $1 sha1 $1/data

tar cvfz $1.tgz ./$1/*

echo "Collect Package info of $1 ...done"

sync
