/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2008
 *
 */
package tcdemo.cmd;

import java.io.BufferedReader;
import java.io.InputStreamReader;

import tcdemo.Config;


/**
 * 
 * Launch the service
 *  
 * 
 * 
 * 
 * 
 * @author Seiji Munetoh 
 *
 */
public class ClientUser {
	
	private static Config config;

	private static void usage(String[] args) {
		System.out.println("\nUsage: ClientUser [OPTIONS]");
		System.out.println(" OPTIONS");
		System.out.println("\t--propdir DIRNAME");
		System.out.println("\t\tSlect properties location");
		System.out.println("\t--auth PASSWORD");
		System.out.println("\t\tSet user password");
		System.out.println("\t--popup");
		System.out.println("\t\tSet user password by popup dialog");
		System.out.println("\t--verbose");
		System.out.println("\t\tVerbose mode");
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		/* default args */
		String[] initArgs = {
				"--propdir",
				"/opt/OpenPlatformTrustServices/tcdemo",
		};
		String password = null;
		boolean verbose = false;
		boolean popup = false;
		
		/* check the args */
		for (int i=0; i<args.length; ++i) {
            if ("--propdir".equals(args[i])) {
            	initArgs[1] = args[++i];
            } 
            else if ("--auth".equals(args[i])) {
            	password = args[++i];
            }
            else if ("--verbose".equals(args[i])) {
            	verbose = true;
            }
            else if ("--popup".equals(args[i])) {
            	popup = true;
            }
            else {
            	System.err.println("ERROR: Bad option " + args[i]);
            	usage(args);
            	return;
            }
        }
		
		try {
			config= new Config(initArgs);
			config.setVerbose(verbose);
			
			/* Setup the manifest generated by admin */
			config.setupManifest();
			
			if (popup) {
				// popup
			}
			else if (password == null) {
				System.out.print("Enter user's password:");
				// JDK6, supported by  GCJ?
				//Console console = System.console();
				// JDK5, GCJ				
				BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
				password = br.readLine();
				config.setUserPassword(password);
			}
			else {
				config.setUserPassword(password);
			}

			/* Validate by server */
			int serviceId = 0; // fixed 
			
			boolean rc; 
			
			rc = config.validate(serviceId); 
			
			
			if (rc == true) {
				/* Launch Application */
				config.startService(serviceId);				
			} else {
				/* ERROR */
				System.err.println("ERROR  : validation was failed");
				System.err.println("REASON : " + config.getReason());
			}
			
			
		} catch (Exception e) {
			System.err.println(" Exception from Config ");
			e.printStackTrace();
		}
	}

}
