package tcdemo;

import java.io.*;
import java.util.Date;
//import java.util.Enumeration;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;

// 
import javax.servlet.*;
import javax.servlet.http.*;

import com.ibm.trl.tcg.pts.PlatformTrustServices;
import com.ibm.trl.tcg.pts.tools.Base64Tool;

/**
 * 
 * openpts-tcdemo v0.1.0 servlet
 * 
 * Session timeout
 * web.xml
 * <session-timeout>
 * 
 * @author munetoh
 *
 */
public class Validate010 extends HttpServlet {

	ResourceBundle rb = ResourceBundle.getBundle("LocalStrings");
	
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException {
		
		//System.out
		//		.println("doGet PVA Validate ===================================");

		String title = rb.getString("validation.title");
		
		HttpSession session = request.getSession(true);
		/* timeout */
		session.setMaxInactiveInterval(60*5); /* 5 min */
		
		response.setHeader("Cache-Control","no-cache=\"set-cookie,set-cookie2\"");
		response.setContentType("text/html");
		
		/* HTML */
		PrintWriter out = response.getWriter();
		out.println("<html>");
		out.println("<body bgcolor=\"white\">");
		out.println("<head>");
		out.println("<title>" + title + "</title>");
		out.println("</head>");
		
		out.println("<body>");
		out.println("<h1>" + title + "</h1>");
		out.println(rb.getString("validation.id") + " " + session.getId());
		out.println("<br>");
		out.println(rb.getString("validation.created") + " ");
		out.println(new Date(session.getCreationTime()) + "<br>");
		out.println(rb.getString("validation.lastaccessed") + " ");
		out.println(new Date(session.getLastAccessedTime()));

		String account = request.getParameter("account");
		//if (account != null) {
		//	session.setAttribute("account", account);
		//	System.out.println("account " + account);
		//}
		
		/* set Attribute */
		String nonce = request.getParameter("nonce");
		

		if (nonce == null) {
			System.out.println("=================================== Hello ");
			// First access, gen new nonce
			byte[] buf = new byte[20];    		
    		Random rand = new Random();
    		for (int i=0;i<20;i++) {
    			int r = rand.nextInt(256); 
    			buf[i] = (byte) r;
    		}    		
			nonce = Base64Tool.encode(buf);
			
			/* Submit IR,RMs*/
			
			out.println("<P>");
			out.print("<form action=\"");
			out.print(response.encodeURL("Validate"));
			out.print("\" ");
			out.println("method=POST>");
			
			out.println(rb.getString("validation.account"));
			out.println("<input type=text size=40 name=account value=\"" + account +"\">");
			out.println("<br>");
			
			out.println(rb.getString("validation.nonce"));
			out.println("<input type=text size=40 name=nonce value=\"" + nonce +"\">");
			out.println("<br>");
			
			
			out.println("<input type=submit>");
			out.println("</form>");			
			
			
			System.out.println("nonce    : " + nonce);
			System.out.println("account  : " + account);
			System.out.println("account  : " + account.replace(" ", "+") + "  (replace space to +) ");
		
			session.setAttribute("nonce", nonce);
			session.setAttribute("account", account);

		}
		else {
			// Second access, check nonce, acount
			String refNonce = (String) session.getAttribute("nonce");
			account = (String) session.getAttribute("account");
			if (account == null) {
				account = "unknown";
			}
			if (account.equals("null")) {
				account = "unknown2";
			}
			
			//session.setAttribute("nonce", nonce);
			
			//String base64IR = request.getParameter("ir");
			//String base64BiosRM = request.getParameter("rm0");
			//String base64RuntimeRM = request.getParameter("rm1");
			// 2007-12-10 Munetoh missing + why? 
			String base64IR = request.getParameter("ir").replace(" ", "+");
			String base64BiosRM = request.getParameter("rm0").replace(" ", "+");
			String base64RuntimeRM = request.getParameter("rm1").replace(" ", "+");
			
			
			String option = request.getParameter("option");
			
			/* Setup the Services list */
    		// TODO put here at this moment, move to the good place
    		String propServicesFilename = "services.properties";
    		Properties propServices = new Properties();
    		
    		//propServices.load(new FileInputStream(propServicesFilename));
    		// load from classpath
    		ClassLoader cl = Validate010.class.getClassLoader();
    		InputStream is = cl.getResourceAsStream(propServicesFilename);
    		propServices.load(is);
    		
    		/* Service List */
    		String numStr = propServices.getProperty("service.num");
    		int num = Integer.valueOf(numStr);
    		String[][] services = new String[num][6];
    		for (int i = 0; i < num; i++) {
    			services[i][0] = propServices.getProperty("service." + i + ".url");
    			services[i][1] = propServices.getProperty("service." + i + ".name");
    			services[i][2] = propServices.getProperty("service." + i + ".authtype");
    			services[i][3] = propServices.getProperty("service." + i + ".account");
    			services[i][4] = propServices.getProperty("service." + i + ".password");
    			services[i][5] = propServices.getProperty("service." + i + ".extend");
    		}

 			//String message = "guest password "; // ID and PW
    		int serviceId = 0; // TODO 
 			String message = 
 				services[serviceId][3] + " " +  
 				services[serviceId][4] + " "; // ID and PW,keep space at the end 
 			
 			
			//System.out.println("base64IR : " + base64IR);
			//System.out.println("base64RM0 " + base64BiosRM);
			//System.out.println("base64RM1 " + base64RuntimeRM);
			
			// Validate 
			String base64VR = "n/a";
			try {				
	    		//String[]  base64FSMs = new String[1];
	    		//base64FSMs[0] = base64FSM;
	 			PlatformTrustServices pts = new PlatformTrustServices();
	 			String[] base64RM = new String[2];
	 			base64RM[0] = base64BiosRM;
	 			base64RM[1] = base64RuntimeRM;
	 			
	 			//String message = "Hello " + account + "! ";
	 			// TODO 
	 			//String message = "guest password "; // keep space at the end
	 			pts.setValidationMessageForValid(message);
	 			// TODO  must use refNonce here, but in some case, session is not work
	 			// check the nonce with reference value, 
	 			//       in some case, session is not work
	 			pts.setNonce(Base64Tool.decode(refNonce));
	 			//pts.setNonce(Base64Tool.decode(nonce));
	 			
	 			/* Validate */	
				base64VR = pts.validateIRfromMessage(account,base64IR, base64RM);
						
			} catch (Exception e) {
				e.printStackTrace();
			}
			
			
			// Kill
			//session.invalidate();
			System.out.println("VR : " + base64VR);
			out.println("<P>");
			out.println("account=" + account);
			out.println("nonce=" + nonce);
			out.println("vr=" + base64VR);
			out.println("<P>");

			System.out.println("=================================== Validate");
			System.out.println("nonce      : " + nonce);
			System.out.println("refNonce   : " + refNonce + " same?");
			System.out.println("account    : " + account + " local client account");
			System.out.println("option     : " + option);
			System.out.println("service ID : " + serviceId);
			System.out.println("message    : " + message + " service client account");
			
			/* kill session */
			if (session != null) {
				session.invalidate();
			}

		}
		




		//out.print("<p><a href=\"");
		//out.print(response
		//		.encodeURL("Validate?nonce=hoge&account=foo"));
		//out.println("\" >URL encoded </a>");

		out.println("</body>");
		out.println("</html>");

	}
	
    public void doPost(HttpServletRequest request,
            HttpServletResponse response)
    throws IOException, ServletException
    {
    	doGet(request, response);
    }

}