/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package tcdemo.swing;

import java.awt.Color;
import java.awt.Graphics;

import javax.swing.JPanel;

//import com.ibm.trl.tcg.pts.gui.RedGreenColorProvider.Legend;


import net.sf.jtreemap.swing.ColorProvider;
import net.sf.jtreemap.swing.JTreeMap;
import net.sf.jtreemap.swing.Value;

/**
 * 
 * CVSS Score -> Color
 * 
 * IPA 
 * http://www.ipa.go.jp/security/vuln/SeverityCVSS.html
 * http://www.ipa.go.jp/security/vuln/SeverityCVSS2.html
 * http://www.ipa.go.jp/security/vuln/documents/index.html#Vuln
 * 
 * 
 * NVD Common Vulnerability Scoring Support
 * 
 * CVSS      NVD
 * 7.0 -10.0 Level III   Red
 * 4.0 - 6.9 Level II    Orange
 * 0.0 - 3.9 Level I     Yellow
 * 
 * 
 * @author Seiji Munetoh
 *
 */
public class CvssColorProvider extends ColorProvider {

	private JTreeMap jTreeMap;
	private JPanel legend;

	public CvssColorProvider(final JTreeMap jTreeMap) {
        this.jTreeMap = jTreeMap;
    }
	
	@Override
	public Color getColor(Value value) {	
		double v = value.getValue();
		
		if (v >= 7.0) return new Color(255,0,0);
		else if (v >= 4.0) return new Color(255,127,0);
		else if (v == 0.0) return new Color(0,255,0);
		else if (v < 0.0) return new Color(255,0,0); // Unknown
		else return new Color(255,255,0);
	}

	@Override
	public JPanel getLegendPanel() {
        if (this.legend == null) {
            this.legend = new Legend();
        }
        return this.legend;
	}

	private class Legend extends JPanel {
        public Legend() {
            this.setPreferredSize(new java.awt.Dimension(
                    100, 100));
        }

        @Override
        public void paintComponent(final Graphics g) {
            super.paintComponent(g);

            g.setColor(Color.black);


            g.setColor(Color.black);
            //g.drawString("Hoge");
        }
	}
}
