/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package tcdemo.swing;

import javax.swing.SwingUtilities;
//import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JFrame;
import java.awt.Dimension;

//import javax.swing.ComboBoxModel;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;

import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
//import javax.swing.JTextPane;
import javax.swing.JLabel;
import java.awt.Rectangle;
import javax.swing.JButton;
//import java.awt.ComponentOrientation;
import java.awt.event.KeyEvent;
//import java.io.IOException;

import javax.swing.SwingConstants;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
//import javax.swing.JToolBar;

//import com.ibm.trl.tcg.pts.integrity.VerificationResult;
//import com.ibm.trl.tcg.pts.tools.Base64Tool;
//import javax.swing.JList;

//import java.awt.Graphics;
//import java.awt.Image;
//import java.awt.Panel;
//import java.awt.Label;
//import java.awt.Font;
//import java.awt.List;
//import java.awt.Button;
//import javax.swing.BorderFactory;
//import javax.swing.border.BevelBorder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
//import javax.swing.table.TableColumn;
//import javax.swing.table.TableModel;

import java.awt.Point;
import javax.swing.JPasswordField;
//import javax.swing.JTree;
import java.awt.Color;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTable;
//import javax.swing.JTextArea;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import java.awt.BorderLayout;
import javax.swing.JTextPane;
import javax.swing.JTextArea;
import javax.swing.JScrollBar;

import tcdemo.Config;

public class ClientUser extends JFrame {

	
	private String failMode = "na";  //  @jve:decl-index=0:
	private char[] password;

	//private static JwsWrapper jw;
	private static Config config;

	String[] serverUrls = {"http://localhost","http://pts.ibm.com"};
	static String[] serviceList;

	String[] pcrTableColumnNames = {
			"Index" , "Digest(hex)","Usage","Status"
	};
	
	private static DefaultTableModel tableModelSecurityProperties;

	private static String[] securityPropertiesTableColumnNames = {
		"Security Req","Service Policy","State","Description"
		//"セキュリティ要件","サービスのポリシー","この端末の対応","説明"
	};
	static String[][] securityPropertiesTableRowData;
	
	static String[][] pcrTableRowData; 
	
	static String[] eventlogTableColumnNames = {
			"PCR Index" , "Digest(hex)","Name","Status"
	};
	static String[][] eventlogTableRowData;
	
	private static DefaultTableModel tableModelEventlog;
	
	
	private static final long serialVersionUID = 1L;

	private JMenuBar jJMenuBar = null;

	private JMenu jMenuFile = null;

	private JMenu jMenuHelp = null;

	private JMenuItem jMenuItemAbout = null;

	private JMenuItem jMenuItemHelp = null;

	private JMenuItem jMenuItemExit = null;

	private JPanel jPanel = null;

	private JTabbedPane jTabbedPane = null;

	private JPanel jPanelButtom = null;

	private JPanel jPanelAttestation = null;

	private JButton jButtonate = null;

	//private JPanel jPanel1 = null;
	//private JPanel jPanel2 = null;
	private JLabel jLabel = null;
	private JComboBox jComboBoxServices = null;
	private JLabel jLabel5 = null;
	private JTextField jTextField4 = null;
	private JTextField jTextFieldMessage = null;

	private static String username;

	private static String biosVersionName;

	private static String macineTypeName;

	private static String pcVendorName;
	private static String lookAndFeel;
	private static Font font;



	private JLabel jLabel2 = null;
	private JScrollPane jScrollPane = null;
	private JTextArea jTextArea = null;
	private static String userName;
	/**
	 * This method initializes jJMenuBar	
	 * 	
	 * @return javax.swing.JMenuBar	
	 */
	private JMenuBar getJJMenuBar() {
		if (jJMenuBar == null) {
			jJMenuBar = new JMenuBar();
			jJMenuBar.add(getJMenuFile());
			jJMenuBar.add(getJMenuHelp());
		}
		return jJMenuBar;
	}

	/**
	 * This method initializes jMenuFile	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getJMenuFile() {
		if (jMenuFile == null) {
			jMenuFile = new JMenu();
			jMenuFile.setText("File"); // ファイル
			jMenuFile.add(getJMenuItemExit());
			jMenuFile.setFont(font);
		}
		return jMenuFile;
	}

	/**
	 * This method initializes jMenuHelp	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getJMenuHelp() {
		if (jMenuHelp == null) {
			jMenuHelp = new JMenu();
			jMenuHelp.setText("Help"); // ヘルプ
			jMenuHelp.add(getJMenuItemAbout());
			jMenuHelp.add(getJMenuItemHelp());
			jMenuHelp.setFont(font);
		}
		return jMenuHelp;
	}

	/**
	 * This method initializes jMenuItemAbout	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemAbout() {
		if (jMenuItemAbout == null) {
			jMenuItemAbout = new JMenuItem("About");
		}
		return jMenuItemAbout;
	}

	/**
	 * This method initializes jMenuItemHelp	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemHelp() {
		if (jMenuItemHelp == null) {
			jMenuItemHelp = new JMenuItem("Help");
		}
		return jMenuItemHelp;
	}

	/**
	 * This method initializes jMenuItemExit	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemExit() {
		if (jMenuItemExit == null) {
			jMenuItemExit = new JMenuItem("Exit");
			jMenuItemExit.setFont(font);
			jMenuItemExit.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					System.out.println("actionPerformed() Menu Exit"); 
					System.exit(0);
				}
			});
		}
		return jMenuItemExit;
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel() {
		if (jPanel == null) {
			jPanel = new JPanel();
			jPanel.setLayout(null);
			jPanel.add(getJTabbedPane(), null);
			jPanel.add(getJPanelButtom(), null);
			
			
		}
		return jPanel;
	}

	/**
	 * This method initializes jTabbedPane	
	 * 	
	 * @return javax.swing.JTabbedPane	
	 */
	private JTabbedPane getJTabbedPane() {
		if (jTabbedPane == null) {
			jTabbedPane = new JTabbedPane();
			jTabbedPane.setLocation(new Point(0, 0));
			jTabbedPane.setSize(new Dimension(630, 391));
			jTabbedPane.setFont(font);
			jTabbedPane.addTab("Start Service", null, getJPanelAttestation(), null); // サービス開始
		}
		return jTabbedPane;
	}

	/**
	 * This method initializes jPanelButtom	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelButtom() {
		if (jPanelButtom == null) {
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints.gridy = 0;
			gridBagConstraints.weightx = 1.0;
			gridBagConstraints.gridx = 0;
			jPanelButtom = new JPanel();
			jPanelButtom.setLayout(new GridBagLayout());
			jPanelButtom.setBounds(new Rectangle(0, 391, 631, 31));
			jPanelButtom.add(getJTextFieldMessage(), gridBagConstraints);
		}
		return jPanelButtom;
	}

	/**
	 * This method initializes jPanelAttestation	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelAttestation() {
		if (jPanelAttestation == null) {
			jLabel2 = new JLabel();
			jLabel2.setBounds(new Rectangle(21, 132, 171, 22));
			jLabel2.setText("Security Info");
			jLabel2.setFont(font);
			jLabel5 = new JLabel();
			jLabel5.setText("Username");
			jLabel5.setSize(new Dimension(116, 25));
			jLabel5.setHorizontalAlignment(SwingConstants.RIGHT);
			jLabel5.setLocation(new Point(21, 9));
			jLabel5.setFont(font);
			jLabel = new JLabel();
			jLabel.setText("Select Service");
			jLabel.setLocation(new Point(20, 46));
			jLabel.setSize(new Dimension(117, 25));
			jLabel.setHorizontalAlignment(SwingConstants.RIGHT);
			jLabel.setFont(font);
			jPanelAttestation = new JPanel();
			jPanelAttestation.setLayout(null);
			jPanelAttestation.add(jLabel5, null);
			jPanelAttestation.add(getJTextField4(), null);
			jPanelAttestation.add(jLabel, null);
			jPanelAttestation.add(getJComboBoxServices(), null);
			jPanelAttestation.add(getJButtonate(), null);
			jPanelAttestation.add(jLabel2, null);
			jPanelAttestation.add(getJScrollPane(), null);
		}
		return jPanelAttestation;
	}

	/**
	 * This method initializes jButtonate	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonate() {
		if (jButtonate == null) {
			jButtonate = new JButton();
			jButtonate.setText("Validate Platform and Start Service");
			jButtonate.setSize(new Dimension(564, 32));
			jButtonate.setLocation(new Point(21, 89));
			jButtonate.setFont(font);
			
			jButtonate.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {

					// Selected Service
					// TODO service index (select) must be quoted
					int select = jComboBoxServices.getSelectedIndex();

					/* reset messages */
					jTextFieldMessage.setText("Validationg this platform");
					jTextFieldMessage.setBackground(Color.white);
					jTextFieldMessage.repaint();
					
					jTextArea.setText("");
					jTextArea.setBackground(Color.white);
					jTextArea.repaint();
					
					/* Ask PW */
					//password = jPasswordField.getPassword();
					//boolean rc = config.checkPassword(password);
					boolean rc;
					
					String advice = "wait a moment.....";
					
					//if (failMode.equals("PWFAIL")) {
					//	advice = "Wrong password, try again";
					//	rc = false;						
					//}
					
					//if (rc==false) {
					//	System.out.println("Wrong PW");
					//	jTextFieldMessage.setText(config.getReason());
					//	jTextArea.setText(config.getReason());
						//jPasswordField.setBackground(new Color());
						//jPasswordField.setBackground(Color.red);

					//} 
					//else {
						/* Quote OK, Ask to PTS Server */
						//jPasswordField.setBackground(Color.white);
						
						jTextFieldMessage.setText("Wait a moment....");
						rc = config.validate(select);
						advice = config.getErrorMessage();
						String reason = config.getReason();
						
						//String advice;
						/*
						if (failMode.equals("BIOSFAIL")) {
							securityPropertiesTableRowData[0][2]="Validation was faild";
							advice = "There are some integrity problem on your PC BIOS";
							securityPropertiesTableRowData[0][3]=advice;
							rc = false;
						}
						if (failMode.equals("OSFAIL")) {
							securityPropertiesTableRowData[1][2]="Validation was failed";
							advice = "There are some integrity problem on your CD, check the latest version";
							securityPropertiesTableRowData[1][3]=advice;
							rc = false;
						}
						if (failMode.equals("APPFAIL")) {
							securityPropertiesTableRowData[2][2]="Validation was failed";
							advice = "There are some integrity problem on your CD, check the latest image";
							securityPropertiesTableRowData[2][3]=advice;
							rc = false;
						}
						*/
						
						/* Inform status to the user */
						if (rc == true) {
							// OK
							String msg = "Good integrity, start firefox";
							jTextFieldMessage.setText(msg);
							jTextFieldMessage.setBackground(Color.green);
							jTextArea.setText(msg);
							jTextArea.setBackground(Color.green);
							
							//for (int i=0;i<securityPropertiesTableRowData.length;i++) {
							//	securityPropertiesTableRowData[i][2]="valid";								
							//}
							//updateSecurityProperties();
							
							//jPasswordField.setText(service.getPassword());
							/* Start Service */
							config.startService(select);
							
						}
						else {
							// FAIL
							jTextFieldMessage.setText("There are some problems");
							jTextFieldMessage.setBackground(Color.red);
							String message = "";
							if (advice != null) {
								message += "Client Side Error, Warning or Info \n";
								message += advice + "\n";
							}
							if (reason != null) {
								message += "Serverside Side Error, Warning or Info\n";
								message += reason + "\n";
							}
							jTextArea.setText(message);
							jTextArea.setBackground(Color.red);
							//updateSecurityProperties();
						}					
					//}					
				} // actionPerformed
			});
		}
		return jButtonate;
	}

	/**
	 * This method initializes jPanel1	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	//private JPanel getJPanel1() {
	//	if (jPanel1 == null) {
	//	}
	//	return jPanel1;
	//}

	/**
	 * This method initializes jPanel2	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	//private JPanel getJPanel2() {
	//	if (jPanel2 == null) {
	//	}
	//	return jPanel2;
	//}

	/**
	 * This method initializes jComboBoxServices	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBoxServices() {
		if (jComboBoxServices == null) {
			jComboBoxServices = new JComboBox();
			jComboBoxServices.setSize(new Dimension(434, 25));
			jComboBoxServices.setLocation(new Point(148, 44));
			jComboBoxServices.setFont(font);
			// serviceList
			jComboBoxServices.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					System.out.println("itemStateChanged()"); 
					//int select = jComboBoxServices.getSelectedIndex();
					//jTextField4.setText(service.getUsername(select));
					// TODO Auto-generated Event stub itemStateChanged()
				}
			});
		}
		return jComboBoxServices;
	}

	/**
	 * This method initializes jTextField4	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextField4() {
		if (jTextField4 == null) {
			jTextField4 = new JTextField();
			jTextField4.setLocation(new Point(147, 9));
			//jTextField4.setEditable(false);
			jTextField4.setSize(new Dimension(434, 25));
			
			jTextField4.setFont(font);

		}
		return jTextField4;
	}

	/**
	 * This method initializes jTextFieldMessage	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldMessage() {
		if (jTextFieldMessage == null) {
			jTextFieldMessage = new JTextField();
			jTextFieldMessage.setPreferredSize(new Dimension(600, 25));
			jTextFieldMessage.setHorizontalAlignment(JTextField.CENTER);
			jTextFieldMessage.setText("select service and press the start button"); // パスワード入力後、サービスを選択し、サービス開始ボタンを押してください
			jTextFieldMessage.setEditable(false);
		}
		return jTextFieldMessage;
	}

	/**
	 * This method initializes jScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPane() {
		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setBounds(new Rectangle(39, 157, 547, 199));
			jScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			jScrollPane.setViewportView(getJTextArea());
		}
		return jScrollPane;
	}

	/**
	 * This method initializes jTextArea	
	 * 	
	 * @return javax.swing.JTextArea	
	 */
	private JTextArea getJTextArea() {
		if (jTextArea == null) {
			jTextArea = new JTextArea();
			jTextArea.setLineWrap(true);
			jTextArea.setFont(font);
		}
		return jTextArea;
	}

	/**
	 * @param args
	 * @throws Exception 
	 */
	public static void main(String[] args) {
		/* Initialize PTS Client */
		
		try {
			config= new Config(args);
			config.setupManifest();
			serviceList = config.getServiceList();
			pcrTableRowData = config.getPcrData();		
			eventlogTableRowData = config.getEventlogData();
			username = config.getUsername(0);
			pcVendorName = config.getPcVendorName();
			macineTypeName = config.getMacineTypeName();
			biosVersionName = config.getBiosVersionName();			
			lookAndFeel = config.getLookAndFeel();
			userName = config.getUserName();
			
			tableModelEventlog = 
				new DefaultTableModel(eventlogTableColumnNames, 0);
			
			tableModelSecurityProperties = 
				new DefaultTableModel(securityPropertiesTableColumnNames, 0);
			
			// TODO
			//securityPropertiesTableRowData = null;;
			//updateSecurityProperties();
			
			/* Font */
			font = new Font("Default", Font.PLAIN, 14);
			
			SwingUtilities.invokeLater(new Runnable() {
				public void run() {
					ClientUser thisClass = new ClientUser();
					thisClass.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
					thisClass.setVisible(true);
					thisClass.jTextField4.setText(userName);

				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			System.err.println(" Exception from Config ");
			e.printStackTrace();
		}
	}

	private static void updateSecurityProperties() {
		/* Update Your Client Info - EventLog */
		int rowNumOld=0;
		if (securityPropertiesTableRowData != null) {
			rowNumOld = securityPropertiesTableRowData.length;
		}
		securityPropertiesTableRowData = config.getSecurityPropertyList();
		int rowNumNew =  securityPropertiesTableRowData.length;
		//TableModel tableModel = jTable.getModel();
		for (int i=0;i<rowNumOld;i++) { // Update
			tableModelSecurityProperties.setValueAt(securityPropertiesTableRowData[i][0], i, 0); // pcr
			tableModelSecurityProperties.setValueAt(securityPropertiesTableRowData[i][1], i, 1); // digest
			tableModelSecurityProperties.setValueAt(securityPropertiesTableRowData[i][2], i, 2); // name
			tableModelSecurityProperties.setValueAt(securityPropertiesTableRowData[i][3], i, 3); // Status
		}
		for (int i=rowNumOld;i<rowNumNew;i++) { // Add
			String[] row = {
					securityPropertiesTableRowData[i][0],
					securityPropertiesTableRowData[i][1],
					securityPropertiesTableRowData[i][2],
					securityPropertiesTableRowData[i][3],
			};
			tableModelSecurityProperties.addRow(row);
		}

		// TODO Auto-generated method stub
		
	}

	/**
	 * This is the default constructor
	 */
	public ClientUser() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(640, 480);
		this.setContentPane(getJPanel());
		this.setJMenuBar(getJJMenuBar());
		this.setTitle("Service Management Tool (with Platform Integrity Check)"); //  サービス管理
		
        try{
            UIManager.setLookAndFeel(lookAndFeel);
                //"com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            SwingUtilities.updateComponentTreeUI(this);
        }catch(Exception ex){
            System.out.println("Error, Missing Look And Feel Setting : " + lookAndFeel);
        }
        /* Panel */
        this.jComboBoxServices.removeAll();
        for (int i=0;i<serviceList.length;i++) {
        	this.jComboBoxServices.addItem(serviceList[i]);
        }
        this.jComboBoxServices.updateUI();
        
	}

}  //  @jve:decl-index=0:visual-constraint="1,-9"
