/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2007
 *
 */
package tcdemo.swing;

import java.awt.CardLayout;
import java.awt.Dimension;
//import javax.swing.BorderFactory;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolTip;
//import javax.swing.JTree;

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import javax.swing.JLabel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultTreeModel;

import net.sf.jtreemap.swing.ColorProvider;
import net.sf.jtreemap.swing.DefaultToolTipBuilder;
import net.sf.jtreemap.swing.IToolTipBuilder;
import net.sf.jtreemap.swing.TreeMapNode;
import net.sf.jtreemap.swing.example.BuilderTM3;
import tcdemo.Config;
import javax.swing.JRadioButton;

/**
 * 
 * Size XGA
 * 1000x700
 * 
 * @author Seiji Munetoh
 *
 */
public class ClientAdmin extends JFrame {

	//private static JwsWrapper jw;
	private static Config config;

	String[] serverUrls = {"http://localhost","http://pts.ibm.com"};
	static String[] serviceList;

	static String[] pcrTableColumnNames = {
		//"Index" , "Digest(hex)","Usage","Status"
		"Index" , "Digest(hex)","Usage"
	};
	
	static String[][] pcrTableRowData; 
	static String[] eventlogTableColumnNames = {
		//"PCR Index" , "Digest(hex)","Name","Status"
		"PCR Index" , "Digest(hex)","Name"
	};
	static String[][] eventlogTableRowData;
	
	private static DefaultTableModel tableModelPcr;
	private static DefaultTableModel tableModelEventlog;
	
	private static TreeMapNode treemapComponentRoot;
	private static TreeMapNode treemapSecurityPropRoot;

	private DefaultTreeModel treeModel;
	private final static LinkedHashMap<String, ColorProvider> cpColorProviders = new LinkedHashMap<String, ColorProvider>();  //  @jve:decl-index=0:
	private final static LinkedHashMap<String, ColorProvider> spColorProviders = new LinkedHashMap<String, ColorProvider>();
	
	private static final long serialVersionUID = 1L;

	private JMenuBar jJMenuBar = null;

	private JMenu jMenuFile = null;

	private JMenu jMenuHelp = null;

	private JMenuItem jMenuItemAbout = null;

	private JMenuItem jMenuItemHelp = null;

	private JMenuItem jMenuItemExit = null;

	private JPanel jPanel = null;

	private JTabbedPane jTabbedPane = null;

	private JPanel jPanelPlatformInfo = null;

	private JPanel jPanelAttestation = null;

	private JLabel jLabelServerURL = null;

	private JLabel jLabel = null;
	private JButton jButtonSubmit = null;
	private JLabel jLabel5 = null;
	private JLabel jLabel6 = null;
	private JLabel jLabel7 = null;
	private JLabel jLabel8 = null;
	private JScrollPane jScrollPanePcrValue = null;
	private JTable jTablePcrs = null;
	private JScrollPane jScrollPaneEventLog = null;
	private JTable jTableEventlog = null;

	private static String username;

	private static String biosVersionName;

	private static String macineTypeName;

	private static String pcVendorName;


	private static DefaultTreeModel treeModelSP;

	private JToolTip jToolTipCP;

	private DefaultToolTipBuilder toolTipBuilderSP;

	private static IToolTipBuilder toolTipBuilderCP;

	private static DefaultTreeModel treeModelCP;

	private JMenu jMenuTool = null;

	private JMenuItem jMenuItemRestartTCSD = null;

	private JMenuItem jMenuItemGetIML = null;

	private JMenuItem jMenuItemGeneratePlatformManifest = null;

	private JMenuItem jMenuItemGenerateRuntimeManifest = null;

	private JLabel jLabel9 = null;

	private JTextField jTextFieldPlatformVendor = null;

	private JLabel jLabel10 = null;

	private JTextField jTextFieldPlatformName = null;

	private JLabel jLabel11 = null;

	private JTextField jTextFieldBiosVersion = null;

	private JLabel jLabel12 = null;

	private JTextField jTextFieldBiosDate = null;

	private JButton jButtonGetIML = null;

	private JPanel jPanelSMBIOS = null;

	private JPanel jPanelManifest = null;

	private JButton jButtonCreatePlatformManifest = null;

	private JButton jButton2 = null;

	private JLabel jLabel13 = null;

	private JButton jButton3 = null;

	private JLabel jLabel1 = null;

	private JLabel jLabel2 = null;

	private JLabel jLabel3 = null;

	private JLabel jLabel4 = null;

	private JLabel jLabel14 = null;

	private JButton jButton4 = null;

	private JButton jButton5 = null;

	private JLabel jLabel15 = null;

	private JButton jButton6 = null;

	private JLabel jLabel16 = null;

	private JTextField jTextFieldPlatformManifestStatus = null;

	private JTextField jTextFieldPlatformManifestUUID = null;

	private JTextField jTextFieldRuntimeManifestStatus = null;

	private JTextField jTextFieldRuntimeManifestUUID = null;

	private JTextField jTextFieldTcdemoServerUrl = null;

	private JComboBox jComboBoxServiceList = null;

	private JComboBox jComboBoxPlatformManifestPvaUrl = null;

	private JComboBox jComboBoxRuntimeManifestPvaUrl = null;

	private JTextField jTextFieldServiceDescription = null;

	private JTextField jTextFieldServiceAuthType = null;

	private JButton jButtonViewPlatformManifest = null;

	private JButton jButtonViewRuntimeManifest = null;

	private JPanel jPanelIdentitySetup = null;

	private JLabel jLabel17 = null;

	private JButton jButtonInvokeTPMM = null;

	private JLabel jLabel18 = null;

	private JLabel jLabel19 = null;

	private JTextField jTextFieldSignKeyFilename = null;

	private JRadioButton jRadioButtonSignKeyUpdate = null;

	private JButton jButtonCreateSignKey = null;

	private JRadioButton jRadioButtonKnoppix = null;

	private JLabel jLabel20 = null;

	private JTextField jTextFieldUserName = null;

	private JButton jButtonSetupUser = null;


	/**
	 * This method initializes jJMenuBar	
	 * 	
	 * @return javax.swing.JMenuBar	
	 */
	private JMenuBar getJJMenuBar() {
		if (jJMenuBar == null) {
			jJMenuBar = new JMenuBar();
			jJMenuBar.add(getJMenuFile());
			jJMenuBar.add(getJMenuTool());
			jJMenuBar.add(getJMenuHelp());
		}
		return jJMenuBar;
	}

	/**
	 * This method initializes jMenuFile	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getJMenuFile() {
		if (jMenuFile == null) {
			jMenuFile = new JMenu();
			jMenuFile.setText("File");
			jMenuFile.add(getJMenuItemExit());
		}
		return jMenuFile;
	}

	/**
	 * This method initializes jMenuHelp	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getJMenuHelp() {
		if (jMenuHelp == null) {
			jMenuHelp = new JMenu();
			jMenuHelp.setText("Help");
			jMenuHelp.add(getJMenuItemAbout());
			jMenuHelp.add(getJMenuItemHelp());
		}
		return jMenuHelp;
	}

	/**
	 * This method initializes jMenuItemAbout	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemAbout() {
		if (jMenuItemAbout == null) {
			jMenuItemAbout = new JMenuItem("About");
		}
		return jMenuItemAbout;
	}

	/**
	 * This method initializes jMenuItemHelp	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemHelp() {
		if (jMenuItemHelp == null) {
			jMenuItemHelp = new JMenuItem("Help");
		}
		return jMenuItemHelp;
	}

	/**
	 * This method initializes jMenuItemExit	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemExit() {
		if (jMenuItemExit == null) {
			jMenuItemExit = new JMenuItem("Exit");
			jMenuItemExit.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					System.out.println("actionPerformed() Menu Exit"); 
					System.exit(0);
				}
			});
		}
		return jMenuItemExit;
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel() {
		if (jPanel == null) {
			jPanel = new JPanel();
			jPanel.setLayout(new CardLayout());
			jPanel.add(getJTabbedPane(), getJTabbedPane().getName());
		}
		return jPanel;
	}

	/**
	 * This method initializes jTabbedPane	
	 * 	
	 * @return javax.swing.JTabbedPane	
	 */
	private JTabbedPane getJTabbedPane() {
		if (jTabbedPane == null) {
			jTabbedPane = new JTabbedPane();
			jTabbedPane.setName("jTabbedPane");
			jTabbedPane.addTab("Platform Information", null, getJPanelPlatformInfo(), null);
			jTabbedPane.addTab("Reference Manifests", null, getJPanelManifest(), null);
			jTabbedPane.addTab("Identity Setup", null, getJPanelIdentitySetup(), null);
			jTabbedPane.addTab("Service Setup", null, getJPanelAttestation(), null);
		}
		return jTabbedPane;
	}

	/**
	 * This method initializes jPanelPlatformInfo	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelPlatformInfo() {
		if (jPanelPlatformInfo == null) {
			jLabel12 = new JLabel();
			jLabel12.setText("BIOS Date");
			jLabel12.setSize(new Dimension(100, 20));
			jLabel12.setLocation(new Point(394, 41));
			jLabel11 = new JLabel();
			jLabel11.setText("BIOS Version");
			jLabel11.setSize(new Dimension(100, 20));
			jLabel11.setLocation(new Point(392, 11));
			jLabel10 = new JLabel();
			jLabel10.setText("Platform Name");
			jLabel10.setSize(new Dimension(100, 20));
			jLabel10.setLocation(new Point(10, 38));
			jLabel9 = new JLabel();
			jLabel9.setPreferredSize(new Dimension(90, 15));
			jLabel9.setLocation(new Point(10, 9));
			jLabel9.setSize(new Dimension(100, 20));
			jLabel9.setText("Platform Vendor");
			jLabel8 = new JLabel();
			jLabel8.setText("Event Log");
			jLabel7 = new JLabel();
			jLabel7.setText("PCR Value");
			jPanelPlatformInfo = new JPanel();
			jPanelPlatformInfo.setLayout(new BoxLayout(getJPanelPlatformInfo(), BoxLayout.Y_AXIS));
			jPanelPlatformInfo.add(getJPanelSMBIOS(), null);
			jPanelPlatformInfo.add(jLabel7, null);
			jPanelPlatformInfo.add(getJScrollPanePcrValue(), null);
			jPanelPlatformInfo.add(jLabel8, null);
			jPanelPlatformInfo.add(getJScrollPaneEventLog(), null);
			jPanelPlatformInfo.add(getJButtonGetIML(), null);
		}
		return jPanelPlatformInfo;
	}

	/**
	 * This method initializes jPanelAttestation	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelAttestation() {
		if (jPanelAttestation == null) {
			jLabel6 = new JLabel();
			jLabel6.setText("Authentication Method");
			jLabel6.setSize(new Dimension(130, 25));
			jLabel6.setHorizontalAlignment(SwingConstants.RIGHT);
			jLabel6.setLocation(new Point(22, 230));
			jLabel5 = new JLabel();
			jLabel5.setText("Description");
			jLabel5.setSize(new Dimension(130, 25));
			jLabel5.setHorizontalAlignment(SwingConstants.RIGHT);
			jLabel5.setLocation(new Point(20, 133));
			jLabel = new JLabel();
			jLabel.setText("Service List:");
			jLabel.setLocation(new Point(20, 84));
			jLabel.setSize(new Dimension(128, 25));
			jLabel.setHorizontalAlignment(SwingConstants.RIGHT);
			jLabelServerURL = new JLabel();
			jLabelServerURL.setText("TCDEMO Server");
			jLabelServerURL.setLocation(new Point(19, 24));
			jLabelServerURL.setSize(new Dimension(130, 25));
			jLabelServerURL.setHorizontalAlignment(SwingConstants.RIGHT);
			jPanelAttestation = new JPanel();
			jPanelAttestation.setLayout(null);
			jPanelAttestation.add(jLabelServerURL, null);
			jPanelAttestation.add(getJTextFieldTcdemoServerUrl(), null);
			jPanelAttestation.add(getJButtonSubmit(), null);
			jPanelAttestation.add(jLabel, null);
			jPanelAttestation.add(getJComboBoxServiceList(), null);
			jPanelAttestation.add(jLabel5, null);
			jPanelAttestation.add(getJTextFieldServiceDescription(), null);
			jPanelAttestation.add(jLabel6, null);
			jPanelAttestation.add(getJTextFieldServiceAuthType(), null);
		}
		return jPanelAttestation;
	}

	/**
	 * This method initializes jButtonSubmit	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonSubmit() {
		if (jButtonSubmit == null) {
			jButtonSubmit = new JButton();
			jButtonSubmit.setText("Get Service List");
			jButtonSubmit.setSize(new Dimension(155, 25));
			jButtonSubmit.setMnemonic(KeyEvent.VK_UNDEFINED);
			jButtonSubmit.setEnabled(false);
			jButtonSubmit.setLocation(new Point(463, 28));
			jButtonSubmit.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					
					/* Get Service */
					boolean rc = config.getServiceListFromPTSServer();
					
					
					updateService();
				}
			});
		}
		return jButtonSubmit;
	}

	/**
	 * This method initializes jScrollPanePcrValue	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPanePcrValue() {
		if (jScrollPanePcrValue == null) {
			jScrollPanePcrValue = new JScrollPane();
			jScrollPanePcrValue.setPreferredSize(new Dimension(600, 100));
			jScrollPanePcrValue.setViewportView(getJTablePcrs());
		}
		return jScrollPanePcrValue;
	}

	/**
	 * This method initializes jTablePcrs	
	 * 	
	 * @return javax.swing.JTable	
	 */
	private JTable getJTablePcrs() {
		if (jTablePcrs == null) {
			jTablePcrs = new JTable(tableModelPcr);
			jTablePcrs.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
			
			{ /* SM */
				 for(int i = 0 ; i < pcrTableRowData.length ; i++){
					 String [] row = pcrTableRowData[i];
					 tableModelPcr.addRow(row);		 
				 }
				
				DefaultTableColumnModel columnModel
	            = (DefaultTableColumnModel)jTablePcrs.getColumnModel();

				columnModel.getColumn(0).setPreferredWidth(40);
				columnModel.getColumn(1).setPreferredWidth(300);
				//columnModel.getColumn(2).setPreferredWidth(142);
				//columnModel.getColumn(3).setPreferredWidth(100);

			}
		}
		return jTablePcrs;
	}

	/**
	 * This method initializes jScrollPaneEventLog	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPaneEventLog() {
		if (jScrollPaneEventLog == null) {
			jScrollPaneEventLog = new JScrollPane();
			jScrollPaneEventLog.setPreferredSize(new Dimension(500, 100));
			jScrollPaneEventLog.setViewportView(getJTableEventlog());
		}
		return jScrollPaneEventLog;
	}

	/**
	 * This method initializes jTableEventlog	
	 * 	
	 * @return javax.swing.JTable	
	 */
	private JTable getJTableEventlog() {
		if (jTableEventlog == null) {
			//jTable1 = new JTable(eventlogTableRowData,eventlogTableColumnNames);
			jTableEventlog = new JTable(tableModelEventlog);
			jTableEventlog.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
			
			
			{ /* SM */
				 for(int i = 0 ; i < eventlogTableRowData.length ; i++){
					 String [] row = eventlogTableRowData[i];
					 tableModelEventlog.addRow(row);		 
				 }
				 
				DefaultTableColumnModel columnModel
	            = (DefaultTableColumnModel)jTableEventlog.getColumnModel();

				columnModel.getColumn(0).setPreferredWidth(40);
				columnModel.getColumn(1).setPreferredWidth(300);
				//columnModel.getColumn(2).setPreferredWidth(142);
				//columnModel.getColumn(3).setPreferredWidth(100);
				//tableModelEventlog.g

			}
		}
		return jTableEventlog;
	}

	/**
	 * This method initializes jMenuTool	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getJMenuTool() {
		if (jMenuTool == null) {
			jMenuTool = new JMenu();
			jMenuTool.setText("Tool");
			jMenuTool.add(getJMenuItemRestartTCSD());
			jMenuTool.add(getJMenuItemGetIML());
			jMenuTool.add(getJMenuItemGeneratePlatformManifest());
			jMenuTool.add(getJMenuItemGenerateRuntimeManifest());
		}
		return jMenuTool;
	}

	/**
	 * This method initializes jMenuItemRestartTCSD	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemRestartTCSD() {
		if (jMenuItemRestartTCSD == null) {
			jMenuItemRestartTCSD = new JMenuItem();
			jMenuItemRestartTCSD.setText("Restart TCSD");
			jMenuItemRestartTCSD.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					System.out.println("actionPerformed()"); 
					config.restartTcsd();
					// TODO Auto-generated Event stub actionPerformed()
				}
			});
		}
		return jMenuItemRestartTCSD;
	}

	/**
	 * This method initializes jMenuItemGetIML	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemGetIML() {
		if (jMenuItemGetIML == null) {
			jMenuItemGetIML = new JMenuItem();
			jMenuItemGetIML.setText("Get/Update Platform Infomation");
			jMenuItemGetIML.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					System.out.println("actionPerformed()"); 
					config.issueGetIml();
					// TODO Auto-generated Event stub actionPerformed()
				}
			});
		}
		return jMenuItemGetIML;
	}

	/**
	 * This method initializes jMenuItemGeneratePlatformManifest	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemGeneratePlatformManifest() {
		if (jMenuItemGeneratePlatformManifest == null) {
			jMenuItemGeneratePlatformManifest = new JMenuItem();
			jMenuItemGeneratePlatformManifest.setText("Create Reference Manifest of Platform");
			jMenuItemGeneratePlatformManifest.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					System.out.println("actionPerformed()"); 
					config.generatePlatformRm();
					// TODO Auto-generated Event stub actionPerformed()
				}
			});
		}
		return jMenuItemGeneratePlatformManifest;
	}

	/**
	 * This method initializes jMenuItemGenerateRuntimeManifest	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemGenerateRuntimeManifest() {
		if (jMenuItemGenerateRuntimeManifest == null) {
			jMenuItemGenerateRuntimeManifest = new JMenuItem();
			jMenuItemGenerateRuntimeManifest.setText("Create Reference Manifest of Runtime");
			jMenuItemGenerateRuntimeManifest.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					System.out.println("actionPerformed()"); 
					config.generateRuntimeRm();
					// TODO Auto-generated Event stub actionPerformed()
				}
			});
		}
		return jMenuItemGenerateRuntimeManifest;
	}

	/**
	 * This method initializes jTextFieldPlatformVendor	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldPlatformVendor() {
		if (jTextFieldPlatformVendor == null) {
			jTextFieldPlatformVendor = new JTextField();
			jTextFieldPlatformVendor.setLocation(new Point(119, 11));
			jTextFieldPlatformVendor.setSize(new Dimension(240, 20));
		}
		return jTextFieldPlatformVendor;
	}

	/**
	 * This method initializes jTextFieldPlatformName	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldPlatformName() {
		if (jTextFieldPlatformName == null) {
			jTextFieldPlatformName = new JTextField();
			jTextFieldPlatformName.setLocation(new Point(118, 40));
			jTextFieldPlatformName.setSize(new Dimension(240, 20));
		}
		return jTextFieldPlatformName;
	}

	/**
	 * This method initializes jTextFieldBiosVersion	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldBiosVersion() {
		if (jTextFieldBiosVersion == null) {
			jTextFieldBiosVersion = new JTextField();
			jTextFieldBiosVersion.setLocation(new Point(505, 13));
			jTextFieldBiosVersion.setSize(new Dimension(120, 20));
		}
		return jTextFieldBiosVersion;
	}

	/**
	 * This method initializes jTextFieldBiosDate	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldBiosDate() {
		if (jTextFieldBiosDate == null) {
			jTextFieldBiosDate = new JTextField();
			jTextFieldBiosDate.setLocation(new Point(507, 42));
			jTextFieldBiosDate.setSize(new Dimension(120, 20));
		}
		return jTextFieldBiosDate;
	}

	/**
	 * This method initializes jButtonGetIML	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonGetIML() {
		if (jButtonGetIML == null) {
			jButtonGetIML = new JButton();
			jButtonGetIML.setText("Refresh Platform Information");
			jButtonGetIML.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					System.out.println("Refresh Platform Information button"); 
					
					updatePlatformInfo();

				}

				//private void updatePlatformInfo() {
					// TODO Auto-generated method stub
					
				//}
			});
		}
		return jButtonGetIML;
	}

	/**
	 * This method initializes jPanelSMBIOS	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelSMBIOS() {
		if (jPanelSMBIOS == null) {
			jPanelSMBIOS = new JPanel();
			jPanelSMBIOS.setLayout(null);
			jPanelSMBIOS.setPreferredSize(new Dimension(500, 50));
			jPanelSMBIOS.add(jLabel9, null);
			jPanelSMBIOS.add(getJTextFieldPlatformVendor(), null);
			jPanelSMBIOS.add(jLabel10, null);
			jPanelSMBIOS.add(getJTextFieldPlatformName(), null);
			jPanelSMBIOS.add(jLabel11, null);
			jPanelSMBIOS.add(getJTextFieldBiosVersion(), null);
			jPanelSMBIOS.add(jLabel12, null);
			jPanelSMBIOS.add(getJTextFieldBiosDate(), null);
		}
		return jPanelSMBIOS;
	}

	/**
	 * This method initializes jPanelManifest	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelManifest() {
		if (jPanelManifest == null) {
			jLabel16 = new JLabel();
			jLabel16.setBounds(new Rectangle(57, 270, 179, 17));
			jLabel16.setHorizontalAlignment(SwingConstants.RIGHT);
			jLabel16.setText("Platform Validation Authority");
			jLabel15 = new JLabel();
			jLabel15.setText("Platform Validation Authority");
			jLabel15.setSize(new Dimension(180, 20));
			jLabel15.setHorizontalAlignment(SwingConstants.RIGHT);
			jLabel15.setLocation(new Point(52, 98));
			jLabel14 = new JLabel();
			jLabel14.setHorizontalAlignment(SwingConstants.RIGHT);
			jLabel14.setLocation(new Point(58, 238));
			jLabel14.setSize(new Dimension(180, 20));
			jLabel14.setText("UUID");
			jLabel4 = new JLabel();
			jLabel4.setHorizontalAlignment(SwingConstants.RIGHT);
			jLabel4.setLocation(new Point(57, 210));
			jLabel4.setSize(new Dimension(180, 20));
			jLabel4.setText("Status");
			jLabel3 = new JLabel();
			jLabel3.setBounds(new Rectangle(28, 167, 239, 28));
			jLabel3.setText("Runtime Manifest");
			jLabel2 = new JLabel();
			jLabel2.setHorizontalAlignment(SwingConstants.RIGHT);
			jLabel2.setLocation(new Point(54, 40));
			jLabel2.setSize(new Dimension(180, 20));
			jLabel2.setText("Status");
			jLabel1 = new JLabel();
			jLabel1.setHorizontalAlignment(SwingConstants.RIGHT);
			jLabel1.setLocation(new Point(54, 63));
			jLabel1.setSize(new Dimension(180, 20));
			jLabel1.setText("UUID");
			jLabel13 = new JLabel();
			jLabel13.setBounds(new Rectangle(26, 12, 238, 23));
			jLabel13.setText("Platform Manifest");
			jPanelManifest = new JPanel();
			jPanelManifest.setLayout(null);
			jPanelManifest.add(jLabel13, null);
			jPanelManifest.add(jLabel2, null);
			jPanelManifest.add(getJTextFieldPlatformManifestStatus(), null);
			jPanelManifest.add(jLabel1, null);
			jPanelManifest.add(getJTextFieldPlatformManifestUUID(), null);
			jPanelManifest.add(jLabel15, null);
			jPanelManifest.add(getJComboBoxPlatformManifestPvaUrl(), null);
			jPanelManifest.add(getJRadioButtonKnoppix(), null);
			jPanelManifest.add(getJButtonCreatePlatformManifest(), null);
			jPanelManifest.add(getJButton5(), null);
			jPanelManifest.add(getJButton2(), null);
			jPanelManifest.add(getJButtonViewPlatformManifest(), null);
			jPanelManifest.add(jLabel3, null);
			jPanelManifest.add(jLabel4, null);
			jPanelManifest.add(getJTextFieldRuntimeManifestStatus(), null);
			jPanelManifest.add(jLabel14, null);
			jPanelManifest.add(getJTextFieldRuntimeManifestUUID(), null);
			jPanelManifest.add(jLabel16, null);
			jPanelManifest.add(getJComboBoxRuntimeManifestPvaUrl(), null);
			jPanelManifest.add(getJButton3(), null);
			jPanelManifest.add(getJButton6(), null);
			jPanelManifest.add(getJButton4(), null);
			jPanelManifest.add(getJButtonViewRuntimeManifest(), null);
		}
		return jPanelManifest;
	}

	/**
	 * This method initializes jButtonCreatePlatformManifest	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonCreatePlatformManifest() {
		if (jButtonCreatePlatformManifest == null) {
			jButtonCreatePlatformManifest = new JButton();
			jButtonCreatePlatformManifest.setPreferredSize(new Dimension(100, 20));
			jButtonCreatePlatformManifest.setLocation(new Point(26, 128));
			jButtonCreatePlatformManifest.setSize(new Dimension(120, 30));
			jButtonCreatePlatformManifest.setText("Create/Update");
			jButtonCreatePlatformManifest.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {		
					/* Check RM */
					if (config.isPlatformManifestExist()) {
						int rc = JOptionPane.showConfirmDialog(
								getParent() , 
								"Platform Reference Manifest exist. Update the manifest?" ,
								"Update Manifest?", 
								JOptionPane.YES_NO_OPTION);
						
						if (rc == JOptionPane.YES_OPTION) {
							// UPDATE
							System.out.println("Update Platform Manifest");
							String result = config.createPlatformManifest();
							jTextFieldPlatformManifestStatus.setText(result);
							String uuid = config.getPlatformManifestUUID();
							jTextFieldPlatformManifestUUID.setText(uuid);
						}
						else {
							// Ignore
							System.out.println("Keep current Platform Manifest");
						}
					}
					else {
						// New
						System.out.println("Create New Platform Manifest");
						String result = config.createPlatformManifest();
						jTextFieldPlatformManifestStatus.setText(result);
						String uuid = config.getPlatformManifestUUID();
						jTextFieldPlatformManifestUUID.setText(uuid);
					}
					
				}
			});
		}
		return jButtonCreatePlatformManifest;
	}

	/**
	 * This method initializes jButton2	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton2() {
		if (jButton2 == null) {
			jButton2 = new JButton();
			jButton2.setEnabled(false);
			jButton2.setLocation(new Point(342, 130));
			jButton2.setSize(new Dimension(120, 30));
			jButton2.setText("Validate");
		}
		return jButton2;
	}

	/**
	 * This method initializes jButton3	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton3() {
		if (jButton3 == null) {
			jButton3 = new JButton();
			jButton3.setText("Create/Update");
			jButton3.setSize(new Dimension(120, 30));
			jButton3.setLocation(new Point(26, 311));
			jButton3.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					/* Check RM */
					if (config.isRuntimeManifestExist()) {
						int rc = JOptionPane.showConfirmDialog(
								getParent() , 
								"Runtime Reference Manifest exist. Update the manifest?" ,
								"Update Manifest?", 
								JOptionPane.YES_NO_OPTION);
						
						if (rc == JOptionPane.YES_OPTION) {
							// UPDATE
							System.out.println("Update Runtime Manifest");
							//String result = config.createRuntimeManifest(jRadioButtonKnoppix.isSelected());
							String result = config.createRuntimeManifest(); // ignore jRadioButtonKnoppix
							jTextFieldRuntimeManifestStatus.setText(result);
							String uuid = config.getRuntimeManifestUUID();
							jTextFieldRuntimeManifestUUID.setText(uuid);
						}
						else {
							// Ignore
							System.out.println("Keep current Runtime Manifest");
						}
					}
					else {
						// New 
						System.out.println("Create New Runtime Manifest");
						//String result = config.createRuntimeManifest(jRadioButtonKnoppix.isSelected());
						String result = config.createRuntimeManifest(); // ignore jRadioButtonKnoppix
						jTextFieldRuntimeManifestStatus.setText(result);
						String uuid = config.getRuntimeManifestUUID();
						jTextFieldRuntimeManifestUUID.setText(uuid);
					}
				}
			});
		}
		return jButton3;
	}

	/**
	 * This method initializes jButton4	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton4() {
		if (jButton4 == null) {
			jButton4 = new JButton();
			jButton4.setText("Validate");
			jButton4.setSize(new Dimension(120, 30));
			jButton4.setEnabled(false);
			jButton4.setLocation(new Point(342, 313));
		}
		return jButton4;
	}

	/**
	 * This method initializes jButton5	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton5() {
		if (jButton5 == null) {
			jButton5 = new JButton();
			jButton5.setEnabled(false);
			jButton5.setLocation(new Point(189, 129));
			jButton5.setSize(new Dimension(120, 30));
			jButton5.setText("Submit");
		}
		return jButton5;
	}

	/**
	 * This method initializes jButton6	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton6() {
		if (jButton6 == null) {
			jButton6 = new JButton();
			jButton6.setEnabled(false);
			jButton6.setLocation(new Point(190, 312));
			jButton6.setSize(new Dimension(120, 30));
			jButton6.setText("Submit");
		}
		return jButton6;
	}

	/**
	 * This method initializes jTextFieldPlatformManifestStatus	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldPlatformManifestStatus() {
		if (jTextFieldPlatformManifestStatus == null) {
			jTextFieldPlatformManifestStatus = new JTextField();
			jTextFieldPlatformManifestStatus.setLocation(new Point(248, 39));
			jTextFieldPlatformManifestStatus.setSize(new Dimension(350, 20));
		}
		return jTextFieldPlatformManifestStatus;
	}

	/**
	 * This method initializes jTextFieldPlatformManifestUUID	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldPlatformManifestUUID() {
		if (jTextFieldPlatformManifestUUID == null) {
			jTextFieldPlatformManifestUUID = new JTextField();
			jTextFieldPlatformManifestUUID.setLocation(new Point(249, 66));
			jTextFieldPlatformManifestUUID.setSize(new Dimension(350, 20));
		}
		return jTextFieldPlatformManifestUUID;
	}

	/**
	 * This method initializes jTextFieldRuntimeManifestStatus	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldRuntimeManifestStatus() {
		if (jTextFieldRuntimeManifestStatus == null) {
			jTextFieldRuntimeManifestStatus = new JTextField();
			jTextFieldRuntimeManifestStatus.setLocation(new Point(252, 211));
			jTextFieldRuntimeManifestStatus.setSize(new Dimension(350, 20));
		}
		return jTextFieldRuntimeManifestStatus;
	}

	/**
	 * This method initializes jTextFieldRuntimeManifestUUID	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldRuntimeManifestUUID() {
		if (jTextFieldRuntimeManifestUUID == null) {
			jTextFieldRuntimeManifestUUID = new JTextField();
			jTextFieldRuntimeManifestUUID.setLocation(new Point(252, 239));
			jTextFieldRuntimeManifestUUID.setSize(new Dimension(350, 20));
		}
		return jTextFieldRuntimeManifestUUID;
	}

	/**
	 * This method initializes jTextFieldTcdemoServerUrl	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldTcdemoServerUrl() {
		if (jTextFieldTcdemoServerUrl == null) {
			jTextFieldTcdemoServerUrl = new JTextField();
			jTextFieldTcdemoServerUrl.setBounds(new Rectangle(162, 26, 252, 25));
		}
		return jTextFieldTcdemoServerUrl;
	}

	/**
	 * This method initializes jComboBoxServiceList	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBoxServiceList() {
		if (jComboBoxServiceList == null) {
			jComboBoxServiceList = new JComboBox();
			jComboBoxServiceList.setBounds(new Rectangle(164, 81, 453, 27));
			jComboBoxServiceList.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					int selected = jComboBoxServiceList.getSelectedIndex();
					jTextFieldServiceDescription.setText(config.getServiceDescription(selected));
					jTextFieldServiceAuthType.setText(config.getServiceAuth(selected));

				}
			});
		}
		return jComboBoxServiceList;
	}

	/**
	 * This method initializes jComboBoxPlatformManifestPvaUrl	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBoxPlatformManifestPvaUrl() {
		if (jComboBoxPlatformManifestPvaUrl == null) {
			jComboBoxPlatformManifestPvaUrl = new JComboBox();
			jComboBoxPlatformManifestPvaUrl.setLocation(new Point(247, 98));
			jComboBoxPlatformManifestPvaUrl.setSize(new Dimension(350, 20));
		}
		return jComboBoxPlatformManifestPvaUrl;
	}

	/**
	 * This method initializes jComboBoxRuntimeManifestPvaUrl	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBoxRuntimeManifestPvaUrl() {
		if (jComboBoxRuntimeManifestPvaUrl == null) {
			jComboBoxRuntimeManifestPvaUrl = new JComboBox();
			jComboBoxRuntimeManifestPvaUrl.setLocation(new Point(253, 272));
			jComboBoxRuntimeManifestPvaUrl.setSize(new Dimension(350, 20));
		}
		return jComboBoxRuntimeManifestPvaUrl;
	}

	/**
	 * This method initializes jTextFieldServiceDescription	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldServiceDescription() {
		if (jTextFieldServiceDescription == null) {
			jTextFieldServiceDescription = new JTextField();
			jTextFieldServiceDescription.setBounds(new Rectangle(163, 132, 456, 79));
		}
		return jTextFieldServiceDescription;
	}

	/**
	 * This method initializes jTextFieldServiceAuthType	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldServiceAuthType() {
		if (jTextFieldServiceAuthType == null) {
			jTextFieldServiceAuthType = new JTextField();
			jTextFieldServiceAuthType.setBounds(new Rectangle(164, 231, 453, 37));
		}
		return jTextFieldServiceAuthType;
	}

	/**
	 * This method initializes jButtonViewPlatformManifest	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonViewPlatformManifest() {
		if (jButtonViewPlatformManifest == null) {
			jButtonViewPlatformManifest = new JButton();
			jButtonViewPlatformManifest.setLocation(new Point(495, 130));
			jButtonViewPlatformManifest.setText("View");
			jButtonViewPlatformManifest.setSize(new Dimension(120, 30));
			jButtonViewPlatformManifest.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					config.viewPlatformManifest();
				}
			});
		}
		return jButtonViewPlatformManifest;
	}

	/**
	 * This method initializes jButtonViewRuntimeManifest	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonViewRuntimeManifest() {
		if (jButtonViewRuntimeManifest == null) {
			jButtonViewRuntimeManifest = new JButton();
			jButtonViewRuntimeManifest.setText("View");
			jButtonViewRuntimeManifest.setSize(new Dimension(120, 30));
			jButtonViewRuntimeManifest.setLocation(new Point(489, 314));
			jButtonViewRuntimeManifest.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					config.viewRuntimeManifest();
				}
			});
		}
		return jButtonViewRuntimeManifest;
	}

	/**
	 * This method initializes jPanelIdentitySetup	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelIdentitySetup() {
		if (jPanelIdentitySetup == null) {
			jLabel20 = new JLabel();
			jLabel20.setText("User");
			jLabel20.setSize(new Dimension(100, 30));
			jLabel20.setLocation(new Point(31, 286));
			jLabel19 = new JLabel();
			jLabel19.setText("Key Filename");
			jLabel19.setSize(new Dimension(100, 30));
			jLabel19.setLocation(new Point(25, 157));
			jLabel18 = new JLabel();
			jLabel18.setBounds(new Rectangle(16, 107, 341, 35));
			jLabel18.setText("Create Key and Setup for user");
			jLabel17 = new JLabel();
			jLabel17.setBounds(new Rectangle(21, 15, 331, 28));
			jLabel17.setText("Take Ownership");
			jPanelIdentitySetup = new JPanel();
			jPanelIdentitySetup.setLayout(null);
			jPanelIdentitySetup.add(jLabel17, null);
			jPanelIdentitySetup.add(getJButtonInvokeTPMM(), null);
			jPanelIdentitySetup.add(jLabel18, null);
			jPanelIdentitySetup.add(jLabel19, null);
			jPanelIdentitySetup.add(getJTextFieldSignKeyFilename(), null);
			jPanelIdentitySetup.add(getJRadioButtonSignKeyUpdate(), null);
			jPanelIdentitySetup.add(getJButtonCreateSignKey(), null);
			jPanelIdentitySetup.add(jLabel20, null);
			jPanelIdentitySetup.add(getJTextFieldUserName(), null);
			jPanelIdentitySetup.add(getJButtonSetupUser(), null);
		}
		return jPanelIdentitySetup;
	}

	/**
	 * This method initializes jButtonInvokeTPMM	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonInvokeTPMM() {
		if (jButtonInvokeTPMM == null) {
			jButtonInvokeTPMM = new JButton();
			jButtonInvokeTPMM.setText("Invoke TPM Manager");
			jButtonInvokeTPMM.setSize(new Dimension(300, 40));
			jButtonInvokeTPMM.setLocation(new Point(34, 51));
			jButtonInvokeTPMM.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					
					if (config.invokeTPMManager() == false) {
						// Dialog
						JOptionPane.showConfirmDialog(
								getParent() , 
								config.getErrorMessage(),
								"Error", 
								JOptionPane.DEFAULT_OPTION);//YES_OPTION);

					}
									}
			});
		}
		return jButtonInvokeTPMM;
	}

	/**
	 * This method initializes jTextFieldSignKeyFilename	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldSignKeyFilename() {
		if (jTextFieldSignKeyFilename == null) {
			jTextFieldSignKeyFilename = new JTextField();
			jTextFieldSignKeyFilename.setBounds(new Rectangle(130, 158, 417, 29));
		}
		return jTextFieldSignKeyFilename;
	}

	/**
	 * This method initializes jRadioButtonSignKeyUpdate	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getJRadioButtonSignKeyUpdate() {
		if (jRadioButtonSignKeyUpdate == null) {
			jRadioButtonSignKeyUpdate = new JRadioButton();
			jRadioButtonSignKeyUpdate.setBounds(new Rectangle(38, 197, 186, 21));
			jRadioButtonSignKeyUpdate.setSelected(true);
			jRadioButtonSignKeyUpdate.setEnabled(false);
			jRadioButtonSignKeyUpdate.setText("Update");
		}
		return jRadioButtonSignKeyUpdate;
	}

	/**
	 * This method initializes jButtonCreateSignKey	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonCreateSignKey() {
		if (jButtonCreateSignKey == null) {
			jButtonCreateSignKey = new JButton();
			jButtonCreateSignKey.setText("Create Key for Quote (Attestation)");
			jButtonCreateSignKey.setSize(new Dimension(300, 40));
			jButtonCreateSignKey.setLocation(new Point(26, 224));
			jButtonCreateSignKey.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {					
					config.setSignKeyFilename(jTextFieldSignKeyFilename.getText());
					if (jRadioButtonSignKeyUpdate.isEnabled()) {
						config.setSignKeyUpdateFlag(true);
					}
					else {
						config.setSignKeyUpdateFlag(false);
					}
					if (config.createSignKey(false, null) == false) { // popup
						// Dialog
						JOptionPane.showConfirmDialog(
								getParent() , 
								config.getErrorMessage(),
								"Error", 
								JOptionPane.DEFAULT_OPTION);//YES_OPTION);

					}
				}
			});
		}
		return jButtonCreateSignKey;
	}

	/**
	 * This method initializes jRadioButtonKnoppix	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getJRadioButtonKnoppix() {
		if (jRadioButtonKnoppix == null) {
			jRadioButtonKnoppix = new JRadioButton();
			jRadioButtonKnoppix.setText("Knopppix");
			jRadioButtonKnoppix.setSize(new Dimension(100, 21));
			jRadioButtonKnoppix.setSelected(true);
			jRadioButtonKnoppix.setLocation(new Point(279, 171));
		}
		return jRadioButtonKnoppix;
	}

	/**
	 * This method initializes jTextFieldUserName	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldUserName() {
		if (jTextFieldUserName == null) {
			jTextFieldUserName = new JTextField();
			jTextFieldUserName.setBounds(new Rectangle(137, 287, 267, 27));
		}
		return jTextFieldUserName;
	}

	/**
	 * This method initializes jButtonSetupUser	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonSetupUser() {
		if (jButtonSetupUser == null) {
			jButtonSetupUser = new JButton();
			jButtonSetupUser.setText("Setup local settings for User ");
			jButtonSetupUser.setSize(new Dimension(300, 40));
			jButtonSetupUser.setLocation(new Point(27, 332));
			jButtonSetupUser.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					/* Setup User */
					if (config.setupUser(jTextFieldUserName.getText()) == false) {
						JOptionPane.showConfirmDialog(
								getParent() , 
								config.getErrorMessage(),
								"Error", 
								JOptionPane.DEFAULT_OPTION);//YES_OPTION);

						// TODO  error dialog
					}
					

				}
			});
		}
		return jButtonSetupUser;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		/* Initialize PTS Client */
		
		try {
			config= new Config(args);
			serviceList = config.getServiceList();
			pcrTableRowData = config.getPcrData();		
			eventlogTableRowData = config.getEventlogData();
			username = config.getUsername(0);
			pcVendorName = config.getPcVendorName();
			macineTypeName = config.getMacineTypeName();
			biosVersionName = config.getBiosVersionName();
			tableModelPcr = 
				new DefaultTableModel(pcrTableColumnNames, 0);
			tableModelEventlog = 
				new DefaultTableModel(eventlogTableColumnNames, 0);
		
			/* Treemap Components */
			//String cpFilename="sampleCP.tm3"; // TODO
			//String cpFilename="rpm-qi-data.tm3"; // TODO
			//String cpFilename="sampledata/knoppix511tcg.tm3"; // TODO
			//String cpFilename="../openpts-testsuite/sandbox/knoppix511tcg.tm3"; // TODO
			//String cpFilename="/opt/OpenPlatformTrustServices/tcdemo/sample.tm3";
			//String cpFilename = config.getTM3Filename();
			//BuilderTM3 cpBuilderTM3 = new BuilderTM3(new File(cpFilename));
			//treemapComponentRoot = cpBuilderTM3.getRoot();
			//cpBuilderTM3.setValues("CVSS");
			//cpBuilderTM3.setWeights("LOC");
			//cpBuilderTM3.setWeights("Dependency");
		
			//treeModelCP = new DefaultTreeModel(treemapComponentRoot);
				
			
			
			/* Swing */
			SwingUtilities.invokeLater(new Runnable() {
				public void run() {
					ClientAdmin thisClass = new ClientAdmin();
					thisClass.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
					thisClass.setVisible(true);
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}

	/**
	 * This is the default constructor
	 */
	public ClientAdmin() {
		super();
		initialize();
	}

	protected void updatePlatformInfo() {
		
		/* get new data */
		config.issueGetIml();
		
		/* Update platform metadata */
		this.jTextFieldPlatformVendor.setText(config.getPcVendorName());
		this.jTextFieldPlatformName.setText(config.getMacineTypeName());
		this.jTextFieldBiosVersion.setText(config.getBiosVersionName());
		Date d = config.getBiosData();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
		jTextFieldBiosDate.setText(sdf.format(d));
		
		/* Update PCRs table */
		pcrTableRowData = config.getPcrData();
		// remove existing rows;
		int pRnum = tableModelPcr.getRowCount();
		for (int i=0;i<pRnum;i++) {
			tableModelPcr.removeRow(0);						
		}
		// add new rows
		for(int i = 0 ; i < pcrTableRowData.length ; i++){
			 String [] row = pcrTableRowData[i];
			 tableModelPcr.addRow(row);	
		}
		jTablePcrs.revalidate();
		jTablePcrs.repaint();
		
		
		/* Update eventlog table */
		eventlogTableRowData = config.getEventlogData();
		// remove existing rows;
		int rnum = tableModelEventlog.getRowCount();
		for (int i=0;i<rnum;i++) {
			tableModelEventlog.removeRow(0);						
		}
		// add new rows
		for(int i = 0 ; i < eventlogTableRowData.length ; i++){
			 String [] row = eventlogTableRowData[i];
			 tableModelEventlog.addRow(row);	
		}
		jTableEventlog.revalidate();
		jTableEventlog.repaint();
		
		// TODO Auto-generated method stub
		
	}

	protected void updateService() {
		this.jTextFieldTcdemoServerUrl.setText(config.getServerName());
		this.jComboBoxServiceList.removeAllItems();
		String[] serviceList = config.getServiceListByURL();
		for (int i=0;i<serviceList.length;i++) {
			this.jComboBoxServiceList.addItem(serviceList[i]);
		}
		this.jTextFieldServiceDescription.setText(config.getServiceDescription(0));
		this.jTextFieldServiceAuthType.setText(config.getServiceAuth(0));
		
	}

	/**
	 * To avoid unstable Visual Editor, 
	 * use single method
	 * 
	 *
	 */
	private void updatePanels() {
		
		/* Panel - Platform Info */
		updatePlatformInfo();
		
		/* Panel - Reference Manifest */
		this.jTextFieldPlatformManifestStatus.setText(config.getPlatformManifestStatus());
		this.jTextFieldPlatformManifestUUID.setText(config.getPlatformManifestUUID());
		this.jTextFieldRuntimeManifestStatus.setText(config.getRuntimeManifestStatus());
		this.jTextFieldRuntimeManifestUUID.setText(config.getRuntimeManifestUUID());
		
		/* Panel - Identity Setup */
		this.jTextFieldSignKeyFilename.setText(config.getSignKeyFilename());
		this.jTextFieldUserName.setText(config.getUserName());
		/* Panel - Service */
		updateService();		
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(661, 489);
		this.setMaximumSize(new Dimension(640, 480));
		this.setContentPane(getJPanel());
		this.setJMenuBar(getJJMenuBar());
		this.setTitle("Platform Trust Service - Client (Debug)");
		
		updatePanels();

	}

}  //  @jve:decl-index=0:visual-constraint="1,-9"
