/*
 * 
 * Licensed Materials - Property of IBM
 *
 * Open Platform Trust Services - An open source TCG PTS
 *
 * (C) Copyright International Business Machines Corp. 2008
 *
 */
package tcdemo.cmd;

import java.io.BufferedReader;
import java.io.Console;
import java.io.InputStreamReader;

import tcdemo.Config;

/**
 * Setup the devices
 * 
 * 1) Create RM
 * 2) 
 * 
 * 
 * @author Seiji Munetoh 
 *
 */
public class ClientAdmin {
	private static Config config;
	//private static String[] serviceList;
	//private static String[][] pcrTableRowData;
	//private static String[][] eventlogTableRowData;
	//private static String username;
	//private static String pcVendorName;
	//private static String macineTypeName;
	//private static String biosVersionName;
	//private static String lookAndFeel;
	private static String userName;

	private static void usage(String[] args) {
		System.out.println("\nUsage: ClientAdmin [OPTIONS]");
		System.out.println(" OPTIONS");
		System.out.println("\t--propdir DIRNAME");
		System.out.println("\t\tSlect properties location");
		System.out.println("\t--auth PASSWORD");
		System.out.println("\t\tSet user password");
		System.out.println("\t--popup");
		System.out.println("\t\tSet user password by popup dialog");
		System.out.println("\t--verbose");
		System.out.println("\t\tVerbose mode");
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		/* default args */
		String[] initArgs = {
				"--propdir",
				"/opt/OpenPlatformTrustServices/tcdemo",
		};
		String password = null;
		boolean verbose = false;
		boolean popup = false;
		
		/* check the args */
		for (int i=0; i<args.length; ++i) {
            if ("--propdir".equals(args[i])) {
            	initArgs[1] = args[++i];
            } 
            else if ("--auth".equals(args[i])) {
            	password = args[++i];
            }
            else if ("--verbose".equals(args[i])) {
            	verbose = true;
            }
            else if ("--popup".equals(args[i])) {
            	popup = true;
            }
            else {
            	System.err.println("ERROR: Bad option " + args[i]);
            	usage(args);
            	return;
            }
        }
		
		
		/* */
		try {
			config= new Config(initArgs);
			if (verbose) { 
				config.setVerbose(true);
			} else {
				config.setVerbose(false); // since the default is verbose for debug
			}

			userName = config.getUserName();
			//boolean knoppix = false;
						
			/* Print current configurations */
			
			/* get fresh IML */
			config.getiml2(initArgs[1]);
			
			/* Update Reference Manifests */
			config.createPlatformManifest();
			//config.createRuntimeManifest(knoppix);
			config.createRuntimeManifest();
			
			
			/* Setup user */
			if ((password == null) && (popup == false)) {
				System.out.print("Enter user's password:");
				// JDK6, supported by  GCJ?
				//Console console = System.console();
				// JDK5, GCJ				
				BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
				password = br.readLine();
			}
			
			//boolean popup = false;
			boolean rc;
			rc = config.createSignKey(popup,password);

			if (rc == false) {
				System.err.println("ERROR: can't create the sign key");
				return;
			}
			rc = config.setupUser(userName);
			if (rc == false) {
				System.err.println("ERROR: can't setup the user " + userName);
				return;
			}
			
						
		} catch (Exception e) {
			// TODO Auto-generated catch block
			System.err.println(" Exception from Config ");
			e.printStackTrace();
		}
	}

}
