package com.ibm.trl.tcg.pts.eventlog;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

import com.ibm.trl.tcg.pts.tools.HexTool;

public class PCRS {

	private byte[][] pcrs;
	private int pcrNum;

	//public void loadfile(String pcrsFilename) throws Exception {
	public void loadfile(String pcrsFilename)  {
		
		try {
			pcrs = new byte[24][20];
			FileReader in;
			in = new FileReader(pcrsFilename);
			BufferedReader br = new BufferedReader(in);
			String line;
			int pcrIndex = 0;
			while ((line = br.readLine()) != null) {
				// System.out.println(line);
				String[] sp = line.split(" ");
				for (int i = 0; i < 20; i++) {
					int si = HexTool.getByte(sp[1 + i]);
					pcrs[pcrIndex][i] = (byte) si;
				}
				pcrIndex++;
			}
			br.close();
			in.close();

			pcrNum = pcrIndex;
		} catch (FileNotFoundException e) {
			System.err.println("ERROR file not found " + pcrsFilename);
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	public byte[][] getByteArray() {
		byte [][] out = new byte[pcrNum][20];
		for (int i=0;i<pcrNum;i++) {
			System.arraycopy(pcrs[i], 0, out[i], 0, 20);
		}
		return out;
	}

	public int size() {
		return pcrNum;
	}

}
