#!/usr/bin/perl

##
## Licensed Materials - Property of IBM
## Open Platform Trust Services - An open source TCG PTS
## (C) Copyright International Business Machines Corp. 2007
##


$RPMA = "rpm -qa";
$RPMI = "export LANG=C; rpm -qi";
$RPMQ = "export LANG=C; rpmquery --whatrequires";

$FILENAME = "tm3-data.txt";
$count = 0;

if(@ARGV < 1){
	print "USAGE: perl $0 [output dir (optional)]\n\n";
} else {
	$DIR = $ARGV[0];
	if(!-d $DIR){
		mkdir $DIR;
	}
}

@lines = `$RPMA`;

foreach $line(@lines){
	#print "> $line";

	##
	## File
	##

	if(@ARGV < 1){
		open(DATA, ">> $FILENAME");
	} else {
		open(DATA, ">> $DIR/$FILENAME");
	}

	##
	## rpm -qi
	##

	@contents = `$RPMI $line`;
	foreach $content(@contents){

		&replaceLabel($content);
		#print "$content";
		@parts = split(/\ :\ /, $content);

		for($i = 0; $i < $#parts; $i++){
			$parts[$i] =~ s/[\r\s\t]//i;
			$parts[$i] =~ s/ +$//;

			if($parts[$i] eq "Name"){
				$count++;
				print DATA "\nName.$count=$parts[$i+1]\n";

				##
				## rpmquery --whatrequires
				##
			
				@reqs = `$RPMQ $parts[$i+1]`;
				$num = $#reqs+1;
				if(index("$reqs[0]", "no package requires") >= 0){
				} else {
					print DATA "Required_Num.$count=$num\n";
					foreach $req(@reqs){
						$req =~ s/[\r\s\t\n]//i;
						$pkgs = "$pkgs $req";
					}
					print DATA "Required_Packages.$count=$pkgs\n";
					$pkgs = "";
				}

				$i++;
			} elsif ($parts[$i] eq "Version") {
				print DATA "Version.$count=$parts[$i+1]\n";
				$i++;
			} elsif ($parts[$i] eq "Release") {
				print DATA "Release.$count=$parts[$i+1]\n";
				$i++;
			} elsif ($parts[$i] eq "Install_Date") {
				$i++;
			} elsif ($parts[$i] eq "Group") {
				@groups = split(/\//, $parts[$i+1]);
				print DATA "MajorGroup.$count=$groups[0]\n";
				print DATA "MinorGroup.$count=$groups[1]\n";
				$i++;
			} elsif ($parts[$i] eq "Size") {
				print DATA "Size.$count=$parts[$i+1]\n";
				$i++;
			} elsif ($parts[$i] eq "Signature") {
				$i++;
			} elsif ($parts[$i] eq "Packager") {
				$i++;
			} elsif ($parts[$i] eq "URL") {
				$i++;
			} elsif ($parts[$i] eq "Summary") {
				$i++;
			} elsif ($parts[$i] eq "Description") {
				$i++;
			} elsif ($parts[$i] eq "Relocations") {
				$i++;
			} elsif ($parts[$i] eq "Vendor") {
				$i++;
			} elsif ($parts[$i] eq "Build_Date") {
				print DATA "Build_Date.$count=$parts[$i+1]";
				$i++;
			} elsif ($parts[$i] eq "Build_Host") {
				$i++;
			} elsif ($parts[$i] eq "Source_RPM") {
				$i++;
			} elsif ($parts[$i] eq "License") {
				$i++;
			} else {
			}
		}
	}


	close(DATA);
}

sub replaceLabel(){
	$content =~ s/Relocations:/ : Relocations :/i;
	$content =~ s/Vendor:/ : Vendor :/i;
	$content =~ s/Build Date:/ : Build_Date :/i;
	$content =~ s/Build Host:/ : Build_Host :/i;
	$content =~ s/Source RPM:/ : Source_RPM :/i;
	$content =~ s/License:/ : License :/i;
#	$content =~ s/Name        :/ : Name :/i;
#	$content =~ s/Version     :/ : Version :/i;
#	$content =~ s/Release     :/ : Release :/i;
	$content =~ s/Install Date:/Install_Date :/i;
#	$content =~ s/Group       :/ : Group :/i;
#	$content =~ s/Size        :/ : Size :/i;
#	$content =~ s/Signature   :/ : Signature :/i;
#	$content =~ s/Packager    :/ : Packager :/i;
#	$content =~ s/URL         :/ : URL :/i;
#	$content =~ s/Summary     :/ : Summary :/i;
#	$content =~ s/Description :/ : Description :/i;
}


