#!/bin/sh
#
# sh sql/create1db.sh $DBUSER $DBPASSWD $DBNAME $DBTABLE $DBROOT_PWD
# sh create1db.sh $DBADMIN $DBADMIN_PWD $DBUSER $DBUSER_PWD $IIDB_NAME $DBTYPE/schema/iidb_createtables.sql

DBADMIN=$1
DBADMIN_PWD=$2

DBUSER=$3
DBUSER_PWD=$4

DBNAME=$5
DBTABLE=$6

#
#  Usage
#
if [ $# -lt 6 ]
then
	#echo "> sh sql/create1db.sh DBADMIN DBADMIN_PWD DBUSER DBUSER_PWD DBNAME DBTABLE "
	exit
fi


##
## Create Database
##
echo ""
echo "Create database for $DBNAME? y/n"
read CREATEDB

if [ $CREATEDB = "y" ]
then
	mysqladmin -u root -p$DBROOT_PWD create $DBNAME
else
	exit
fi


# Create Tables
if [ -f $DBTABLE ]; then
	echo "Create table in $DBNAME ($DBUSER)"
	mysql -u $DBUSER -p$DBPASSWD $DBNAME < $DBTABLE
else
	echo "mysql -u $DBUSER -p$DBPASSWD $DBNAME < $DBTABLE"
fi

